/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiAlias;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.AliasQuery;
import dev.emi.emi.search.LogicalAndQuery;
import dev.emi.emi.search.LogicalOrQuery;
import dev.emi.emi.search.NameQuery;
import dev.emi.emi.search.Query;
import dev.emi.emi.search.QueryType;
import dev.emi.emi.search.SearchStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_1128;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EmiSearch {
    public static final Pattern TOKENS = Pattern.compile("-?[@#$]?(\\/(\\\\.|[^\\\\\\/])+\\/|\\\"(\\.|[^\\\"])+\\\"|[^\\s|]+|\\||\\&)");
    private static volatile SearchWorker currentWorker = null;
    public static volatile Thread searchThread = null;
    public static volatile List<? extends EmiIngredient> stacks = EmiStackList.stacks;
    public static volatile CompiledQuery compiledQuery;
    public static Set<EmiStack> bakedStacks;
    public static class_1128<SearchStack> names;
    public static class_1128<SearchStack> tooltips;
    public static class_1128<SearchStack> mods;
    public static class_1128<EmiStack> aliases;

    public static void bake() {
        class_1128 names = new class_1128();
        class_1128 tooltips = new class_1128();
        class_1128 mods = new class_1128();
        class_1128 aliases = new class_1128();
        Set bakedStacks = Sets.newIdentityHashSet();
        boolean old = EmiConfig.appendItemModId;
        EmiConfig.appendItemModId = false;
        for (EmiStack emiStack : EmiStackList.stacks) {
            try {
                class_2960 id;
                List<class_2561> tooltip;
                SearchStack searchStack = new SearchStack(emiStack);
                bakedStacks.add(emiStack);
                class_2561 name = NameQuery.getText(emiStack);
                if (name != null) {
                    names.method_4806((Object)searchStack, name.getString().toLowerCase());
                }
                if ((tooltip = emiStack.getTooltipText()) != null) {
                    for (int i = 1; i < tooltip.size(); ++i) {
                        class_2561 text = tooltip.get(i);
                        if (text == null) continue;
                        tooltips.method_4806((Object)searchStack, text.getString().toLowerCase());
                    }
                }
                if ((id = emiStack.getId()) != null) {
                    mods.method_4806((Object)searchStack, EmiUtil.getModName(id.method_12836()).toLowerCase());
                    mods.method_4806((Object)searchStack, id.method_12836().toLowerCase());
                    names.method_4806((Object)searchStack, id.method_12832().toLowerCase());
                }
                if (emiStack.getItemStack().method_7909() != class_1802.field_8598) continue;
                for (class_1887 e : class_1890.method_8222((class_1799)emiStack.getItemStack()).keySet()) {
                    class_2960 eid = EmiPort.getEnchantmentRegistry().method_10221((Object)e);
                    if (eid == null || eid.method_12836().equals("minecraft")) continue;
                    mods.method_4806((Object)searchStack, EmiUtil.getModName(eid.method_12836()).toLowerCase());
                }
            }
            catch (Exception e) {
                EmiLog.error("EMI caught an exception while baking search for " + String.valueOf(emiStack), e);
            }
        }
        for (Supplier supplier : EmiData.aliases) {
            EmiAlias alias = (EmiAlias)supplier.get();
            for (String key : alias.keys()) {
                if (!class_1074.method_4663((String)key)) {
                    EmiReloadLog.warn("Untranslated alias " + key);
                }
                String text = class_1074.method_4662((String)key, (Object[])new Object[0]).toLowerCase();
                for (EmiIngredient ing : alias.stacks()) {
                    for (EmiStack stack : ing.getEmiStacks()) {
                        aliases.method_4806((Object)stack.copy().comparison(EmiPort.compareStrict()), text);
                    }
                }
            }
        }
        for (EmiAlias.Baked baked : EmiStackList.registryAliases) {
            for (class_2561 text : baked.text()) {
                for (EmiIngredient ing : baked.stacks()) {
                    for (EmiStack stack : ing.getEmiStacks()) {
                        aliases.method_4806((Object)stack.copy().comparison(EmiPort.compareStrict()), text.getString().toLowerCase());
                    }
                }
            }
        }
        EmiConfig.appendItemModId = old;
        names.method_4807();
        tooltips.method_4807();
        mods.method_4807();
        aliases.method_4807();
        EmiSearch.names = names;
        EmiSearch.tooltips = tooltips;
        EmiSearch.mods = mods;
        EmiSearch.aliases = aliases;
        EmiSearch.bakedStacks = bakedStacks;
    }

    public static void update() {
        EmiSearch.search(EmiScreenManager.search.method_1882());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void search(String query) {
        Class<EmiSearch> clazz = EmiSearch.class;
        synchronized (EmiSearch.class) {
            SearchWorker worker;
            currentWorker = worker = new SearchWorker(query, EmiScreenManager.getSearchSource());
            searchThread = new Thread(worker);
            searchThread.setDaemon(true);
            searchThread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(SearchWorker worker, List<? extends EmiIngredient> stacks) {
        Class<EmiSearch> clazz = EmiSearch.class;
        synchronized (EmiSearch.class) {
            if (worker == currentWorker) {
                EmiSearch.stacks = stacks;
                currentWorker = null;
                searchThread = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static class SearchWorker
    implements Runnable {
        private final String query;
        private final List<? extends EmiIngredient> source;

        public SearchWorker(String query, List<? extends EmiIngredient> source) {
            this.query = query;
            this.source = source;
        }

        @Override
        public void run() {
            try {
                CompiledQuery compiled;
                compiledQuery = compiled = new CompiledQuery(this.query);
                if (compiled.isEmpty()) {
                    EmiSearch.apply(this, this.source);
                    return;
                }
                ArrayList stacks = Lists.newArrayList();
                int processed = 0;
                for (EmiIngredient emiIngredient : this.source) {
                    EmiStack es;
                    List<EmiStack> ess;
                    if (processed++ >= 1024) {
                        processed = 0;
                        if (this != currentWorker) {
                            return;
                        }
                    }
                    if ((ess = emiIngredient.getEmiStacks()).size() != 1 || !compiled.test(es = ess.get(0))) continue;
                    stacks.add(emiIngredient);
                }
                EmiSearch.apply(this, List.copyOf(stacks));
            }
            catch (Exception e) {
                EmiLog.error("Error when attempting to search:", e);
            }
        }
    }

    public static class CompiledQuery {
        public final Query fullQuery;

        public CompiledQuery(String query) {
            ArrayList full = Lists.newArrayList();
            ArrayList queries = Lists.newArrayList();
            Matcher matcher = TOKENS.matcher(query);
            while (matcher.find()) {
                String q = matcher.group();
                boolean negated = q.startsWith("-");
                if (negated) {
                    q = q.substring(1);
                }
                if (q.isEmpty() || q.equals("&")) continue;
                if (q.equals("|")) {
                    if (queries.isEmpty()) continue;
                    full.add(new LogicalAndQuery(queries));
                    queries = Lists.newArrayList();
                    continue;
                }
                QueryType type = QueryType.fromString(q);
                Function<String, Query> constructor = type.queryConstructor;
                Function<String, Query> regexConstructor = type.regexQueryConstructor;
                if (type == QueryType.DEFAULT) {
                    ArrayList constructors = Lists.newArrayList();
                    ArrayList regexConstructors = Lists.newArrayList();
                    constructors.add(constructor);
                    regexConstructors.add(regexConstructor);
                    if (EmiConfig.searchTooltipByDefault) {
                        constructors.add(QueryType.TOOLTIP.queryConstructor);
                        regexConstructors.add(QueryType.TOOLTIP.regexQueryConstructor);
                    }
                    if (EmiConfig.searchModNameByDefault) {
                        constructors.add(QueryType.MOD.queryConstructor);
                        regexConstructors.add(QueryType.MOD.regexQueryConstructor);
                    }
                    if (EmiConfig.searchTagsByDefault) {
                        constructors.add(QueryType.TAG.queryConstructor);
                        regexConstructors.add(QueryType.TAG.regexQueryConstructor);
                    }
                    constructors.add(AliasQuery::new);
                    if (constructors.size() > 1) {
                        constructor = name -> new LogicalOrQuery(constructors.stream().map(c -> (Query)c.apply(name)).toList());
                        regexConstructor = name -> new LogicalOrQuery(regexConstructors.stream().map(c -> (Query)c.apply(name)).toList());
                    }
                }
                CompiledQuery.addQuery(q.substring(type.prefix.length()), negated, queries, constructor, regexConstructor);
            }
            if (!queries.isEmpty()) {
                full.add(new LogicalAndQuery(queries));
            }
            this.fullQuery = !full.isEmpty() ? new LogicalOrQuery(full) : null;
        }

        public boolean isEmpty() {
            return this.fullQuery == null;
        }

        public boolean test(EmiStack stack) {
            if (this.fullQuery == null) {
                return true;
            }
            if (bakedStacks.contains(stack)) {
                return this.fullQuery.matches(stack);
            }
            return this.fullQuery.matchesUnbaked(stack);
        }

        private static void addQuery(String s, boolean negated, List<Query> queries, Function<String, Query> normal, Function<String, Query> regex) {
            Query q = s.length() > 1 && s.startsWith("/") && s.endsWith("/") ? regex.apply(s.substring(1, s.length() - 1)) : (s.length() > 1 && s.startsWith("\"") && s.endsWith("\"") ? normal.apply(s.substring(1, s.length() - 1)) : normal.apply(s));
            q.negated = negated;
            queries.add(q);
        }
    }
}

