/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_793;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.util.CacheUtil;
import org.embeddedt.modernfix.util.LambdaMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1092.class})
@ClientOnlyMixin
public class ModelManagerMixin {
    @Shadow
    private Map<class_2960, class_1087> field_5408;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectDummyBakedRegistry(CallbackInfo ci) {
        if (this.field_5408 == null) {
            this.field_5408 = new HashMap<class_2960, class_1087>();
        }
    }

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelManager;loadBlockModels(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Map<class_2960, class_793>> deferBlockModelLoad(class_3300 manager, Executor executor) {
        LoadingCache<class_2960, class_793> cache = CacheUtil.simpleCacheForLambda(location -> this.loadSingleBlockModel(manager, (class_2960)location), 100L);
        return CompletableFuture.completedFuture(new LambdaMap<class_2960, class_793>(location -> (class_793)cache.getUnchecked(location)));
    }

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelManager;loadBlockStates(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Map<class_2960, List<class_1088.class_7777>>> deferBlockStateLoad(class_3300 manager, Executor executor) {
        LoadingCache<class_2960, List> cache = CacheUtil.simpleCacheForLambda(location -> this.loadSingleBlockState(manager, (class_2960)location), 100L);
        return CompletableFuture.completedFuture(new LambdaMap<class_2960, List>(location -> (List)cache.getUnchecked(location)));
    }

    @Redirect(method={"loadModels"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<class_2680> skipCollection(class_2689<class_2248, class_2680> definition) {
        return ImmutableList.of();
    }

    private class_793 loadSingleBlockModel(class_3300 manager, class_2960 location) {
        return manager.method_14486(location).map(resource -> {
            class_793 class_7932;
            block8: {
                BufferedReader reader = resource.method_43039();
                try {
                    class_7932 = class_793.method_3437((Reader)reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ModernFix.LOGGER.error("Couldn't load model", (Throwable)e);
                        return null;
                    }
                }
                reader.close();
            }
            return class_7932;
        }).orElse(null);
    }

    private List<class_1088.class_7777> loadSingleBlockState(class_3300 manager, class_2960 location) {
        return manager.method_14489(location).stream().map(resource -> {
            class_1088.class_7777 class_77772;
            block8: {
                BufferedReader reader = resource.method_43039();
                try {
                    class_77772 = new class_1088.class_7777(resource.method_14480(), (JsonElement)class_3518.method_15255((Reader)reader));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ModernFix.LOGGER.error("Couldn't load blockstate", (Throwable)e);
                        return null;
                    }
                }
                reader.close();
            }
            return class_77772;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

