/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5242;

public class KitCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.KIT.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kit").requires(FTBEConfig.KIT.enabledAndOp())).then(class_2170.method_9247((String)"create_from_player_inv").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommands.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", false))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), false)))))).then(class_2170.method_9247((String)"create_from_player_hotbar").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommands.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", true))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), true)))))).then(class_2170.method_9247((String)"create_from_block_inv").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommands.createKitFromBlock((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.createKitFromBlock((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.deleteKit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"list").executes(ctx -> KitCommands.listKits((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"show").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.showKit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.giveKit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_2186.method_9312((CommandContext)ctx, (String)"players"))))))).then(class_2170.method_9247((String)"put_in_block_inv").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.putKitInBlockInv((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"cooldown").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.modifyCooldown((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(class_2170.method_9247((String)"reset_cooldown").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.resetCooldowns((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> KitCommands.resetCooldowns((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_2186.method_9315((CommandContext)ctx, (String)"player"))))).then(class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).executes(ctx -> KitCommands.resetCooldowns((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_5242.method_27645((CommandContext)ctx, (String)"id"))))))).then(class_2170.method_9247((String)"set_autogrant").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).then(class_2170.method_9244((String)"grant", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> KitCommands.modifyAutogrant((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"grant")))))));
        }
    }

    private static int putKitInBlockInv(class_2168 source, String kitName) {
        try {
            class_3222 player = source.method_9207();
            class_3965 res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> new IllegalArgumentException("No such kit: " + kitName));
            if (!InventoryUtil.putItemsInInventory(kit.getItems(), player.method_37908(), res.method_17777(), res.method_17780())) {
                throw new RuntimeException("Not enough space");
            }
            source.method_9226(() -> class_2561.method_43470((String)("Added item(s) from kit '" + kitName + "' to focused inventory")).method_27692(class_124.field_1054), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't store kit in inventory: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
    }

    private static CompletableFuture<Suggestions> suggestKits(SuggestionsBuilder builder) {
        return class_2172.method_9265(KitManager.getInstance().allKits().stream().map(Kit::getKitName).toList(), (SuggestionsBuilder)builder);
    }

    private static int createKitFromPlayer(class_2168 source, String name, String cooldown, boolean hotbarOnly) {
        try {
            long secs = DurationInfo.getSeconds(cooldown);
            KitManager.getInstance().createFromPlayerInv(name, source.method_9207(), secs, hotbarOnly);
            source.method_9226(() -> class_2561.method_43470((String)("Kit '" + name + "' created")).method_27692(class_124.field_1054), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't create kit: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
        return 1;
    }

    private static int createKitFromBlock(class_2168 source, String name, String cooldown) {
        try {
            long secs = DurationInfo.getSeconds(cooldown);
            class_3222 player = source.method_9207();
            class_3965 res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            KitManager.getInstance().createFromBlockInv(name, player.method_37908(), res.method_17777(), res.method_17780(), secs);
            source.method_9226(() -> class_2561.method_43470((String)("Kit '" + name + "' created")).method_27692(class_124.field_1054), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't create kit: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
        return 1;
    }

    private static int giveKit(class_2168 source, String name, Collection<class_3222> players) {
        try {
            players.forEach(player -> KitManager.getInstance().giveKitToPlayer(name, (class_3222)player));
            source.method_9226(() -> class_2561.method_43470((String)("Kit '" + name + "' given to " + players.size() + " player(s)")).method_27692(class_124.field_1054), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't give kit to player: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
        return 1;
    }

    private static int listKits(class_2168 source) {
        Collection<Kit> kits = KitManager.getInstance().allKits();
        source.method_9226(() -> class_2561.method_43470((String)(kits.size() + " kit(s)")).method_27692(class_124.field_1075), false);
        kits.stream().sorted(Comparator.comparing(Kit::getKitName)).forEach(kit -> source.method_9226(() -> class_2561.method_43470((String)("\u2022 " + kit.getKitName())).method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_11750, "/kit show " + kit.getKitName()))), false));
        return 1;
    }

    private static int showKit(class_2168 source, String kitName) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            source.method_9226(() -> class_2561.method_43470((String)Strings.repeat((char)'-', (int)40)).method_27692(class_124.field_1060), false);
            source.method_9226(() -> class_2561.method_43470((String)"Kit Name: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)kit.getKitName()).method_27692(class_124.field_1054)), false);
            if (kit.getCooldown() > 0L) {
                source.method_9226(() -> class_2561.method_43470((String)"  Cooldown: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)TimeUtils.prettyTimeString((long)kit.getCooldown())).method_27692(class_124.field_1054)), false);
            } else if (kit.getCooldown() == 0L) {
                source.method_9226(() -> class_2561.method_43470((String)"  No Cooldown").method_27692(class_124.field_1075), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"  One-Time Use").method_27692(class_124.field_1075), false);
            }
            if (kit.isAutoGrant()) {
                source.method_9226(() -> class_2561.method_43470((String)"  Autogranted on player login").method_27692(class_124.field_1075), false);
            }
            source.method_9226(() -> class_2561.method_43470((String)"  Items:").method_27692(class_124.field_1075), false);
            for (class_1799 stack : kit.getItems()) {
                source.method_9226(() -> class_2561.method_43470((String)"  \u2022 ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(stack.method_7947() + " x ")).method_27692(class_124.field_1068)).method_10852(stack.method_7954()), false);
            }
        }, () -> source.method_9213((class_2561)class_2561.method_43470((String)("No such kit: " + kitName)).method_27692(class_124.field_1061)));
        return 1;
    }

    private static int deleteKit(class_2168 source, String kitName) {
        try {
            KitManager.getInstance().deleteKit(kitName);
            source.method_9226(() -> class_2561.method_43470((String)("Kit '" + kitName + "' deleted")).method_27692(class_124.field_1054), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't delete kit '" + kitName + "': " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
        return 1;
    }

    private static int modifyAutogrant(class_2168 source, String kitName, boolean grant) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            KitManager.getInstance().addKit(kit.withAutoGrant(grant), true);
            source.method_9226(() -> class_2561.method_43470((String)("Kit '" + kitName + "' autogrant modified: " + grant)).method_27692(class_124.field_1054), false);
        }, () -> source.method_9213((class_2561)class_2561.method_43470((String)("No such kit: " + kitName)).method_27692(class_124.field_1061)));
        return 1;
    }

    private static int modifyCooldown(class_2168 source, String kitName, String cooldown) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            long secs = DurationInfo.getSeconds(cooldown);
            KitManager.getInstance().addKit(kit.withCooldown(secs), true);
            String newTime = secs < 0L ? "One-Time Use" : TimeUtils.prettyTimeString((long)secs);
            source.method_9226(() -> class_2561.method_43470((String)("Kit '" + kitName + "' cooldown modified: " + newTime)).method_27692(class_124.field_1054), false);
        }, () -> source.method_9213((class_2561)class_2561.method_43470((String)("No such kit: " + kitName)).method_27692(class_124.field_1061)));
        return 1;
    }

    private static int resetCooldowns(class_2168 source, String name, class_3222 player) {
        return KitCommands.resetCooldowns(source, name, player.method_5667());
    }

    private static int resetCooldowns(class_2168 source, String name, UUID playerId) {
        if (KitManager.getInstance().get(name).isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown kit: " + name)).method_27692(class_124.field_1061));
            return 0;
        }
        if (!FTBEPlayerData.playerExists(playerId)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown player ID: " + String.valueOf(playerId))).method_27692(class_124.field_1061));
            return 0;
        }
        FTBEPlayerData.getOrCreate(new GameProfile(playerId, "")).ifPresent(data -> {
            data.setLastKitUseTime(name, 0L);
            source.method_9226(() -> class_2561.method_43470((String)("Cooldown for '" + name + "' reset for UUID " + String.valueOf(playerId))).method_27692(class_124.field_1054), false);
        });
        return 1;
    }

    private static int resetCooldowns(class_2168 source, String name) {
        if (KitManager.getInstance().get(name).isPresent()) {
            FTBEPlayerData.cleanupKitCooldowns(name);
            source.method_9226(() -> class_2561.method_43470((String)("Cooldown for '" + name + "' reset for all players")).method_27692(class_124.field_1054), false);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)("Unknown kit: " + name)).method_27692(class_124.field_1061));
        return 0;
    }
}

