/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.authlib.GameProfile;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.net.UpdateTabNameMessage;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FTBEPlayerData {
    private static final Map<UUID, FTBEPlayerData> MAP = new HashMap<UUID, FTBEPlayerData>();
    private final UUID uuid;
    private final String name;
    private boolean needSave;
    private boolean muted;
    private boolean canFly;
    private boolean god;
    private String nick;
    private TeleportPos lastSeenPos;
    private final SavedTeleportManager.HomeManager homes;
    private RecordingStatus recording;
    private final Map<String, Long> kitUseTimes;
    public final WarmupCooldownTeleporter backTeleporter;
    public final WarmupCooldownTeleporter spawnTeleporter;
    public final WarmupCooldownTeleporter warpTeleporter;
    public final WarmupCooldownTeleporter homeTeleporter;
    public final WarmupCooldownTeleporter tpaTeleporter;
    public final WarmupCooldownTeleporter rtpTeleporter;
    public final LinkedList<TeleportPos> teleportHistory;

    public FTBEPlayerData(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.needSave = false;
        this.muted = false;
        this.canFly = false;
        this.god = false;
        this.nick = "";
        this.lastSeenPos = new TeleportPos((class_5321<class_1937>)class_1937.field_25179, class_2338.field_10980);
        this.recording = RecordingStatus.NONE;
        this.kitUseTimes = new HashMap<String, Long>();
        this.homes = new SavedTeleportManager.HomeManager(this);
        this.backTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.BACK::getCooldown, FTBEConfig.BACK::getWarmup, true);
        this.spawnTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.SPAWN::getCooldown, FTBEConfig.SPAWN::getWarmup);
        this.warpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.WARP::getCooldown, FTBEConfig.WARP::getWarmup);
        this.homeTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.HOME::getCooldown, FTBEConfig.HOME::getWarmup);
        this.tpaTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.TPA::getCooldown, FTBEConfig.TPA::getWarmup);
        this.rtpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.RTP::getCooldown, FTBEConfig.RTP::getWarmup);
        this.teleportHistory = new LinkedList();
    }

    public static void cleanupKitCooldowns(String kitName) {
        MAP.values().forEach(data -> data.setLastKitUseTime(kitName, 0L));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        if (muted != this.muted) {
            this.muted = muted;
            this.markDirty();
        }
    }

    public boolean canFly() {
        return this.canFly;
    }

    public void setCanFly(boolean canFly) {
        if (canFly != this.canFly) {
            this.canFly = canFly;
            this.markDirty();
        }
    }

    public boolean isGod() {
        return this.god;
    }

    public void setGod(boolean god) {
        if (god != this.god) {
            this.god = god;
            this.markDirty();
        }
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        if (!nick.equals(this.nick)) {
            this.nick = nick;
            this.markDirty();
        }
    }

    public TeleportPos getLastSeenPos() {
        return this.lastSeenPos;
    }

    public void setLastSeenPos(TeleportPos lastSeenPos) {
        this.lastSeenPos = lastSeenPos;
        this.markDirty();
    }

    public RecordingStatus getRecording() {
        return this.recording;
    }

    public void setRecording(RecordingStatus recording) {
        if (recording != this.recording) {
            this.recording = recording;
            this.markDirty();
        }
    }

    public SavedTeleportManager.HomeManager homeManager() {
        return this.homes;
    }

    public static Optional<FTBEPlayerData> getOrCreate(@Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null) {
            return Optional.empty();
        }
        return Optional.of(MAP.computeIfAbsent(profile.getId(), k -> {
            String profileName = profile.getName() != null && !profile.getName().isEmpty() ? profile.getName() : "Unknown";
            return new FTBEPlayerData(profile.getId(), profileName);
        }));
    }

    public static Optional<FTBEPlayerData> getOrCreate(class_1657 player) {
        return player == null || PlayerHooks.isFake((class_1657)player) ? Optional.empty() : FTBEPlayerData.getOrCreate(player.method_7334());
    }

    public static boolean playerExists(UUID playerId) {
        return MAP.containsKey(playerId);
    }

    public static void addTeleportHistory(class_3222 player, class_5321<class_1937> dimension, class_2338 pos) {
        FTBEPlayerData.getOrCreate((class_1657)player).ifPresent(data -> data.addTeleportHistory(player, new TeleportPos(dimension, pos)));
    }

    public static void addTeleportHistory(class_3222 player) {
        FTBEPlayerData.addTeleportHistory(player, (class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515());
    }

    public static void clear() {
        MAP.clear();
    }

    public static void saveAll() {
        MAP.values().forEach(FTBEPlayerData::saveIfChanged);
    }

    public static void sendPlayerTabs(class_3222 serverPlayer) {
        MAP.values().forEach(d -> d.sendTabName(serverPlayer));
    }

    public static void forEachPlayer(Consumer<FTBEPlayerData> consumer) {
        MAP.values().forEach(consumer);
    }

    public void markDirty() {
        this.needSave = true;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.method_10556("muted", this.muted);
        nbt.method_10556("fly", this.canFly);
        nbt.method_10556("god", this.god);
        nbt.method_10582("nick", this.nick);
        nbt.method_10566("last_seen", (class_2520)this.lastSeenPos.write());
        nbt.method_10582("recording", this.recording.getId());
        class_2499 tph = new class_2499();
        for (TeleportPos pos : this.teleportHistory) {
            tph.add((Object)pos.write());
        }
        nbt.method_10566("teleport_history", (class_2520)tph);
        nbt.method_10566("homes", (class_2520)this.homes.writeNBT());
        nbt.method_10566("kit_use_times", (class_2520)class_156.method_654((Object)new class_2487(), tag -> this.kitUseTimes.forEach((arg_0, arg_1) -> ((class_2487)tag).method_10544(arg_0, arg_1))));
        return nbt;
    }

    public void read(class_2487 tag) {
        this.muted = tag.method_10577("muted");
        this.canFly = tag.method_10577("fly");
        this.god = tag.method_10577("god");
        this.nick = tag.method_10558("nick");
        this.recording = RecordingStatus.NAME_MAP.map.getOrDefault(tag.method_10558("recording"), RecordingStatus.NONE);
        this.lastSeenPos = tag.method_10545("last_seen") ? new TeleportPos(tag.method_10562("last_seen")) : null;
        this.teleportHistory.clear();
        class_2499 th = tag.method_10554("teleport_history", 10);
        for (int i = 0; i < th.size(); ++i) {
            this.teleportHistory.add(new TeleportPos(th.method_10602(i)));
        }
        this.kitUseTimes.clear();
        class_2487 kitTag = tag.method_10562("kit_use_times");
        for (String name : kitTag.method_10541()) {
            this.kitUseTimes.put(name, kitTag.method_10537(name));
        }
        this.homes.readNBT(tag.method_10562("homes"));
    }

    public void addTeleportHistory(class_3222 player, TeleportPos pos) {
        this.teleportHistory.add(pos);
        while (this.teleportHistory.size() > FTBEConfig.MAX_BACK.get(player)) {
            this.teleportHistory.removeFirst();
        }
        this.markDirty();
    }

    public void popTeleportHistory() {
        if (!this.teleportHistory.isEmpty()) {
            this.teleportHistory.removeLast();
            this.markDirty();
        } else {
            FTBEssentials.LOGGER.warn("attempted to pop empty back history for {}", (Object)this.uuid);
        }
    }

    public void load() {
        SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(String.valueOf(this.uuid) + ".snbt"));
        if (tag != null) {
            this.read((class_2487)tag);
        }
    }

    public void saveIfChanged() {
        if (this.needSave && SNBT.write((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(String.valueOf(this.uuid) + ".snbt"), (class_2487)this.write())) {
            this.needSave = false;
        }
    }

    public void sendTabName(MinecraftServer server) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendToAll(server);
    }

    public void sendTabName(class_3222 to) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendTo(to);
    }

    public long getLastKitUseTime(String kitName) {
        return this.kitUseTimes.getOrDefault(kitName, 0L);
    }

    public void setLastKitUseTime(String kitName, long when) {
        if (when == 0L) {
            if (this.kitUseTimes.remove(kitName) != null) {
                this.markDirty();
            }
        } else {
            this.kitUseTimes.put(kitName, when);
            this.markDirty();
        }
    }

    public static enum RecordingStatus {
        NONE("none", class_2583.field_24360),
        RECORDING("recording", FTBEssentials.RECORDING_STYLE),
        STREAMING("streaming", FTBEssentials.STREAMING_STYLE);

        public static final NameMap<RecordingStatus> NAME_MAP;
        private final String id;
        private final class_2583 style;

        private RecordingStatus(String id, class_2583 style) {
            this.id = id;
            this.style = style;
        }

        public String getId() {
            return this.id;
        }

        public class_2583 getStyle() {
            return this.style;
        }

        static {
            NAME_MAP = NameMap.of((Object)((Object)NONE), (Object[])RecordingStatus.values()).create();
        }
    }
}

