/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class GuiEntityRenderer
extends GuiElement<GuiEntityRenderer>
implements BackgroundRender {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_2960, class_1297> entityCache = new HashMap<class_2960, class_1297>();
    private static final List<class_2960> invalidEntities = new ArrayList<class_2960>();
    private Supplier<Float> rotationSpeed = () -> Float.valueOf(1.0f);
    private Supplier<Float> lockedRotation = () -> Float.valueOf(0.0f);
    private class_1297 entity;
    private class_2960 entityName;
    private boolean invalidEntity = false;
    private Supplier<Boolean> rotationLocked = () -> false;
    private Supplier<Boolean> trackMouse = () -> false;
    private Supplier<Boolean> drawName = () -> false;
    private int tick = 0;
    public boolean force2dSize = false;
    public int nameOffset = -15;

    public GuiEntityRenderer(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiEntityRenderer setEntity(class_1297 entity) {
        this.entity = entity;
        if (this.entity == null) {
            this.invalidEntity = true;
            return this;
        }
        this.entityName = class_7923.field_41177.method_10221((Object)entity.method_5864());
        this.invalidEntity = invalidEntities.contains(this.entityName);
        return this;
    }

    public GuiEntityRenderer setEntity(class_2960 entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(entity);
            return type.method_5883((class_1937)this.mc().field_1687);
        });
        boolean bl = this.invalidEntity = this.entity == null;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = () -> Float.valueOf(rotationSpeed);
        return this;
    }

    public GuiEntityRenderer setRotationSpeed(Supplier<Float> rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed.get().floatValue();
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = () -> Float.valueOf(lockedRotation);
        return this;
    }

    public GuiEntityRenderer setLockedRotation(Supplier<Float> lockedRotation) {
        this.lockedRotation = lockedRotation;
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation.get().floatValue();
    }

    public GuiEntityRenderer setRotationLocked(boolean rotationLocked) {
        this.rotationLocked = () -> rotationLocked;
        return this;
    }

    public GuiEntityRenderer setRotationLocked(Supplier<Boolean> rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public boolean isRotationLocked() {
        return this.rotationLocked.get();
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = () -> trackMouse;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(Supplier<Boolean> trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public boolean isTrackMouse() {
        return this.trackMouse.get();
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = () -> drawName;
        return this;
    }

    public GuiEntityRenderer setDrawName(Supplier<Boolean> drawName) {
        this.drawName = drawName;
        return this;
    }

    public boolean isDrawName() {
        return this.drawName.get();
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public double getBackgroundDepth() {
        Rectangle rect = this.getRectangle();
        if (this.invalidEntity || this.entity == null) {
            return 0.01;
        }
        float scale = (float)(this.force2dSize ? Math.min(rect.height() / (double)this.entity.method_17682(), rect.width() / (double)this.entity.method_17681()) : rect.height() / (double)this.entity.method_17682());
        if (Float.isInfinite(scale)) {
            scale = 1.0f;
        }
        return scale * 2.0f;
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.invalidEntity) {
            return;
        }
        try {
            if (this.entity != null) {
                if (this.isDrawName()) {
                    class_2561 name = this.entity.method_5476();
                    int width = this.font().method_27525((class_5348)name);
                    render.rect(this.xCenter() - (double)width / 2.0 - 1.0, this.yMin() + (double)this.nameOffset - 1.0, width + 2, 10.0, 0x64000000);
                    render.drawString(name, this.xCenter() - (double)width / 2.0, this.yMin() + (double)this.nameOffset, -1, false);
                }
                Rectangle rect = this.getRectangle();
                float scale = (float)(this.force2dSize ? Math.min(rect.height() / (double)this.entity.method_17682(), rect.width() / (double)this.entity.method_17681()) : rect.height() / (double)this.entity.method_17682());
                float xPos = (float)(rect.x() + rect.width() / 2.0);
                float yPos = (float)(this.yMin() + this.ySize() / 2.0 + rect.height() / 2.0);
                float rotation = this.rotationLocked.get() != false ? this.lockedRotation.get().floatValue() : ((float)this.tick + partialTicks) * this.rotationSpeed.get().floatValue();
                class_1297 class_12972 = this.entity;
                if (class_12972 instanceof class_1309) {
                    class_1309 living = (class_1309)class_12972;
                    int eyeOffset = (int)(this.entity.method_5751() * scale);
                    if (this.trackMouse.get().booleanValue()) {
                        GuiEntityRenderer.renderEntityInInventoryFollowsMouse(render, xPos, yPos, scale, xPos - (float)mouseX, yPos - (float)mouseY - (float)eyeOffset, living);
                    } else {
                        GuiEntityRenderer.renderEntityInInventoryWithRotation(render, xPos, yPos, scale, rotation, living);
                    }
                } else {
                    Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
                    Quaternionf quaternionf1 = class_7833.field_40716.rotationDegrees(rotation);
                    quaternionf.mul((Quaternionfc)quaternionf1);
                    GuiEntityRenderer.renderEntityInInventory(render, xPos, yPos, scale, quaternionf, quaternionf1, this.entity);
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LOGGER.error("Failed to render entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LOGGER.error("Entity: " + this.entity, e);
        }
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        ++this.tick;
        super.tick(mouseX, mouseY);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiRender render, double pX, double pY, double pScale, float offsetX, float offsetY, class_1309 pEntity) {
        float xAngle = (float)Math.atan(offsetX / 40.0f);
        float yAngle = (float)Math.atan(offsetY / 40.0f);
        GuiEntityRenderer.renderEntityInInventoryFollowsAngle(render, pX, pY, pScale, xAngle, yAngle, pEntity);
    }

    public static void renderEntityInInventoryFollowsAngle(GuiRender render, double pX, double pY, double pScale, float angleX, float angleY, class_1309 pEntity) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(angleY * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = pEntity.field_6283;
        float f3 = pEntity.method_36454();
        float f4 = pEntity.method_36455();
        float f5 = pEntity.field_6259;
        float f6 = pEntity.field_6241;
        pEntity.field_6283 = 180.0f + angleX * 20.0f;
        pEntity.method_36456(180.0f + angleX * 40.0f);
        pEntity.method_36457(-angleY * 20.0f);
        pEntity.field_6241 = pEntity.method_36454();
        pEntity.field_6259 = pEntity.method_36454();
        GuiEntityRenderer.renderEntityInInventory(render, pX, pY, pScale, quaternionf, quaternionf1, (class_1297)pEntity);
        pEntity.field_6283 = f2;
        pEntity.method_36456(f3);
        pEntity.method_36457(f4);
        pEntity.field_6259 = f5;
        pEntity.field_6241 = f6;
    }

    public static void renderEntityInInventoryWithRotation(GuiRender render, double xPos, double yPos, double scale, double rotation, class_1309 living) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = class_7833.field_40716.rotationDegrees((float)rotation);
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = living.field_6283;
        float f3 = living.method_36454();
        float f4 = living.method_36455();
        float f5 = living.field_6259;
        float f6 = living.field_6241;
        living.field_6283 = 180.0f;
        living.method_36456(180.0f);
        living.method_36457(0.0f);
        living.field_6241 = living.method_36454();
        living.field_6259 = living.method_36454();
        GuiEntityRenderer.renderEntityInInventory(render, xPos, yPos, scale, quaternionf, quaternionf1, (class_1297)living);
        living.field_6283 = f2;
        living.method_36456(f3);
        living.method_36457(f4);
        living.field_6259 = f5;
        living.field_6241 = f6;
    }

    public static void renderEntityInInventory(GuiRender render, double pX, double pY, double pScale, Quaternionf quat, @Nullable Quaternionf pCameraOrientation, class_1297 pEntity) {
        render.pose().method_22903();
        render.pose().method_22904(pX, pY, 50.0);
        render.pose().method_34425(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
        render.pose().method_22907(quat);
        class_308.method_34742();
        class_898 entityrenderdispatcher = class_310.method_1551().method_1561();
        if (pCameraOrientation != null) {
            pCameraOrientation.conjugate();
            entityrenderdispatcher.method_24196(pCameraOrientation);
        }
        entityrenderdispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.method_3954(pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, render.pose(), (class_4597)render.buffers(), 0xF000F0));
        render.flush();
        entityrenderdispatcher.method_3948(true);
        render.pose().method_22909();
        class_308.method_24211();
    }
}

