/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.client.modulargui.lib.LegacyRender;
import net.creeperhost.polylib.client.modulargui.lib.ScissorHandler;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7764;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2ic;

public class GuiRender
extends LegacyRender {
    public static final class_1921 SOLID = class_1921.method_51784();
    private final RenderWrapper renderWrapper;
    private final class_310 mc;
    private final class_4587 pose;
    private final ScissorHandler scissorHandler = new ScissorHandler();
    private final class_4597.class_4598 buffers;
    private boolean batchDraw;
    private class_327 fontOverride;
    private class_1799 tooltipStack = class_1799.field_8037;

    public GuiRender(class_310 mc, class_4587 poseStack, class_4597.class_4598 buffers) {
        this.mc = mc;
        this.pose = poseStack;
        this.buffers = buffers;
        this.renderWrapper = new RenderWrapper(this);
    }

    public GuiRender(class_310 mc, class_4597.class_4598 buffers) {
        this(mc, new class_4587(), buffers);
    }

    public static GuiRender convert(class_332 graphics) {
        return new GuiRender(class_310.method_1551(), graphics.method_51448(), graphics.method_51450());
    }

    @Override
    public class_4587 pose() {
        return this.pose;
    }

    public class_4597.class_4598 buffers() {
        return this.buffers;
    }

    public class_310 mc() {
        return this.mc;
    }

    public class_327 font() {
        return this.fontOverride == null ? this.mc().field_1772 : this.fontOverride;
    }

    public int guiWidth() {
        return this.mc().method_22683().method_4486();
    }

    public int guiHeight() {
        return this.mc().method_22683().method_4502();
    }

    public void overrideFont(@Nullable class_327 font) {
        this.fontOverride = font;
    }

    public void batchDraw(Runnable batch) {
        this.flush();
        this.batchDraw = true;
        batch.run();
        this.batchDraw = false;
        this.flush();
    }

    private void flushIfUnBatched() {
        if (!this.batchDraw) {
            this.flush();
        }
    }

    private void flushIfBatched() {
        if (this.batchDraw) {
            this.flush();
        }
    }

    public void flush() {
        RenderSystem.disableDepthTest();
        this.buffers.method_22993();
        RenderSystem.enableDepthTest();
    }

    @Deprecated
    public RenderWrapper guiGraphicsWrapper() {
        return this.renderWrapper;
    }

    public void rect(Rectangle rectangle, int colour) {
        this.rect(SOLID, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(class_1921 type, Rectangle rectangle, int colour) {
        this.rect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(double x, double y, double width, double height, int colour) {
        this.fill(SOLID, x, y, x + width, y + height, colour);
    }

    public void rect(class_1921 type, double x, double y, double width, double height, int colour) {
        this.fill(type, x, y, x + width, y + height, colour);
    }

    public void fill(double xMin, double yMin, double xMax, double yMax, int colour) {
        this.fill(SOLID, xMin, yMin, xMax, yMax, colour);
    }

    public void fill(class_1921 type, double xMin, double yMin, double xMax, double yMax, int colour) {
        double min;
        if (xMax < xMin) {
            min = xMax;
            xMax = xMin;
            xMin = min;
        }
        if (yMax < yMin) {
            min = yMax;
            yMax = yMin;
            yMin = min;
        }
        Matrix4f mat = this.pose.method_23760().method_23761();
        class_4588 buffer = this.buffers.getBuffer(type);
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_39415(colour).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_39415(colour).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_39415(colour).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_39415(colour).method_1344();
        this.flushIfUnBatched();
    }

    public void gradientFillV(double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        this.gradientFillV(SOLID, xMin, yMin, xMax, yMax, topColour, bottomColour);
    }

    public void gradientFillV(class_1921 type, double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        class_4588 buffer = this.buffers().getBuffer(type);
        float sA = (float)class_5253.class_5254.method_27762((int)topColour) / 255.0f;
        float sR = (float)class_5253.class_5254.method_27765((int)topColour) / 255.0f;
        float sG = (float)class_5253.class_5254.method_27766((int)topColour) / 255.0f;
        float sB = (float)class_5253.class_5254.method_27767((int)topColour) / 255.0f;
        float eA = (float)class_5253.class_5254.method_27762((int)bottomColour) / 255.0f;
        float eR = (float)class_5253.class_5254.method_27765((int)bottomColour) / 255.0f;
        float eG = (float)class_5253.class_5254.method_27766((int)bottomColour) / 255.0f;
        float eB = (float)class_5253.class_5254.method_27767((int)bottomColour) / 255.0f;
        Matrix4f mat = this.pose.method_23760().method_23761();
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(eR, eG, eB, eA).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(sR, sG, sB, sA).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(sR, sG, sB, sA).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(eR, eG, eB, eA).method_1344();
        this.flushIfUnBatched();
    }

    public void gradientFillH(double xMin, double yMin, double xMax, double yMax, int leftColour, int rightColour) {
        this.gradientFillH(SOLID, xMin, yMin, xMax, yMax, leftColour, rightColour);
    }

    public void gradientFillH(class_1921 type, double xMin, double yMin, double xMax, double yMax, int leftColour, int rightColour) {
        class_4588 buffer = this.buffers().getBuffer(type);
        float sA = (float)class_5253.class_5254.method_27762((int)leftColour) / 255.0f;
        float sR = (float)class_5253.class_5254.method_27765((int)leftColour) / 255.0f;
        float sG = (float)class_5253.class_5254.method_27766((int)leftColour) / 255.0f;
        float sB = (float)class_5253.class_5254.method_27767((int)leftColour) / 255.0f;
        float eA = (float)class_5253.class_5254.method_27762((int)rightColour) / 255.0f;
        float eR = (float)class_5253.class_5254.method_27765((int)rightColour) / 255.0f;
        float eG = (float)class_5253.class_5254.method_27766((int)rightColour) / 255.0f;
        float eB = (float)class_5253.class_5254.method_27767((int)rightColour) / 255.0f;
        Matrix4f mat = this.pose.method_23760().method_23761();
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(eR, eG, eB, eA).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(eR, eG, eB, eA).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(sR, sG, sB, sA).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(sR, sG, sB, sA).method_1344();
        this.flushIfUnBatched();
    }

    public void borderRect(Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderRect(class_1921 type, Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(class_1921 type, double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
    }

    public void borderFill(class_1921 type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        if (this.batchDraw) {
            this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
        } else {
            this.batchDraw(() -> this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour));
        }
    }

    private void borderFillInternal(class_1921 type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.fill(type, xMin, yMin, xMax, yMin + borderWidth, borderColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, borderColour);
        this.fill(type, xMin, yMax - borderWidth, xMax, yMax, borderColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, borderColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(class_1921 type, double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(type, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(class_1921 type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        if (this.batchDraw) {
            this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
        } else {
            this.batchDraw(() -> this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour));
        }
    }

    public void shadedFillInternal(class_1921 type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.fill(type, xMin, yMin, xMax - borderWidth, yMin + borderWidth, topLeftColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, topLeftColour);
        this.fill(type, xMin + borderWidth, yMax - borderWidth, xMax, yMax, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin, xMax, yMin + borderWidth, cornerMixColour);
        this.fill(type, xMin, yMax - borderWidth, xMin + borderWidth, yMax, cornerMixColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void toolTipBackground(double x, double y, double width, double height) {
        this.toolTipBackground(x, y, width, height, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColour, int borderColourTop, int borderColourBottom) {
        this.toolTipBackground(x, y, width, height, backgroundColour, backgroundColour, borderColourTop, borderColourBottom, false);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        if (this.batchDraw) {
            this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false);
        } else {
            this.batchDraw(() -> this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false));
        }
    }

    private void toolTipBackgroundInternal(double xMin, double yMin, double xMax, double yMax, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        this.fill(xMin + 1.0, yMin, xMax - 1.0, yMin + 1.0, backgroundColourTop);
        this.fill(xMin + 1.0, yMax - 1.0, xMax - 1.0, yMax, backgroundColourBottom);
        this.gradientFillV(xMin, yMin + 1.0, xMin + 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        this.gradientFillV(xMax - 1.0, yMin + 1.0, xMax, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        if (!empty) {
            this.gradientFillV(xMin + 1.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        }
        this.gradientFillV(xMin + 1.0, yMin + 1.0, xMin + 2.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.gradientFillV(xMax - 2.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.fill(xMin + 2.0, yMin + 1.0, xMax - 2.0, yMin + 2.0, borderColourTop);
        this.fill(xMin + 2.0, yMax - 2.0, xMax - 2.0, yMax - 1.0, borderColourBottom);
    }

    public void spriteRect(class_1921 type, Rectangle rectangle, class_1058 sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(class_1921 type, Rectangle rectangle, class_1058 sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(class_1921 type, Rectangle rectangle, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, red, green, blue, alpha);
    }

    public void spriteRect(class_1921 type, double x, double y, double width, double height, class_1058 sprite) {
        this.spriteRect(type, x, y, width, height, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(class_1921 type, double x, double y, double width, double height, class_1058 sprite, int argb) {
        this.spriteRect(type, x, y, width, height, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(class_1921 type, double x, double y, double width, double height, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, sprite, red, green, blue, alpha);
    }

    public void sprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float red, float green, float blue, float alpha) {
        class_4588 buffer = this.buffers().getBuffer(type);
        Matrix4f mat = this.pose.method_23760().method_23761();
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4577(), sprite.method_4575()).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4577(), sprite.method_4593()).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4594(), sprite.method_4593()).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4594(), sprite.method_4575()).method_1344();
        this.flushIfUnBatched();
    }

    public void spriteRect(class_1921 type, Rectangle rectangle, int rotation, class_1058 sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(class_1921 type, Rectangle rectangle, int rotation, class_1058 sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(class_1921 type, Rectangle rectangle, int rotation, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, red, green, blue, alpha);
    }

    public void spriteRect(class_1921 type, double x, double y, double width, double height, int rotation, class_1058 sprite) {
        this.spriteRect(type, x, y, width, height, rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(class_1921 type, double x, double y, double width, double height, int rotation, class_1058 sprite, int argb) {
        this.spriteRect(type, x, y, width, height, rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(class_1921 type, double x, double y, double width, double height, int rotation, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, rotation, sprite, red, green, blue, alpha);
    }

    public void sprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, int rotation, class_1058 sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, int rotation, class_1058 sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, int rotation, class_1058 sprite, float red, float green, float blue, float alpha) {
        float[] u = new float[]{sprite.method_4594(), sprite.method_4577(), sprite.method_4577(), sprite.method_4594()};
        float[] v = new float[]{sprite.method_4575(), sprite.method_4575(), sprite.method_4593(), sprite.method_4593()};
        class_4588 buffer = this.buffers().getBuffer(type);
        Matrix4f mat = this.pose.method_23760().method_23761();
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(1 + rotation) % 4], v[(1 + rotation) % 4]).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(2 + rotation) % 4], v[(2 + rotation) % 4]).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(3 + rotation) % 4], v[(3 + rotation) % 4]).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(0 + rotation) % 4], v[(0 + rotation) % 4]).method_1344();
        this.flushIfUnBatched();
    }

    public void partialSpriteTex(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, double texXMin, double texYMin, double texXMax, double texYMax, int argb) {
        this.partialSpriteTex(type, xMin, yMin, xMax, yMax, sprite, texXMin, texYMin, texXMax, texYMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSpriteTex(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, double texXMin, double texYMin, double texXMax, double texYMax, float red, float green, float blue, float alpha) {
        int width = sprite.method_45851().method_45807();
        int height = sprite.method_45851().method_45815();
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, (float)texXMin / (float)width, (float)texYMin / (float)height, (float)texXMax / (float)width, (float)texYMax / (float)height, red, green, blue, alpha);
    }

    public void partialSprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float uMin, float vMin, float uMax, float vMax, int argb) {
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, uMin, vMin, uMax, vMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float uMin, float vMin, float uMax, float vMax, float red, float green, float blue, float alpha) {
        class_4588 buffer = this.buffers().getBuffer(type);
        Matrix4f mat = this.pose.method_23760().method_23761();
        float u0 = sprite.method_4594();
        float v0 = sprite.method_4593();
        float u1 = sprite.method_4577();
        float v1 = sprite.method_4575();
        float ul = u1 - u0;
        float vl = v1 - v0;
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(u0 + uMax * ul, v0 + vMax * vl).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(u0 + uMax * ul, v0 + vMin * vl).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(u0 + uMin * ul, v0 + vMin * vl).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(u0 + uMin * ul, v0 + vMax * vl).method_1344();
        this.flushIfUnBatched();
    }

    public void tileSprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.method_45851().method_45807(), sprite.method_45851().method_45815(), argb);
    }

    public void tileSprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int textureWidth, int textureHeight, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, textureWidth, textureHeight, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tileSprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.method_45851().method_45807(), sprite.method_45851().method_45815(), red, green, blue, alpha);
    }

    public void tileSprite(class_1921 type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        double width = xMax - xMin;
        double height = yMax - yMin;
        if (width <= (double)textureWidth && height <= (double)textureHeight) {
            this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, 0.0f, 0.0f, (float)width / (float)textureWidth, (float)height / (float)textureHeight, red, green, blue, alpha);
        } else {
            Runnable draw = () -> {
                double xPos = xMin;
                do {
                    double sectionWidth = Math.min((double)textureWidth, xMax - xPos);
                    double uWidth = sectionWidth / (double)textureWidth;
                    double yPos = yMin;
                    do {
                        double sectionHeight = Math.min((double)textureHeight, yMax - yPos);
                        double vWidth = sectionHeight / (double)textureHeight;
                        this.partialSprite(type, xPos, yPos, xPos + sectionWidth, yPos + sectionHeight, sprite, 0.0f, 0.0f, (float)uWidth, (float)vWidth, red, green, blue, alpha);
                    } while ((yPos += (double)textureHeight) < yMax);
                } while ((xPos += (double)textureWidth) < xMax);
            };
            if (this.batchDraw) {
                draw.run();
            } else {
                this.batchDraw(draw);
            }
        }
    }

    public void texRect(Material material, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), red, green, blue, alpha);
    }

    public void texRect(Material material, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, red, green, blue, alpha);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, float red, float green, float blue, float alpha) {
        class_1058 sprite = material.sprite();
        class_4588 buffer = material.buffer((class_4597)this.buffers, GuiRender::texColType);
        Matrix4f mat = this.pose.method_23760().method_23761();
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4577(), sprite.method_4575()).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4577(), sprite.method_4593()).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4594(), sprite.method_4593()).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(sprite.method_4594(), sprite.method_4575()).method_1344();
        this.flushIfUnBatched();
    }

    public void texRect(Material material, int rotation, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, int rotation, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, int rotation, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, red, green, blue, alpha);
    }

    public void texRect(Material material, int rotation, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, int rotation, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, int rotation, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, rotation, red, green, blue, alpha);
    }

    public void tex(Material material, int rotation, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int rotation, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int rotation, float red, float green, float blue, float alpha) {
        class_1058 sprite = material.sprite();
        class_4588 buffer = material.buffer((class_4597)this.buffers, GuiRender::texColType);
        float[] u = new float[]{sprite.method_4594(), sprite.method_4577(), sprite.method_4577(), sprite.method_4594()};
        float[] v = new float[]{sprite.method_4575(), sprite.method_4575(), sprite.method_4593(), sprite.method_4593()};
        Matrix4f mat = this.pose.method_23760().method_23761();
        buffer.method_22918(mat, (float)xMax, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(1 + rotation) % 4], v[(1 + rotation) % 4]).method_1344();
        buffer.method_22918(mat, (float)xMax, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(2 + rotation) % 4], v[(2 + rotation) % 4]).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(3 + rotation) % 4], v[(3 + rotation) % 4]).method_1344();
        buffer.method_22918(mat, (float)xMin, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(u[(0 + rotation) % 4], v[(0 + rotation) % 4]).method_1344();
        this.flushIfUnBatched();
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right(), argb);
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder, argb);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right());
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        if (this.batchDraw) {
            this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha);
        } else {
            this.batchDraw(() -> this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha));
        }
    }

    private void dynamicTexInternal(Material material, int xPos, int yPos, int xSize, int ySize, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        class_1058 sprite = material.sprite();
        class_4588 buffer = material.buffer((class_4597)this.buffers, GuiRender::texColType);
        Matrix4f mat = this.pose.method_23760().method_23761();
        class_7764 contents = sprite.method_45851();
        int texWidth = contents.method_45807();
        int texHeight = contents.method_45815();
        int trimWidth = texWidth - leftBorder - rightBorder;
        int trimHeight = texHeight - topBorder - bottomBorder;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightBorder);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = 0;
            if (x != 0) {
                trimU = x + leftBorder + trimWidth <= xSize ? leftBorder : texWidth - (xSize - x);
            }
            this.bufferDynamic(buffer, mat, sprite, xPos + x, yPos, trimU, 0.0, rWidth, topBorder, red, green, blue, alpha);
            this.bufferDynamic(buffer, mat, sprite, xPos + x, yPos + ySize - bottomBorder, trimU, texHeight - bottomBorder, rWidth, bottomBorder, red, green, blue, alpha);
            rWidth = Math.min(xSize - x - leftBorder - rightBorder, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topBorder - bottomBorder, trimHeight);
                int trimV = y + (texHeight - topBorder - bottomBorder) <= ySize ? topBorder : texHeight - (ySize - y);
                if (x == 0 && y + topBorder < ySize - bottomBorder) {
                    this.bufferDynamic(buffer, mat, sprite, xPos, yPos + y + topBorder, 0.0, trimV, leftBorder, rHeight, red, green, blue, alpha);
                    this.bufferDynamic(buffer, mat, sprite, xPos + xSize - rightBorder, yPos + y + topBorder, trimU + texWidth - rightBorder, trimV, rightBorder, rHeight, red, green, blue, alpha);
                }
                if (y + topBorder >= ySize - bottomBorder || x + leftBorder >= xSize - rightBorder) continue;
                this.bufferDynamic(buffer, mat, sprite, xPos + x + leftBorder, yPos + y + topBorder, leftBorder, topBorder, rWidth, rHeight, red, green, blue, alpha);
            }
        }
    }

    private void bufferDynamic(class_4588 builder, Matrix4f mat, class_1058 tex, int x, int y, double textureX, double textureY, int width, int height, float red, float green, float blue, float alpha) {
        int w = tex.method_45851().method_45807();
        int h = tex.method_45851().method_45815();
        builder.method_22918(mat, (float)x, (float)(y + height), 0.0f).method_22915(red, green, blue, alpha).method_22913(tex.method_4580(textureX / (double)w * 16.0), tex.method_4570((textureY + (double)height) / (double)h * 16.0)).method_1344();
        builder.method_22918(mat, (float)(x + width), (float)(y + height), 0.0f).method_22915(red, green, blue, alpha).method_22913(tex.method_4580((textureX + (double)width) / (double)w * 16.0), tex.method_4570((textureY + (double)height) / (double)h * 16.0)).method_1344();
        builder.method_22918(mat, (float)(x + width), (float)y, 0.0f).method_22915(red, green, blue, alpha).method_22913(tex.method_4580((textureX + (double)width) / (double)w * 16.0), tex.method_4570(textureY / (double)h * 16.0)).method_1344();
        builder.method_22918(mat, (float)x, (float)y, 0.0f).method_22915(red, green, blue, alpha).method_22913(tex.method_4580(textureX / (double)w * 16.0), tex.method_4570(textureY / (double)h * 16.0)).method_1344();
    }

    public int drawString(@Nullable String message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(@Nullable String message, double x, double y, int colour, boolean shadow) {
        if (message == null) {
            return 0;
        }
        int i = this.font().method_27522(message, (float)x, (float)y, colour, shadow, this.pose.method_23760().method_23761(), (class_4597)this.buffers, class_327.class_6415.field_33993, 0, 0xF000F0, this.font().method_1726());
        this.flushIfUnBatched();
        return i;
    }

    public int drawString(class_5481 message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(class_5481 message, double x, double y, int colour, boolean shadow) {
        int i = this.font().method_22942(message, (float)x, (float)y, colour, shadow, this.pose.method_23760().method_23761(), (class_4597)this.buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
        this.flushIfUnBatched();
        return i;
    }

    public int drawString(class_2561 message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(class_2561 message, double x, double y, int colour, boolean shadow) {
        return this.drawString(message.method_30937(), x, y, colour, shadow);
    }

    public void drawWordWrap(class_5348 message, double x, double y, int width, int colour) {
        this.drawWordWrap(message, x, y, width, colour, false);
    }

    public void drawWordWrap(class_5348 message, double x, double y, int width, int colour, boolean shadow) {
        Objects.requireNonNull(this.font());
        this.drawWordWrap(message, x, y, width, colour, shadow, 9.0);
    }

    public void drawWordWrap(class_5348 message, double x, double y, int width, int colour, boolean shadow, double spacing) {
        for (class_5481 formattedcharsequence : this.font().method_1728(message, width)) {
            this.drawString(formattedcharsequence, x, y, colour, shadow);
            y += spacing;
        }
    }

    public void drawCenteredString(String message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(String message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().method_1727(message) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(class_2561 message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(class_2561 message, double x, double y, int colour, boolean shadow) {
        class_5481 formattedcharsequence = message.method_30937();
        this.drawString(formattedcharsequence, x - (double)this.font().method_30880(formattedcharsequence) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(class_5481 message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(class_5481 message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().method_30880(message) / 2.0, y, colour, shadow);
    }

    public void drawScrollingString(class_2561 component, double x, double y, double xMax, int colour, boolean shadow) {
        this.drawScrollingString(component, x, y, xMax, colour, shadow, true);
    }

    public void drawScrollingString(class_2561 component, double x, double y, double xMax, int colour, boolean shadow, boolean doScissor) {
        double width;
        int textWidth = this.font().method_27525((class_5348)component);
        if ((double)textWidth > (width = xMax - x)) {
            double outside = (double)textWidth - width;
            double anim = (double)class_156.method_658() / 1000.0;
            double e = Math.max(outside * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * anim / e)) / 2.0 + 0.5;
            double offset = class_3532.method_16436((double)f, (double)0.0, (double)outside);
            if (doScissor) {
                Objects.requireNonNull(this.font());
                this.pushScissor(x, y - 1.0, xMax, y + 9.0 + 1.0);
            }
            this.drawString(component, x - offset, y, colour, shadow);
            if (doScissor) {
                this.popScissor();
            }
        } else {
            this.drawCenteredString(component, (x + xMax) / 2.0, y, colour, shadow);
        }
    }

    public void renderTooltip(class_1799 stack, double mouseX, double mouseY) {
        this.renderTooltip(stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(class_1799 stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(class_437.method_25408((class_310)this.mc(), (class_1799)stack), stack.method_32347(), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = class_1799.field_8037;
    }

    public void toolTipWithImage(List<class_2561> tooltips, Optional<class_5632> tooltipImage, class_1799 stack, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltips, tooltipImage, stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<class_2561> tooltips, Optional<class_5632> tooltipImage, class_1799 stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(tooltips, tooltipImage, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = class_1799.field_8037;
    }

    public void toolTipWithImage(List<class_2561> tooltip, Optional<class_5632> tooltipImage, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltip, tooltipImage, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<class_2561> tooltip, Optional<class_5632> tooltipImage, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<class_5684> list = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltip, tooltipImage, (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(list, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void renderTooltip(class_2561 message, double mouseX, double mouseY) {
        this.renderTooltip(message, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(class_2561 message, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltip(List.of(message.method_30937()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
    }

    public void componentTooltip(List<class_2561> tooltips, double mouseX, double mouseY) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void componentTooltip(List<class_2561> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<class_5684> components = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void componentTooltip(List<? extends class_5348> tooltips, double mouseX, double mouseY, class_1799 stack) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847, stack);
    }

    public void componentTooltip(List<? extends class_5348> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, class_1799 stack) {
        this.tooltipStack = stack;
        List<class_5684> components = PolyLibClient.postGatherTooltipComponents(stack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
        this.tooltipStack = class_1799.field_8037;
    }

    public void renderTooltip(List<? extends class_5481> tooltips, double mouseX, double mouseY) {
        this.renderTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(List<? extends class_5481> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(class_5684::method_32662).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void renderTooltip(List<class_5481> tooltips, class_8000 positioner, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(class_5684::method_32662).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, positioner);
    }

    private void renderTooltipInternal(List<class_5684> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, class_8000 positioner) {
        if (!tooltips.isEmpty()) {
            class_5684 component;
            int i;
            PolyLibClient.ToolTipResult event = PolyLibClient.postRenderTooltipPre(this.tooltipStack, this.renderWrapper, (int)mouseX, (int)mouseY, this.guiWidth(), this.guiHeight(), tooltips, this.font(), positioner);
            if (event.canceled()) {
                return;
            }
            int width = 0;
            int height = tooltips.size() == 1 ? -2 : 0;
            for (class_5684 line : tooltips) {
                width = Math.max(width, line.method_32664(event.getFont()));
                height += line.method_32661();
            }
            Vector2ic position = positioner.method_47944(this.guiWidth(), this.guiHeight(), event.getX(), event.getY(), width, height);
            int xPos = position.x();
            int yPos = Math.max(position.y(), 3);
            PolyLibClient.ToolTipColour colour = PolyLibClient.postTooltipColour(this.tooltipStack, this.renderWrapper, xPos, yPos, backgroundTop, backgroundBottom, borderTop, borderBottom, event.getFont(), tooltips);
            this.toolTipBackground(xPos - 3, yPos - 3, width + 6, height + 6, colour.getBackgroundStart(), colour.getBackgroundEnd(), colour.getBorderStart(), colour.getBorderEnd(), true);
            int linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.method_32665(event.getFont(), xPos, linePos, this.pose.method_23760().method_23761(), this.buffers);
                linePos += component.method_32661() + (i == 0 ? 2 : 0);
            }
            linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.method_32666(event.getFont(), xPos, linePos, (class_332)this.renderWrapper);
                linePos += component.method_32661() + (i == 0 ? 2 : 0);
            }
        }
    }

    public void renderComponentHoverEffect(@Nullable class_2583 style, int mouseX, int mouseY) {
        if (style != null && style.method_10969() != null) {
            class_2568 event = style.method_10969();
            class_2568.class_5249 stackInfo = (class_2568.class_5249)event.method_10891(class_2568.class_5247.field_24343);
            if (stackInfo != null) {
                this.renderTooltip(stackInfo.method_27683(), (double)mouseX, (double)mouseY);
            } else {
                class_2568.class_5248 tooltipInfo = (class_2568.class_5248)event.method_10891(class_2568.class_5247.field_24344);
                if (tooltipInfo != null) {
                    if (this.mc().field_1690.field_1827) {
                        this.componentTooltip(tooltipInfo.method_27682(), mouseX, mouseY);
                    }
                } else {
                    class_2561 component = (class_2561)event.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        this.renderTooltip(this.font().method_1728((class_5348)component, Math.max(this.guiWidth() / 2, 200)), (double)mouseX, (double)mouseY);
                    }
                }
            }
        }
    }

    public void renderItem(class_1799 stack, double x, double y) {
        this.renderItem(stack, x, y, 16.0);
    }

    public void renderItem(class_1799 stack, double x, double y, double size) {
        this.renderItem((class_1309)this.mc().field_1724, (class_1937)this.mc().field_1687, stack, x, y, size, 0);
    }

    public void renderItem(class_1799 stack, double x, double y, double size, int modelRand) {
        this.renderItem((class_1309)this.mc().field_1724, (class_1937)this.mc().field_1687, stack, x, y, size, modelRand);
    }

    public void renderFakeItem(class_1799 stack, double x, double y) {
        this.renderFakeItem(stack, x, y, 16.0);
    }

    public void renderFakeItem(class_1799 stack, double x, double y, double size) {
        this.renderItem(null, (class_1937)this.mc().field_1687, stack, x, y, size, 0);
    }

    public void renderItem(class_1309 entity, class_1799 stack, double x, double y, int modelRand) {
        this.renderItem(entity, stack, x, y, 16.0, modelRand);
    }

    public void renderItem(class_1309 entity, class_1799 stack, double x, double y, double size, int modelRand) {
        this.renderItem(entity, entity.method_37908(), stack, x, y, size, modelRand);
    }

    public void renderItem(@Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, double x, double y, double size, int modelRand) {
        if (!stack.method_7960()) {
            class_1087 bakedmodel = this.mc().method_1480().method_4019(stack, level, entity, modelRand);
            this.pose.method_22903();
            this.pose.method_22904(x + size / 2.0, y + size / 2.0, size);
            try {
                boolean flag;
                this.pose.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                this.pose.method_22905((float)size, (float)size, (float)size);
                boolean bl = flag = !bakedmodel.method_24304();
                if (flag) {
                    class_308.method_24210();
                }
                this.mc().method_1480().method_23179(stack, class_811.field_4317, false, this.pose, (class_4597)this.buffers, 0xF000F0, class_4608.field_21444, bakedmodel);
                this.flush();
                if (flag) {
                    class_308.method_24211();
                }
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
                class_129 crashreportcategory = crashreport.method_562("Item being rendered");
                crashreportcategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                crashreportcategory.method_577("Item Stack", () -> String.valueOf(stack.method_7909()));
                crashreportcategory.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
                crashreportcategory.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
                crashreportcategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                throw new class_148(crashreport);
            }
            this.pose.method_22909();
        }
    }

    public void renderItemDecorations(class_1799 stack, double x, double y) {
        this.renderItemDecorations(stack, x, y, 16.0);
    }

    public void renderItemDecorations(class_1799 stack, double x, double y, double size) {
        this.renderItemDecorations(stack, x, y, size, null);
    }

    public void renderItemDecorations(class_1799 stack, double x, double y, @Nullable String text) {
        this.renderItemDecorations(stack, x, y, 16.0, text);
    }

    public void renderItemDecorations(class_1799 stack, double x, double y, double size, @Nullable String text) {
        if (!stack.method_7960()) {
            class_746 localplayer;
            float f;
            this.pose.method_22903();
            float scale = (float)size / 16.0f;
            this.pose.method_22904(x, y, size * 2.0 - 0.1);
            this.pose.method_22905(scale, scale, 1.0f);
            this.pose.method_22904(-x, -y, 0.0);
            if (stack.method_7947() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.method_7947()) : text;
                this.drawString(s, x + 19.0 - 2.0 - (double)this.font().method_1727(s), y + 6.0 + 3.0, 0xFFFFFF, true);
            }
            if (stack.method_31578()) {
                int l = stack.method_31579();
                int i = stack.method_31580();
                double j = x + 2.0;
                double k = y + 13.0;
                this.pose.method_22904(0.0, 0.0, 0.04);
                this.fill(j, k, j + 13.0, k + 2.0, -16777216);
                this.pose.method_22904(0.0, 0.0, 0.02);
                this.fill(j, k, j + (double)l, k + 1.0, i | 0xFF000000);
            }
            float f2 = f = (localplayer = this.mc().field_1724) == null ? 0.0f : localplayer.method_7357().method_7905(stack.method_7909(), this.mc().method_1488());
            if (f > 0.0f) {
                double i1 = y + (double)class_3532.method_15375((float)(16.0f * (1.0f - f)));
                double j1 = i1 + (double)class_3532.method_15386((float)(16.0f * f));
                this.pose.method_22904(0.0, 0.0, 0.02);
                this.fill(x, i1, x + 16.0, j1, Integer.MAX_VALUE);
            }
            this.pose.method_22909();
            if (size == 16.0) {
                PolyLibClient.onItemDecorate(this.renderWrapper, this.font(), stack, (int)x, (int)y);
            }
        }
    }

    public void pushScissorRect(Rectangle rectangle) {
        this.pushScissorRect(rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void pushScissorRect(double x, double y, double width, double height) {
        this.flushIfBatched();
        this.scissorHandler.pushGuiScissor(x, y, width, height);
    }

    public void pushScissor(double xMin, double yMin, double xMax, double yMax) {
        this.flushIfBatched();
        this.scissorHandler.pushGuiScissor(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public void popScissor() {
        this.scissorHandler.popScissor();
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.flushIfBatched();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static boolean isInRect(double minX, double minY, double width, double height, double testX, double testY) {
        return testX >= minX && testX < minX + width && testY >= minY && testY < minY + height;
    }

    public static boolean isInRect(int minX, int minY, int width, int height, double testX, double testY) {
        return testX >= (double)minX && testX < (double)(minX + width) && testY >= (double)minY && testY < (double)(minY + height);
    }

    public static int mixColours(int colour1, int colour2) {
        return GuiRender.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = class_3532.method_15340((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = class_3532.method_15340((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = class_3532.method_15340((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = class_3532.method_15340((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int midColour(int colour1, int colour2) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        return (alpha2 + (alpha1 - alpha2) / 2 & 0xFF) << 24 | (red2 + (red1 - red2) / 2 & 0xFF) << 16 | (green2 + (green1 - green2) / 2 & 0xFF) << 8 | blue2 + (blue1 - blue2) / 2 & 0xFF;
    }

    private static float r(int argb) {
        return (float)class_5253.class_5254.method_27765((int)argb) / 255.0f;
    }

    private static float g(int argb) {
        return (float)class_5253.class_5254.method_27766((int)argb) / 255.0f;
    }

    private static float b(int argb) {
        return (float)class_5253.class_5254.method_27767((int)argb) / 255.0f;
    }

    private static float a(int argb) {
        return (float)class_5253.class_5254.method_27762((int)argb) / 255.0f;
    }

    public static class_1921 texType(class_2960 location) {
        return class_1921.method_24048((String)"tex_type", (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_757::method_34542)).method_34577((class_4668.class_5939)new class_4668.class_4683(location, false, false)).method_23615(class_4668.field_21370).method_23603(class_4668.field_21345).method_23617(false));
    }

    public static class_1921 texColType(class_2960 location) {
        return class_1921.method_24048((String)"tex_col_type", (class_293)class_290.field_20887, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_757::method_34541)).method_34577((class_4668.class_5939)new class_4668.class_4683(location, false, false)).method_23615(class_4668.field_21370).method_23603(class_4668.field_21345).method_23617(false));
    }

    public static class RenderWrapper
    extends class_332 {
        private final GuiRender wrapped;

        private RenderWrapper(GuiRender wrapped) {
            super(wrapped.mc(), wrapped.pose(), wrapped.buffers());
            this.wrapped = wrapped;
        }

        public void method_51741(Runnable runnable) {
            this.wrapped.batchDraw(runnable);
        }

        public void method_51452() {
            this.wrapped.flush();
        }

        protected void method_51887() {
            this.wrapped.flushIfBatched();
        }

        protected void method_51744() {
            this.wrapped.flushIfUnBatched();
        }
    }
}

