/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screenbuilder;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Optional;
import net.creeperhost.polylib.client.fluid.ScreenFluidRenderer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class ScreenBuilder {
    public static final class_2960 DEFAULT_RESOURCE_LOCATION = new class_2960("polylib", "textures/gui_sheet.png");
    public final class_2960 resourceLocation;
    public class_310 mc = class_310.method_1551();

    public ScreenBuilder() {
        this.resourceLocation = DEFAULT_RESOURCE_LOCATION;
    }

    public ScreenBuilder(class_2960 resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void drawDefaultBackground(class_332 guiGraphics, int x, int y, int width, int height, int textureXSize, int textureYSize) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        guiGraphics.method_25290(this.resourceLocation, x, y, 0.0f, 0.0f, width / 2, height / 2, textureXSize, textureYSize);
        guiGraphics.method_25290(this.resourceLocation, x + width / 2, y, (float)(150 - width / 2), 0.0f, width / 2, height / 2, textureXSize, textureYSize);
        guiGraphics.method_25290(this.resourceLocation, x, y + height / 2, 0.0f, (float)(150 - height / 2), width / 2, height / 2, textureXSize, textureYSize);
        guiGraphics.method_25290(this.resourceLocation, x + width / 2, y + height / 2, (float)(150 - width / 2), (float)(150 - height / 2), width / 2, height / 2, textureXSize, textureYSize);
    }

    public void drawPlayerSlots(class_332 guiGraphics, int posX, int posY, boolean center, int textureXSize, int textureYSize) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                guiGraphics.method_25290(this.resourceLocation, posX + x * 18, posY + y * 18, 150.0f, 0.0f, 18, 18, textureXSize, textureYSize);
            }
        }
        for (int x = 0; x < 9; ++x) {
            guiGraphics.method_25290(this.resourceLocation, posX + x * 18, posY + 58, 150.0f, 0.0f, 18, 18, textureXSize, textureYSize);
        }
    }

    public void drawSlot(class_332 guiGraphics, int posX, int posY, int textureXSize, int textureYSize) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        guiGraphics.method_25290(this.resourceLocation, posX, posY, 150.0f, 0.0f, 18, 18, textureXSize, textureYSize);
    }

    public void drawProgressBar(class_332 guiGraphics, int progress, int maxProgress, int x, int y, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        guiGraphics.method_25290(this.resourceLocation, x, y, 150.0f, 18.0f, 23, 15, 256, 256);
        int j = (int)((double)progress / (double)maxProgress * 24.0);
        if (j < 0) {
            j = 0;
        }
        guiGraphics.method_25290(this.resourceLocation, x, y, 173.0f, 18.0f, j, 16, 256, 256);
        if (this.isInRect(x, y, 26, 15, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(class_2561.method_43470((String)(this.getPercentageColour(percentage) + percentage + "%")));
            guiGraphics.method_51437(this.mc.field_1772, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawTankWithOverlay(class_332 guiGraphics, FluidStack fluidStack, int capacity, int x, int y, int height, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        guiGraphics.method_25290(this.resourceLocation, x, y, 228.0f, 18.0f, 22, 56, 256, 256);
        ScreenFluidRenderer screenFluidRenderer = new ScreenFluidRenderer(capacity, 16, height, 0);
        screenFluidRenderer.render(x + 3, y + 3, fluidStack);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        guiGraphics.method_25290(this.resourceLocation, x + 3, y + 3, 231.0f, 74.0f, 16, 50, 256, 256);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            if (fluidStack.getFluid() != null) {
                list.add(class_2561.method_43470((String)(fluidStack.getAmount() + " / " + capacity + " " + fluidStack.getName().getString())));
            } else {
                list.add(class_2561.method_43470((String)"empty"));
            }
            guiGraphics.method_51437(this.mc.field_1772, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawBar(class_332 guiGraphics, int x, int y, int height, int value, int maxValue, int mouseX, int mouseY, class_2561 tooltip) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        int draw = (int)((double)value / (double)maxValue * (double)(height - 2));
        guiGraphics.method_25290(this.resourceLocation, x, y, 1.0f, 150.0f, 13, height, 256, 256);
        guiGraphics.method_25290(this.resourceLocation, x + 1, y + height - draw - 1, 14.0f, 150.0f, 12, draw, 256, 256);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            guiGraphics.method_51438(this.mc.field_1772, tooltip, mouseX, mouseY);
        }
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public class_124 getPercentageColour(int percentage) {
        if (percentage <= 10) {
            return class_124.field_1061;
        }
        if (percentage >= 75) {
            return class_124.field_1060;
        }
        return class_124.field_1054;
    }

    public int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }
}

