/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiContainer;
import net.creeperhost.polylib.client.modulargui.ModularGuiInjector;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_465;
import net.minecraft.class_768;

@JeiPlugin
public class PolyJEIPlugin
implements IModPlugin {
    private static final class_2960 ID = new class_2960("polylib", "jei_plugin");

    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ModularGuiContainer.class, (IGuiContainerHandler)new IGuiContainerHandler<ModularGuiContainer>(){

            public List<class_768> getGuiExtraAreas(ModularGuiContainer containerScreen) {
                return containerScreen.getModularGui().getJeiExclusions().stream().map(e -> e.getRectangle().toRect2i()).toList();
            }
        });
        registration.addGuiContainerHandler(class_465.class, (IGuiContainerHandler)new IGuiContainerHandler<class_465>(){

            public List<class_768> getGuiExtraAreas(class_465 containerScreen) {
                ModularGui gui = ModularGuiInjector.getActiveGui();
                return gui == null ? Collections.emptyList() : gui.getJeiExclusions().stream().map(e -> e.getRectangle().toRect2i()).toList();
            }
        });
        registration.addGhostIngredientHandler(ModularGuiContainer.class, (IGhostIngredientHandler)new IngredientDropHandler());
    }

    private static class IngredientDropHandler
    implements IGhostIngredientHandler<ModularGuiContainer> {
        private ModularGui gui;
        private boolean highlight = true;

        private IngredientDropHandler() {
        }

        public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(ModularGuiContainer screen, ITypedIngredient<I> ingredient, boolean doStart) {
            this.gui = screen.getModularGui();
            this.gui.setJeiHighlightTime(doStart ? 1200 : 60);
            boolean bl = this.highlight = !doStart;
            if (!doStart) {
                return Collections.emptyList();
            }
            ArrayList targets = new ArrayList();
            ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).ifPresent(stack -> this.gui.getJeiDropTargets().forEach(e -> targets.add(new DropTarget((GuiElement<?>)e))));
            return targets;
        }

        public void onComplete() {
            this.highlight = true;
            this.gui.setJeiHighlightTime(0);
        }

        public boolean shouldHighlightTargets() {
            return this.highlight;
        }
    }

    private record DropTarget<I>(GuiElement<?> element) implements IGhostIngredientHandler.Target<I>
    {
        public class_768 getArea() {
            return this.element.getRectangle().toRect2i();
        }

        public void accept(I ingredient) {
            this.element.getJeiDropConsumer().accept((class_1799)ingredient);
        }
    }
}

