/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import java.util.HashMap;
import java.util.Map;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumData<T extends Enum<T>>
extends AbstractDataStore<T> {
    private final Class<T> enumClass;
    public Map<Integer, T> indexToValue = new HashMap<Integer, T>();
    public Map<T, Integer> valueToIndex = new HashMap<T, Integer>();

    public EnumData(@NotNull T defaultValue) {
        this(((Enum)defaultValue).getDeclaringClass(), defaultValue);
    }

    public EnumData(Class<T> enumClass, @Nullable T defaultValue) {
        super(defaultValue);
        this.enumClass = enumClass;
        Enum[] v = (Enum[])enumClass.getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by EnumData is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.writeBoolean(this.value == null);
        if (this.value != null) {
            buf.method_10817((Enum)this.value);
        }
    }

    @Override
    public void fromBytes(class_2540 buf) {
        if (!buf.readBoolean()) {
            this.value = this.validValue(buf.method_10818(this.enumClass), (Enum)this.value);
        }
    }

    @Override
    public class_2520 toTag() {
        class_2487 nbt = new class_2487();
        if (this.value == null) {
            nbt.method_10556("null", true);
        } else {
            nbt.method_10567("value", this.valueToIndex.get(this.value).byteValue());
        }
        return nbt;
    }

    @Override
    public void fromTag(class_2520 tag) {
        if (tag instanceof class_2487) {
            class_2487 nbt = (class_2487)tag;
            this.value = nbt.method_10545("null") ? null : this.validValue((Enum)this.indexToValue.get(MathUtil.clamp(nbt.method_10571("value") & 0xFF, 0, this.indexToValue.size() - 1)), (Enum)this.value);
        }
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

