/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric;

import com.mojang.datafixers.util.Either;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientTooltipEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.creeperhost.polylib.PolyLibClient;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import org.jetbrains.annotations.NotNull;

public class PolyLibClientImpl {
    public static PolyLibClient.ToolTipResult postRenderTooltipPre(@NotNull class_1799 stack, class_332 graphics, int x, int y, int screenWidth, int screenHeight, @NotNull List<class_5684> components, @NotNull class_327 font, @NotNull class_8000 positioner) {
        EventResult result = ((ClientTooltipEvent.Render)ClientTooltipEvent.RENDER_PRE.invoker()).renderTooltip(graphics, components, x, y);
        return new TTR(x, y, font, result.isFalse());
    }

    public static PolyLibClient.ToolTipColour postTooltipColour(@NotNull class_1799 stack, class_332 graphics, int x, int y, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, @NotNull class_327 font, @NotNull List<class_5684> components) {
        return new TTC(backgroundStart, backgroundEnd, borderStart, borderEnd);
    }

    public static List<class_5684> postGatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 font) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        int tooltipTextWidth = elements.stream().mapToInt(either -> {
            Objects.requireNonNull(font);
            return (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0);
        }).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (needsWrap) {
            int finalTooltipTextWidth = tooltipTextWidth;
            return elements.stream().flatMap(either -> (Stream)either.map(text -> font.method_1728(text, finalTooltipTextWidth).stream().map(class_5684::method_32662), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
        }
        return elements.stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), class_5684::method_32663)).toList();
    }

    public static void onItemDecorate(class_332 guiGraphics, class_327 font, class_1799 stack, int xOffset, int yOffset) {
    }

    private record TTR(int x, int y, class_327 font, boolean canceled) implements PolyLibClient.ToolTipResult
    {
        @Override
        @NotNull
        public class_327 getFont() {
            return this.font;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }
    }

    private record TTC(int backgroundStart, int backgroundEnd, int borderStart, int borderEnd) implements PolyLibClient.ToolTipColour
    {
        @Override
        public int getBackgroundStart() {
            return this.backgroundStart;
        }

        @Override
        public int getBackgroundEnd() {
            return this.backgroundEnd;
        }

        @Override
        public int getBorderStart() {
            return this.borderStart;
        }

        @Override
        public int getBorderEnd() {
            return this.borderEnd;
        }
    }
}

