/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.inventory.energy;

import net.creeperhost.polylib.fabric.inventory.ItemStackStorage;
import net.creeperhost.polylib.inventory.energy.PlatformItemEnergyManager;
import net.creeperhost.polylib.inventory.item.ItemStackHolder;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import team.reborn.energy.api.EnergyStorage;

public record FabricItemEnergyManager(class_1799 stack, ContainerItemContext context, EnergyStorage energy) implements PlatformItemEnergyManager
{
    public FabricItemEnergyManager(class_1799 stack) {
        this(stack, ItemStackStorage.of(stack));
    }

    public FabricItemEnergyManager(class_1799 stack, ContainerItemContext context) {
        this(stack, context, (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)context));
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getAmount();
    }

    @Override
    public long getCapacity() {
        return this.energy.getCapacity();
    }

    @Override
    public long extract(ItemStackHolder holder, long amount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long extract = this.energy.extract(amount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
                holder.setStack(this.context.getItemVariant().toStack());
            }
            long l = extract;
            return l;
        }
    }

    @Override
    public long insert(ItemStackHolder holder, long amount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long insert = this.energy.insert(amount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
                holder.setStack(this.context.getItemVariant().toStack());
            }
            long l = insert;
            return l;
        }
    }

    @Override
    public boolean supportsInsertion() {
        return this.energy.supportsInsertion();
    }

    @Override
    public boolean supportsExtraction() {
        return this.energy.supportsExtraction();
    }
}

