/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.power;

import net.creeperhost.polylib.PolyLibPlatform;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public interface EnergyManager {
    @Nullable
    public IPolyEnergyStorage getBlockEnergyStorage(class_2586 var1, @Nullable class_2350 var2);

    @Nullable
    public IPolyEnergyStorageItem getItemEnergyStorage(class_1799 var1);

    public static IPolyEnergyStorage getHandler(class_2586 tile, @Nullable class_2350 side) {
        return PolyLibPlatform.getEnergyManager().getBlockEnergyStorage(tile, side);
    }

    public static IPolyEnergyStorageItem getHandler(class_1799 stack) {
        return stack.method_7960() ? null : PolyLibPlatform.getEnergyManager().getItemEnergyStorage(stack);
    }

    public static long insertEnergy(class_2586 tile, long energy, class_2350 side, boolean simulate) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        if (storage != null && storage.canReceive()) {
            return storage.receiveEnergy(energy, simulate);
        }
        return 0L;
    }

    public static long insertEnergy(class_1799 stack, long energy, boolean simulate) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        if (storage != null && storage.canReceive()) {
            return storage.receiveEnergy(energy, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(class_2586 tile, long energy, class_2350 side, boolean simulate) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        if (storage != null && storage.canExtract()) {
            return storage.extractEnergy(energy, simulate);
        }
        return 0L;
    }

    public static long transferEnergy(IPolyEnergyStorage source, IPolyEnergyStorage target) {
        return target.receiveEnergy(source.extractEnergy(target.receiveEnergy(target.getMaxEnergyStored(), true), false), false);
    }

    public static long transferEnergy(class_2586 source, class_2350 sourceSide, IPolyEnergyStorage target) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(source, sourceSide);
        return storage == null ? 0L : EnergyManager.transferEnergy(storage, target);
    }

    public static long transferEnergy(IPolyEnergyStorage source, class_2586 target, class_2350 targetSide) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(target, targetSide);
        return storage == null ? 0L : EnergyManager.transferEnergy(source, storage);
    }

    public static long transferEnergy(class_1799 source, class_2586 target, class_2350 targetSide) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(source);
        return storage == null ? 0L : EnergyManager.transferEnergy(storage, target, targetSide);
    }

    public static long transferEnergy(class_2586 source, class_2350 sourceSide, class_2586 target, class_2350 targetSide) {
        IPolyEnergyStorage sourceStorage = EnergyManager.getHandler(source, sourceSide);
        if (sourceStorage == null) {
            return 0L;
        }
        IPolyEnergyStorage targetHandler = EnergyManager.getHandler(target, targetSide);
        return targetHandler == null ? 0L : EnergyManager.transferEnergy(sourceStorage, targetHandler);
    }

    public static boolean canExtractEnergy(class_1799 stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage != null && storage.canExtract();
    }

    public static boolean canReceiveEnergy(class_1799 stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage != null && storage.canReceive();
    }

    public static boolean canExtractEnergy(class_2586 tile, class_2350 side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage != null && storage.canExtract();
    }

    public static boolean canReceiveEnergy(class_2586 tile, class_2350 side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage != null && storage.canReceive();
    }

    public static long getEnergyStored(class_2586 tile, class_2350 side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage == null ? 0L : storage.getEnergyStored();
    }

    public static long getMaxEnergyStored(class_2586 tile, class_2350 side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage == null ? 0L : storage.getMaxEnergyStored();
    }

    public static long getEnergyStored(class_1799 stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage == null ? 0L : storage.getEnergyStored();
    }

    public static long getMaxEnergyStored(class_1799 stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage == null ? 0L : storage.getMaxEnergyStored();
    }

    public static boolean isEnergyItem(class_1799 stack) {
        return EnergyManager.getHandler(stack) != null;
    }

    public static boolean isEnergyBlock(class_2586 tile) {
        return EnergyManager.getHandler(tile, null) != null;
    }

    public static boolean isEnergyBlock(class_2586 tile, class_2350 direction) {
        return EnergyManager.getHandler(tile, null) != null;
    }
}

