/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Consumer;
import net.creeperhost.polylib.containers.DataManagerContainer;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolyLibNetwork {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 CONTAINER_PACKET_TO_CLIENT = new class_2960("polylib", "container_to_client");
    private static final class_2960 TILE_DATA_VALUE_TO_CLIENT = new class_2960("polylib", "tile_to_client");
    private static final class_2960 CONTAINER_PACKET_TO_SERVER = new class_2960("polylib", "container_packet_server");
    private static final class_2960 TILE_DATA_VALUE_TO_SERVER = new class_2960("polylib", "tile_data_server");
    private static final class_2960 TILE_PACKET_TO_SERVER = new class_2960("polylib", "tile_packet_server");

    public static void init() {
        if (Platform.getEnv() == EnvType.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)CONTAINER_PACKET_TO_CLIENT, (buf, context) -> {
                ByteBuf copy = buf.copy();
                context.queue(() -> ModularGuiContainerMenu.handlePacketFromServer(context.getPlayer(), new class_2540(copy)));
            });
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)TILE_DATA_VALUE_TO_CLIENT, (buf, context) -> {
                ByteBuf copy = buf.copy();
                context.queue(() -> PolyLibNetwork.handleTileDataValueFromServer(context.getPlayer(), new class_2540(copy)));
            });
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)CONTAINER_PACKET_TO_SERVER, (buf, context) -> {
            ByteBuf copy = buf.copy();
            context.queue(() -> ModularGuiContainerMenu.handlePacketFromClient(context.getPlayer(), new class_2540(copy)));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)TILE_DATA_VALUE_TO_SERVER, (buf, context) -> {
            ByteBuf copy = buf.copy();
            context.queue(() -> PolyLibNetwork.handleTileDataValueFromClient(context.getPlayer(), new class_2540(copy)));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)TILE_PACKET_TO_SERVER, (buf, context) -> {
            ByteBuf copy = buf.copy();
            context.queue(() -> PolyLibNetwork.handleTilePacketFromClient(context.getPlayer(), new class_2540(copy)));
        });
    }

    public static void sendContainerPacketToServer(Consumer<class_2540> packetWriter) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        packetWriter.accept(buf);
        NetworkManager.sendToServer((class_2960)CONTAINER_PACKET_TO_SERVER, (class_2540)buf);
    }

    public static void sendDataValueToServerTile(Consumer<class_2540> packetWriter) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        packetWriter.accept(buf);
        NetworkManager.sendToServer((class_2960)TILE_DATA_VALUE_TO_SERVER, (class_2540)buf);
    }

    public static void sendPacketToServerTile(Consumer<class_2540> packetWriter) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        packetWriter.accept(buf);
        NetworkManager.sendToServer((class_2960)TILE_PACKET_TO_SERVER, (class_2540)buf);
    }

    public static void sendContainerPacketToClient(class_3222 player, Consumer<class_2540> packetWriter) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        packetWriter.accept(buf);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)CONTAINER_PACKET_TO_CLIENT, (class_2540)buf);
    }

    public static void sendTileDataValueToClients(class_1937 level, class_2338 pos, Consumer<class_2540> packetWriter) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2540 buf = new class_2540(Unpooled.buffer());
            packetWriter.accept(buf);
            List players = serverLevel.method_14178().field_17254.method_17210(new class_1923(pos), false);
            NetworkManager.sendToPlayers((Iterable)players, (class_2960)TILE_DATA_VALUE_TO_CLIENT, (class_2540)buf);
        }
    }

    private static void handleTileDataValueFromClient(class_1657 player, class_2540 packet) {
        try {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof DataManagerContainer) {
                DataManagerContainer menu = (DataManagerContainer)class_17032;
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    menu.handleDataValueFromClient(serverPlayer, packet);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong while attempting to read a value packet sent from this client: {}", (Object)player, (Object)e);
        }
    }

    public static void handleTileDataValueFromServer(class_1657 player, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        try {
            class_2586 class_25862 = player.method_37908().method_8321(pos);
            if (class_25862 instanceof DataManagerBlock) {
                DataManagerBlock tile = (DataManagerBlock)class_25862;
                tile.getDataManager().handleSyncFromServer(player, packet);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to handle tile data from server. Tile pos: {}", (Object)pos, (Object)e);
        }
    }

    private static void handleTilePacketFromClient(class_1657 player, class_2540 packet) {
        try {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof DataManagerContainer) {
                DataManagerContainer menu = (DataManagerContainer)class_17032;
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    menu.handlePacketFromClient(serverPlayer, packet);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong while attempting to read a packet sent from this client: {}", (Object)player, (Object)e);
        }
    }
}

