/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_3719;
import net.minecraft.class_7923;

public class MountedStorage {
    ItemStackHandler handler;
    boolean noFuel;
    boolean valid;
    private class_2586 blockEntity;

    public static boolean canUseAsStorage(class_2586 be) {
        if (be == null) {
            return false;
        }
        if (be instanceof MechanicalCrafterBlockEntity) {
            return false;
        }
        if (AllBlockEntityTypes.CREATIVE_CRATE.is(be)) {
            return true;
        }
        if (be instanceof class_2627) {
            return true;
        }
        if (be instanceof class_2595) {
            return true;
        }
        if (be instanceof class_3719) {
            return true;
        }
        if (be instanceof ItemVaultBlockEntity) {
            return true;
        }
        try {
            Storage handler = TransferUtil.getItemStorage((class_2586)be);
            if (handler instanceof ItemStackHandler) {
                return !(handler instanceof ProcessingInventory);
            }
            return handler != null && MountedStorage.canUseModdedInventory(be, (Storage<ItemVariant>)handler);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canUseModdedInventory(class_2586 be, Storage<ItemVariant> handler) {
        if (!handler.supportsExtraction() || !handler.supportsInsertion()) {
            return false;
        }
        class_2680 blockState = be.method_11010();
        if (AllTags.AllBlockTags.CONTRAPTION_INVENTORY_DENY.matches(blockState)) {
            return false;
        }
        String blockId = class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12832();
        if (blockId.contains("ender")) {
            return false;
        }
        return blockId.endsWith("_chest") || blockId.endsWith("_barrel");
    }

    public MountedStorage(class_2586 be) {
        this.blockEntity = be;
        this.noFuel = be instanceof ItemVaultBlockEntity;
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.blockEntity == null) {
            return;
        }
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof class_2595) {
            class_2595 chest = (class_2595)class_25862;
            class_2487 tag = this.blockEntity.method_38242();
            if (tag.method_10573("LootTable", 8)) {
                return;
            }
            this.handler = new ItemStackHandler(chest.method_5439());
            for (int i = 0; i < this.handler.getSlotCount(); ++i) {
                this.handler.setStackInSlot(i, chest.method_5438(i));
            }
            this.valid = true;
            return;
        }
        if (this.blockEntity instanceof ItemVaultBlockEntity) {
            this.handler = ((ItemVaultBlockEntity)this.blockEntity).getInventoryOfBlock();
            this.valid = true;
            return;
        }
        Storage beHandler = TransferUtil.getItemStorage((class_2586)this.blockEntity);
        if (beHandler == null) {
            return;
        }
        if (beHandler instanceof ItemStackHandler) {
            this.handler = (ItemStackHandler)beHandler;
            this.valid = true;
            return;
        }
        if (beHandler instanceof InventoryStorage) {
            InventoryStorage inv = (InventoryStorage)beHandler;
            if (beHandler.supportsInsertion() && beHandler.supportsExtraction()) {
                try (Transaction t = TransferUtil.getTransaction();){
                    List slots = inv.getSlots();
                    class_1799[] stacks = new class_1799[slots.size()];
                    for (int i = 0; i < slots.size(); ++i) {
                        SingleSlotStorage slot = (SingleSlotStorage)slots.get(i);
                        if (slot.isResourceBlank()) {
                            stacks[i] = class_1799.field_8037;
                            continue;
                        }
                        long contained = slot.getAmount();
                        ItemVariant variant = (ItemVariant)slot.getResource();
                        long extracted = slot.extract((Object)variant, contained, (TransactionContext)t);
                        if (extracted != contained) {
                            return;
                        }
                        stacks[i] = variant.toStack((int)extracted);
                    }
                    this.handler = new ItemStackHandler(stacks);
                    this.valid = true;
                }
            }
        }
    }

    public void addStorageToWorld(class_2586 be) {
        if (this.handler instanceof BottomlessItemHandler) {
            return;
        }
        if (be instanceof class_2595) {
            class_2595 chest = (class_2595)be;
            for (int i = 0; i < chest.method_5439(); ++i) {
                class_1799 stack = i < this.handler.getSlotCount() ? this.handler.getStackInSlot(i) : class_1799.field_8037;
                chest.method_5447(i, stack);
            }
            return;
        }
        if (be instanceof ItemVaultBlockEntity) {
            ((ItemVaultBlockEntity)be).applyInventoryToBlock(this.handler);
            return;
        }
        Storage teHandler = TransferUtil.getItemStorage((class_2586)be);
        if (teHandler != null && teHandler.supportsInsertion()) {
            try (Transaction t = TransferUtil.getTransaction();){
                TransferUtil.clearStorage((Storage)teHandler);
                for (StorageView view : this.handler.nonEmptyViews()) {
                    teHandler.insert((Object)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)t);
                }
                t.commit();
            }
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.handler;
    }

    public class_2487 serialize() {
        if (!this.valid) {
            return null;
        }
        class_2487 tag = this.handler.serializeNBT();
        if (this.noFuel) {
            NBTHelper.putMarker(tag, "NoFuel");
        }
        if (this.handler instanceof ToolboxInventory) {
            NBTHelper.putMarker(tag, "Toolbox");
        }
        if (!(this.handler instanceof BottomlessItemHandler)) {
            return tag;
        }
        NBTHelper.putMarker(tag, "Bottomless");
        tag.method_10566("ProvidedStack", NBTSerializer.serializeNBT((Object)this.handler.getStackInSlot(0)));
        return tag;
    }

    public static MountedStorage deserialize(class_2487 nbt) {
        MountedStorage storage = new MountedStorage(null);
        storage.handler = new ItemStackHandler();
        if (nbt == null) {
            return storage;
        }
        if (nbt.method_10545("Toolbox")) {
            storage.handler = new ToolboxInventory(null);
        }
        storage.valid = true;
        storage.noFuel = nbt.method_10545("NoFuel");
        if (nbt.method_10545("Bottomless")) {
            class_1799 providedStack = class_1799.method_7915((class_2487)nbt.method_10562("ProvidedStack"));
            storage.handler = new BottomlessItemHandler(() -> providedStack);
            return storage;
        }
        storage.handler.deserializeNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean canUseForFuel() {
        return this.isValid() && !this.noFuel;
    }
}

