/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.impl;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.zestyblaze.lootr.api.ILootrAPI;
import net.zestyblaze.lootr.api.LootFiller;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.MenuBuilder;
import net.zestyblaze.lootr.api.inventory.ILootrInventory;
import net.zestyblaze.lootr.config.ConfigManager;
import net.zestyblaze.lootr.data.DataStorage;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import org.jetbrains.annotations.Nullable;

public class LootrAPIImpl
implements ILootrAPI {
    @Override
    public boolean isFakePlayer(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 splayer = (class_3222)player;
            return splayer.field_13987 == null || splayer.getClass() != class_3222.class;
        }
        return false;
    }

    @Override
    public boolean clearPlayerLoot(UUID id) {
        return DataStorage.clearInventories(id);
    }

    @Override
    @Nullable
    public ILootrInventory getInventory(class_1937 level, UUID id, class_2338 pos, class_3222 player, class_2624 blockEntity, LootFiller filler, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier) {
        return DataStorage.getInventory(level, id, pos, player, blockEntity, filler, tableSupplier, seedSupplier);
    }

    @Override
    @Nullable
    public ILootrInventory getInventory(class_1937 level, UUID id, class_2338 pos, class_3222 player, class_2624 blockEntity, LootFiller filler, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier, MenuBuilder menuBuilder) {
        SpecialChestInventory inventory = DataStorage.getInventory(level, id, pos, player, blockEntity, filler, tableSupplier, seedSupplier);
        if (inventory != null) {
            inventory.setMenuBuilder(menuBuilder);
        }
        return inventory;
    }

    @Override
    @Nullable
    public ILootrInventory getInventory(class_1937 level, UUID id, class_2338 pos, class_3222 player, IntSupplier sizeSupplier, Supplier<class_2561> displaySupplier, LootFiller filler, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier) {
        return DataStorage.getInventory(level, id, pos, player, sizeSupplier, displaySupplier, filler, tableSupplier, seedSupplier);
    }

    @Override
    @Nullable
    public ILootrInventory getInventory(class_1937 level, UUID id, class_2338 pos, class_3222 player, IntSupplier sizeSupplier, Supplier<class_2561> displaySupplier, LootFiller filler, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier, MenuBuilder menuBuilder) {
        SpecialChestInventory inventory = DataStorage.getInventory(level, id, pos, player, sizeSupplier, displaySupplier, filler, tableSupplier, seedSupplier);
        if (inventory != null) {
            inventory.setMenuBuilder(menuBuilder);
        }
        return inventory;
    }

    @Override
    public long getLootSeed(long seed) {
        if (ConfigManager.get().seed.randomize_seed || seed == -1L) {
            return ThreadLocalRandom.current().nextLong();
        }
        return seed;
    }

    @Override
    public boolean isSavingStructure() {
        return this.shouldDiscard();
    }

    @Override
    public boolean shouldDiscard() {
        return LootrAPI.shouldDiscardIdAndOpeners;
    }

    @Override
    public float getExplosionResistance(class_2248 block, float defaultResistance) {
        if (ConfigManager.get().breaking.blast_resistant) {
            return 16.0f;
        }
        if (ConfigManager.get().breaking.blast_immune) {
            return Float.MAX_VALUE;
        }
        return defaultResistance;
    }

    @Override
    public float getDestroyProgress(class_2680 state, class_1657 player, class_1922 level, class_2338 position, float defaultProgress) {
        if (ConfigManager.isBreakDisabled()) {
            return 0.0f;
        }
        return defaultProgress;
    }

    @Override
    public int getAnalogOutputSignal(class_2680 pBlockState, class_1937 pLevel, class_2338 pPos, int defaultSignal) {
        if (ConfigManager.get().breaking.power_comparators) {
            return 1;
        }
        return defaultSignal;
    }
}

