/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public class AsPropertyTypeDeserializer
extends AsArrayTypeDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JsonTypeInfo.As _inclusion;
    protected final String _msgForMissingId;

    public AsPropertyTypeDeserializer(JavaType bt2, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        this(bt2, idRes, typePropertyName, typeIdVisible, defaultImpl, JsonTypeInfo.As.PROPERTY);
    }

    public AsPropertyTypeDeserializer(JavaType bt2, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion) {
        super(bt2, idRes, typePropertyName, typeIdVisible, defaultImpl);
        this._msgForMissingId = this._property == null ? String.format("missing type id property '%s'", this._typePropertyName) : String.format("missing type id property '%s' (for POJO property '%s')", this._typePropertyName, this._property.getName());
        this._inclusion = inclusion;
    }

    public AsPropertyTypeDeserializer(AsPropertyTypeDeserializer src, BeanProperty property) {
        super(src, property);
        this._msgForMissingId = this._property == null ? String.format("missing type id property '%s'", this._typePropertyName) : String.format("missing type id property '%s' (for POJO property '%s')", this._typePropertyName, this._property.getName());
        this._inclusion = src._inclusion;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsPropertyTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return this._inclusion;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (p2.canReadTypeId() && (typeId = p2.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(p2, ctxt, typeId);
        }
        JsonToken t2 = p2.currentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p2.nextToken();
        } else if (t2 != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(p2, ctxt, null, this._msgForMissingId);
        }
        TokenBuffer tb2 = null;
        boolean ignoreCase = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (t2 == JsonToken.FIELD_NAME) {
            String typeId2;
            String name = p2.currentName();
            p2.nextToken();
            if ((name.equals(this._typePropertyName) || ignoreCase && name.equalsIgnoreCase(this._typePropertyName)) && (typeId2 = p2.getValueAsString()) != null) {
                return this._deserializeTypedForId(p2, ctxt, tb2, typeId2);
            }
            if (tb2 == null) {
                tb2 = ctxt.bufferForInputBuffering(p2);
            }
            tb2.writeFieldName(name);
            tb2.copyCurrentStructure(p2);
            t2 = p2.nextToken();
        }
        return this._deserializeTypedUsingDefaultImpl(p2, ctxt, tb2, this._msgForMissingId);
    }

    protected Object _deserializeTypedForId(JsonParser p2, DeserializationContext ctxt, TokenBuffer tb2, String typeId) throws IOException {
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId);
        if (this._typeIdVisible) {
            if (tb2 == null) {
                tb2 = ctxt.bufferForInputBuffering(p2);
            }
            tb2.writeFieldName(p2.currentName());
            tb2.writeString(typeId);
        }
        if (tb2 != null) {
            p2.clearCurrentToken();
            p2 = JsonParserSequence.createFlattened(false, tb2.asParser(p2), p2);
        }
        if (p2.currentToken() != JsonToken.END_OBJECT) {
            p2.nextToken();
        }
        return deser.deserialize(p2, ctxt);
    }

    @Deprecated
    protected Object _deserializeTypedUsingDefaultImpl(JsonParser p2, DeserializationContext ctxt, TokenBuffer tb2) throws IOException {
        return this._deserializeTypedUsingDefaultImpl(p2, ctxt, tb2, null);
    }

    protected Object _deserializeTypedUsingDefaultImpl(JsonParser p2, DeserializationContext ctxt, TokenBuffer tb2, String priorFailureMsg) throws IOException {
        JsonDeserializer<Object> deser;
        if (!this.hasDefaultImpl()) {
            String str;
            Object result2 = TypeDeserializer.deserializeIfNatural(p2, ctxt, this._baseType);
            if (result2 != null) {
                return result2;
            }
            if (p2.isExpectedStartArrayToken()) {
                return super.deserializeTypedFromAny(p2, ctxt);
            }
            if (p2.hasToken(JsonToken.VALUE_STRING) && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p2.getText().trim()).isEmpty()) {
                return null;
            }
        }
        if ((deser = this._findDefaultImplDeserializer(ctxt)) == null) {
            JavaType t2 = this._handleMissingTypeId(ctxt, priorFailureMsg);
            if (t2 == null) {
                return null;
            }
            deser = ctxt.findContextualValueDeserializer(t2, this._property);
        }
        if (tb2 != null) {
            tb2.writeEndObject();
            p2 = tb2.asParser(p2);
            p2.nextToken();
        }
        return deser.deserialize(p2, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.START_ARRAY)) {
            return super.deserializeTypedFromArray(p2, ctxt);
        }
        return this.deserializeTypedFromObject(p2, ctxt);
    }
}

