/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.io.InputStream;

public class CBORParserBootstrapper {
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public CBORParserBootstrapper(IOContext ctxt, InputStream in2) {
        this._context = ctxt;
        this._in = in2;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public CBORParserBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this._context = ctxt;
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputEnd = inputStart + inputLen;
        this._inputProcessed = -inputStart;
        this._bufferRecyclable = false;
    }

    public CBORParser constructParser(int factoryFeatures, int generalParserFeatures, int formatFeatures, ObjectCodec codec, ByteQuadsCanonicalizer rootByteSymbols) throws IOException, JsonParseException {
        ByteQuadsCanonicalizer can = rootByteSymbols.makeChildOrPlaceholder(factoryFeatures);
        this.ensureLoaded(1);
        CBORParser p2 = new CBORParser(this._context, generalParserFeatures, formatFeatures, codec, can, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        if (this._inputPtr < this._inputEnd) {
            // empty if block
        }
        return p2;
    }

    public static MatchStrength hasCBORFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b2 = acc.nextByte();
        if (b2 == -65) {
            if (acc.hasMoreBytes()) {
                b2 = acc.nextByte();
                if (b2 == -1) {
                    return MatchStrength.SOLID_MATCH;
                }
                if (CBORConstants.hasMajorType(3, b2)) {
                    return MatchStrength.SOLID_MATCH;
                }
                return MatchStrength.INCONCLUSIVE;
            }
        } else if (b2 == -97) {
            if (acc.hasMoreBytes()) {
                b2 = acc.nextByte();
                if (b2 == -1) {
                    return MatchStrength.SOLID_MATCH;
                }
                return MatchStrength.WEAK_MATCH;
            }
        } else {
            if (CBORConstants.hasMajorType(6, b2)) {
                if (b2 == -39 && acc.hasMoreBytes() && (b2 = acc.nextByte()) == -39 && acc.hasMoreBytes() && (b2 = acc.nextByte()) == -9) {
                    return MatchStrength.FULL_MATCH;
                }
                return MatchStrength.WEAK_MATCH;
            }
            if (CBORConstants.hasMajorType(7, b2)) {
                if (b2 == -12 || b2 == -11 || b2 == -10) {
                    return MatchStrength.SOLID_MATCH;
                }
                return MatchStrength.NO_MATCH;
            }
        }
        return MatchStrength.INCONCLUSIVE;
    }

    protected boolean ensureLoaded(int minimum) throws IOException {
        int count2;
        if (this._in == null) {
            return false;
        }
        for (int gotten = this._inputEnd - this._inputPtr; gotten < minimum; gotten += count2) {
            count2 = this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (count2 < 1) {
                return false;
            }
            this._inputEnd += count2;
        }
        return true;
    }
}

