/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.ethlo.time.ITU;
import com.ethlo.time.LeapSecondException;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private final String formatName;
    private final String DATE = "date";
    private final String DATETIME = "date-time";

    public DateTimeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, String formatName) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.DATETIME, validationContext);
        this.formatName = formatName;
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (!this.isLegalDateTime(node.textValue())) {
            errors.add(this.buildValidationMessage(at2, node.textValue(), this.formatName));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isLegalDateTime(String string) {
        if (this.formatName.equals("date")) {
            return this.tryParse(() -> LocalDate.parse(string));
        }
        if (this.formatName.equals("date-time")) {
            return this.tryParse(() -> {
                block2: {
                    try {
                        ITU.parseDateTime(string);
                    }
                    catch (LeapSecondException ex2) {
                        if (ex2.isVerifiedValidLeapYearMonth()) break block2;
                        throw ex2;
                    }
                }
            });
        }
        throw new IllegalStateException("Unknown format: " + this.formatName);
    }

    private boolean tryParse(Runnable parser) {
        try {
            parser.run();
            return true;
        }
        catch (Exception ex2) {
            logger.error("Invalid " + this.formatName + ": " + ex2.getMessage());
            return false;
        }
    }
}

