/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ThreadInfo;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import com.networknt.schema.walk.JsonSchemaWalker;
import com.networknt.schema.walk.WalkListenerRunner;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonSchema
extends BaseJsonValidator {
    private static final Pattern intPattern = Pattern.compile("^[0-9]+$");
    private Map<String, JsonValidator> validators;
    private final JsonMetaSchema metaSchema;
    private boolean validatorsLoaded = false;
    private final URI currentUri;
    private JsonValidator requiredValidator = null;
    private JsonValidator unevaluatedPropertiesValidator = null;
    WalkListenerRunner keywordWalkListenerRunner = null;
    private static Comparator<String> VALIDATOR_SORT = (lhs, rhs) -> {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.endsWith("/properties")) {
            return -1;
        }
        if (rhs.endsWith("/properties")) {
            return 1;
        }
        return lhs.compareTo((String)rhs);
    };

    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode) {
        this(validationContext, "#", baseUri, schemaNode, null);
    }

    public JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent) {
        this(validationContext, schemaPath, currentUri, schemaNode, parent, false);
    }

    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode, boolean suppressSubSchemaRetrieval) {
        this(validationContext, "#", baseUri, schemaNode, null, suppressSubSchemaRetrieval);
    }

    private JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaPath, schemaNode, parent, null, suppressSubSchemaRetrieval, validationContext.getConfig() != null && validationContext.getConfig().isFailFast(), validationContext.getConfig() != null ? validationContext.getConfig().getApplyDefaultsStrategy() : null);
        this.validationContext = validationContext;
        this.metaSchema = validationContext.getMetaSchema();
        this.currentUri = this.combineCurrentUriWithIds(currentUri, schemaNode);
        if (validationContext.getConfig() != null) {
            ObjectNode discriminator;
            this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.validationContext.getConfig().getKeywordWalkListenersMap());
            if (validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)schemaNode.get("discriminator")) && null != validationContext.getCurrentDiscriminatorContext()) {
                validationContext.getCurrentDiscriminatorContext().registerDiscriminator(schemaPath, discriminator);
            }
        }
    }

    ValidationContext getValidationContext() {
        return this.validationContext;
    }

    private URI combineCurrentUriWithIds(URI currentUri, JsonNode schemaNode) {
        String id2 = this.validationContext.resolveSchemaId(schemaNode);
        if (id2 == null) {
            return currentUri;
        }
        if (this.isUriFragmentWithNoContext(currentUri, id2)) {
            return null;
        }
        try {
            return this.validationContext.getURIFactory().create(currentUri, id2);
        }
        catch (IllegalArgumentException e2) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.ID.getValue(), (ErrorMessageType)ValidatorTypeCode.ID, id2, this.schemaPath, currentUri == null ? "null" : currentUri.toString()));
        }
    }

    private boolean isUriFragmentWithNoContext(URI currentUri, String id2) {
        return id2.startsWith("#") && currentUri == null;
    }

    public URI getCurrentUri() {
        return this.currentUri;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findAncestor();
        JsonNode node = schema.getSchemaNode();
        if (ref.startsWith("#/")) {
            String[] keys2;
            for (String key : keys2 = ref.substring(2).split("/")) {
                try {
                    key = URLDecoder.decode(key, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                Matcher matcher = intPattern.matcher(key);
                node = matcher.matches() ? node.get(Integer.parseInt(key)) : node.get(key);
                if (node == null) {
                    node = this.handleNullNode(ref, schema);
                }
                if (node != null) {
                    continue;
                }
                break;
            }
        } else if (ref.startsWith("#") && ref.length() > 1 && (node = this.metaSchema.getNodeByFragmentRef(ref, node)) == null) {
            node = this.handleNullNode(ref, schema);
        }
        return node;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private Map<String, JsonValidator> read(JsonNode schemaNode) {
        TreeMap<String, JsonValidator> validators = new TreeMap<String, JsonValidator>(VALIDATOR_SORT);
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                String customMessage = this.getCustomMessage(schemaNode, "true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "true", schemaNode, this, customMessage);
                validators.put(this.getSchemaPath() + "/true", validator);
            } else {
                String customMessage = this.getCustomMessage(schemaNode, "false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "false", schemaNode, this, customMessage);
                validators.put(this.getSchemaPath() + "/false", validator);
            }
        } else {
            Iterator<String> pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                String pname = pnames.next();
                JsonNode nodeToUse = pname.equals("if") ? schemaNode : schemaNode.get(pname);
                String customMessage = this.getCustomMessage(schemaNode, pname);
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), pname, nodeToUse, this, customMessage);
                if (ValidatorTypeCode.UNEVALUATED_PROPERTIES.getValue().equals(pname)) {
                    this.unevaluatedPropertiesValidator = validator;
                }
                if (validator == null || ValidatorTypeCode.UNEVALUATED_PROPERTIES.getValue().equals(pname)) continue;
                validators.put(this.getSchemaPath() + "/" + pname, validator);
                if (!pname.equals("required")) continue;
                this.requiredValidator = validator;
            }
        }
        return validators;
    }

    private String getCustomMessage(JsonNode schemaNode, String pname) {
        JsonSchema parentSchema = this.getParentSchema();
        JsonNode message = this.getMessageNode(schemaNode, parentSchema);
        if (message != null && message.get(pname) != null) {
            return message.get(pname).asText();
        }
        return null;
    }

    private JsonNode getMessageNode(JsonNode schemaNode, JsonSchema parentSchema) {
        JsonNode nodeContainingMessage = parentSchema == null ? schemaNode : parentSchema.schemaNode;
        return nodeContainingMessage.get("message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        try {
            Set<ValidationMessage> errors;
            Set<ValidationMessage> set = errors = this.validate(node, node, "$");
            return set;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode jsonNode, JsonNode rootNode, String at2) {
        ValidationContext.DiscriminatorContext discriminatorContext;
        ObjectNode discriminator;
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        this.getCollectorContext();
        this.setValidatorState(false, true);
        for (JsonValidator v2 : this.getValidators().values()) {
            errors.addAll(v2.validate(jsonNode, rootNode, at2));
        }
        errors.addAll(this.processUnEvaluatedProperties(jsonNode, rootNode, at2, true, true));
        if (null != config && config.isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = this.validationContext.getCurrentDiscriminatorContext())) {
            ObjectNode discriminatorToUse;
            ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaPath);
            if (null == discriminatorFromContext) {
                discriminatorContext.registerDiscriminator(this.schemaPath, discriminator);
                discriminatorToUse = discriminator;
            } else {
                discriminatorToUse = discriminatorFromContext;
            }
            String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
            JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
            JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
        }
        return errors;
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(node, node, "$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateAndCollect(JsonNode jsonNode, JsonNode rootNode, String at2) {
        try {
            ValidationResult validationResult;
            SchemaValidatorsConfig config = this.validationContext.getConfig();
            CollectorContext collectorContext = this.getCollectorContext();
            this.setValidatorState(false, true);
            Set<ValidationMessage> errors = this.validate(jsonNode, rootNode, at2);
            if (config.doLoadCollectors()) {
                collectorContext.loadCollectors();
            }
            ValidationResult validationResult2 = validationResult = new ValidationResult(errors, collectorContext);
            return validationResult2;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult walk(JsonNode node, boolean shouldValidateSchema) {
        try {
            ValidationResult validationResult;
            SchemaValidatorsConfig config = this.validationContext.getConfig();
            CollectorContext collectorContext = this.getCollectorContext();
            this.setValidatorState(true, shouldValidateSchema);
            Set<ValidationMessage> errors = this.walk(node, node, "$", shouldValidateSchema);
            if (config.doLoadCollectors()) {
                collectorContext.loadCollectors();
            }
            errors.addAll(this.processUnEvaluatedProperties(node, node, "$", shouldValidateSchema, false));
            ValidationResult validationResult2 = validationResult = new ValidationResult(errors, collectorContext);
            return validationResult2;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at2, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        for (Map.Entry<String, JsonValidator> entry : this.getValidators().entrySet()) {
            JsonSchemaWalker jsonWalker = entry.getValue();
            String schemaPathWithKeyword = entry.getKey();
            try {
                if (!this.keywordWalkListenerRunner.runPreWalkListeners(schemaPathWithKeyword, node, rootNode, at2, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory())) continue;
                validationMessages.addAll(jsonWalker.walk(node, rootNode, at2, shouldValidateSchema));
            }
            finally {
                this.keywordWalkListenerRunner.runPostWalkListeners(schemaPathWithKeyword, node, rootNode, at2, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
            }
        }
        if (shouldValidateSchema) {
            validationMessages.addAll(this.processUnEvaluatedProperties(node, rootNode, at2, true, true));
        }
        return validationMessages;
    }

    private void setValidatorState(boolean isWalkEnabled, boolean shouldValidateSchema) {
        Object stateObj = CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
        if (stateObj == null) {
            ValidatorState state = new ValidatorState();
            state.setWalkEnabled(isWalkEnabled);
            state.setValidationEnabled(shouldValidateSchema);
            CollectorContext.getInstance().add("com.networknt.schema.ValidatorState", state);
        }
    }

    public CollectorContext getCollectorContext() {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = (CollectorContext)ThreadInfo.get("com.networknt.schema.CollectorKey");
        if (collectorContext == null) {
            collectorContext = config != null && config.getCollectorContext() != null ? config.getCollectorContext() : new CollectorContext();
            ThreadInfo.set("com.networknt.schema.CollectorKey", collectorContext);
        }
        return collectorContext;
    }

    public String toString() {
        return "\"" + this.getSchemaPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public Map<String, JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableMap(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            this.validatorsLoaded = true;
            for (JsonValidator validator : this.getValidators().values()) {
                validator.preloadJsonSchema();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ValidationMessage> processUnEvaluatedProperties(JsonNode jsonNode, JsonNode rootNode, String at2, boolean shouldValidateSchema, boolean fromValidate) {
        if (this.unevaluatedPropertiesValidator == null) {
            return Collections.emptySet();
        }
        if (!fromValidate) {
            Set<ValidationMessage> validationMessages = new HashSet<ValidationMessage>();
            try {
                if (this.keywordWalkListenerRunner.runPreWalkListeners(this.getSchemaPath() + "/" + ValidatorTypeCode.UNEVALUATED_PROPERTIES.getValue(), jsonNode, rootNode, at2, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory())) {
                    validationMessages = this.unevaluatedPropertiesValidator.walk(jsonNode, rootNode, at2, shouldValidateSchema);
                }
            }
            finally {
                this.keywordWalkListenerRunner.runPostWalkListeners(this.getSchemaPath() + "/" + ValidatorTypeCode.UNEVALUATED_PROPERTIES.getValue(), jsonNode, rootNode, at2, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
            }
            return validationMessages;
        }
        return this.unevaluatedPropertiesValidator.walk(jsonNode, rootNode, at2, shouldValidateSchema);
    }
}

