/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<String> fieldNames = new ArrayList<String>();

    public ReadOnlyValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.READ_ONLY, validationContext);
        if (schemaNode.isArray()) {
            int size = schemaNode.size();
            for (int i2 = 0; i2 < size; ++i2) {
                this.fieldNames.add(schemaNode.get(i2).asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (String fieldName : this.fieldNames) {
            JsonNode propertyNode = node.get(fieldName);
            String datapath = "";
            datapath = at2.equals("$") ? datapath + "#original." + fieldName : datapath + "#original." + at2.substring(2) + "." + fieldName;
            JsonNode originalNode = this.getNode(datapath, rootNode);
            boolean theSame = propertyNode != null && originalNode != null && propertyNode.equals(originalNode);
            if (theSame) continue;
            errors.add(this.buildValidationMessage(at2, new String[0]));
        }
        return Collections.unmodifiableSet(errors);
    }

    private JsonNode getNode(String datapath, JsonNode data) {
        String path = this.getSubString(datapath, "$.");
        String[] parts = path.split("\\.");
        JsonNode result2 = null;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            if (parts[i2].contains("[")) {
                int idx1 = parts[i2].indexOf("[");
                int idx2 = parts[i2].indexOf("]");
                String key = parts[i2].substring(0, idx1).trim();
                int idx = Integer.parseInt(parts[i2].substring(idx1 + 1, idx2).trim());
                result2 = data.get(key).get(idx);
            } else {
                result2 = data.get(parts[i2]);
            }
            if (result2 == null) break;
            data = result2;
        }
        return result2;
    }

    private String getSubString(String datapath, String keyword) {
        String path = datapath;
        if (path.startsWith(keyword)) {
            path = path.substring(2);
        }
        return path;
    }
}

