/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.uri.URIFactory;
import com.networknt.schema.urn.URNFactory;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchemaRef schema;
    private JsonSchema parentSchema;
    private static final String REF_CURRENT = "#";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.parentSchema = parentSchema;
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef", new MessageFormat("{0}: Reference {1} cannot be resolved")), schemaPath, schemaPath, refValue));
        }
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        String refValueOriginal = refValue;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            URI schemaUri = RefValidator.determineSchemaUri(validationContext.getURIFactory(), parentSchema, refUri);
            if (schemaUri == null) {
                if (validationContext.getURNFactory() == null) {
                    return null;
                }
                schemaUri = RefValidator.determineSchemaUrn(validationContext.getURNFactory(), refUri);
                if (schemaUri == null) {
                    return null;
                }
            }
            parentSchema = validationContext.getJsonSchemaFactory().getSchema(schemaUri, validationContext.getConfig());
            if (index < 0) {
                return new JsonSchemaRef(parentSchema.findAncestor());
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(parentSchema.findAncestor());
        }
        JsonNode node = parentSchema.getRefSchemaNode(refValue);
        if (node != null) {
            JsonSchemaRef ref = validationContext.getReferenceParsingInProgress(refValueOriginal);
            if (ref == null) {
                JsonSchema schema = new JsonSchema(validationContext, refValue, parentSchema.getCurrentUri(), node, parentSchema);
                ref = new JsonSchemaRef(schema);
                validationContext.setReferenceParsingInProgress(refValueOriginal, ref);
            }
            return ref;
        }
        return null;
    }

    private static URI determineSchemaUri(URIFactory uriFactory, JsonSchema parentSchema, String refUri) {
        URI schemaUri;
        URI currentUri = parentSchema.getCurrentUri();
        try {
            schemaUri = currentUri == null ? uriFactory.create(refUri) : uriFactory.create(currentUri, refUri);
        }
        catch (IllegalArgumentException e2) {
            schemaUri = null;
        }
        return schemaUri;
    }

    private static URI determineSchemaUrn(URNFactory urnFactory, String refUri) {
        URI schemaUrn;
        try {
            schemaUrn = urnFactory.create(refUri);
        }
        catch (IllegalArgumentException e2) {
            schemaUrn = null;
        }
        return schemaUrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        Set<Object> errors;
        block5: {
            Object backupEvaluatedProperties;
            block4: {
                List backupEvaluatedPropertiesList;
                errors = new HashSet();
                backupEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                try {
                    this.debug(logger, node, rootNode, at2);
                    this.schema.getSchema().getValidationContext().setConfig(this.parentSchema.getValidationContext().getConfig());
                    errors = this.schema != null ? this.schema.validate(node, rootNode, at2) : Collections.emptySet();
                    if (!errors.isEmpty()) break block4;
                    backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                }
                catch (Throwable throwable) {
                    if (errors.isEmpty()) {
                        List backupEvaluatedPropertiesList2 = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                        backupEvaluatedPropertiesList2.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList2);
                    } else {
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
                    }
                    throw throwable;
                }
                backupEvaluatedPropertiesList.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
                break block5;
            }
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at2, boolean shouldValidateSchema) {
        HashSet<ValidationMessage> hashSet;
        block6: {
            Object backupEvaluatedProperties;
            block7: {
                List backupEvaluatedPropertiesList;
                Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
                backupEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                try {
                    this.debug(logger, node, rootNode, at2);
                    this.schema.getSchema().getValidationContext().setConfig(this.parentSchema.getValidationContext().getConfig());
                    if (this.schema != null) {
                        errors = this.schema.walk(node, rootNode, at2, shouldValidateSchema);
                    }
                    hashSet = errors;
                    if (!shouldValidateSchema) break block6;
                    if (!errors.isEmpty()) break block7;
                    backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                }
                catch (Throwable throwable) {
                    if (shouldValidateSchema) {
                        if (errors.isEmpty()) {
                            List backupEvaluatedPropertiesList2 = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                            backupEvaluatedPropertiesList2.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList2);
                        } else {
                            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
                        }
                    }
                    throw throwable;
                }
                backupEvaluatedPropertiesList.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
                break block6;
            }
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
        }
        return hashSet;
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        this.schema.getSchema().initializeValidators();
    }
}

