/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.UnionTypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.JsonNodeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final Logger logger = LoggerFactory.getLogger(TypeValidator.class);
    private JsonType schemaType;
    private JsonSchema parentSchema;
    private UnionTypeValidator unionTypeValidator;
    private static final char CHAR_0 = '0';
    private static final char CHAR_1 = '1';
    private static final char CHAR_9 = '9';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char DOT = '.';
    private static final char CHAR_E = 'E';
    private static final char CHAR_e = 'e';

    public TypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE, validationContext);
        this.schemaType = TypeFactory.getSchemaNodeType(schemaNode);
        this.parentSchema = parentSchema;
        this.validationContext = validationContext;
        if (this.schemaType == JsonType.UNION) {
            this.unionTypeValidator = new UnionTypeValidator(schemaPath, schemaNode, parentSchema, validationContext);
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    public JsonType getSchemaType() {
        return this.schemaType;
    }

    public boolean equalsToSchemaType(JsonNode node) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != this.schemaType) {
            if (this.schemaType == JsonType.ANY) {
                return true;
            }
            if (this.schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
            if (JsonType.NULL.equals((Object)nodeType) && (state.isComplexValidator() && JsonNodeUtil.isNodeNullable(this.parentSchema.getParentSchema().getSchemaNode(), this.validationContext.getConfig()) || JsonNodeUtil.isNodeNullable(this.getParentSchema().getSchemaNode()))) {
                return true;
            }
            if (TypeValidator.isEnumObjectSchema(this.parentSchema)) {
                return true;
            }
            if (this.validationContext.getConfig().isTypeLoose()) {
                if (this.schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING && (this.schemaType == JsonType.INTEGER ? TypeValidator.isInteger(node.textValue()) : (this.schemaType == JsonType.BOOLEAN ? TypeValidator.isBoolean(node.textValue()) : this.schemaType == JsonType.NUMBER && TypeValidator.isNumeric(node.textValue())))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        if (this.schemaType == JsonType.UNION) {
            return this.unionTypeValidator.validate(node, rootNode, at2);
        }
        if (!JsonNodeUtil.equalsToSchemaType(node, this.schemaType, this.parentSchema, this.validationContext.getConfig())) {
            JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
            return Collections.singleton(this.buildValidationMessage(at2, nodeType.toString(), this.schemaType.toString()));
        }
        if (this.schemaPath.endsWith("/type")) {
            this.addToEvaluatedProperties(at2);
        }
        return Collections.emptySet();
    }

    private void addToEvaluatedProperties(String propertyPath) {
        Object evaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
        ArrayList<String> evaluatedPropertiesList = null;
        if (evaluatedProperties == null) {
            evaluatedPropertiesList = new ArrayList<String>();
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", evaluatedPropertiesList);
        } else {
            evaluatedPropertiesList = (ArrayList<String>)evaluatedProperties;
        }
        evaluatedPropertiesList.add(propertyPath);
    }

    public static boolean isInteger(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        int i2 = 0;
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i2 = 1;
        }
        while (i2 < str.length()) {
            char c2 = str.charAt(i2);
            if (c2 < '0' || c2 > '9') {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isBoolean(String s2) {
        return "true".equals(s2) || "false".equals(s2);
    }

    public static boolean isNumeric(String str) {
        char c2;
        if (str == null || str.equals("")) {
            return false;
        }
        int i2 = 0;
        int len = str.length();
        if (str.charAt(i2) == '-' || str.charAt(i2) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i2 = 1;
        }
        if ((c2 = str.charAt(i2++)) == '0') {
            if (i2 < len && (c2 = str.charAt(i2++)) != '.' && c2 != 'E' && c2 != 'e') {
                return false;
            }
        } else if ('1' <= c2 && c2 <= '9') {
            while (i2 < len && '0' <= c2 && c2 <= '9') {
                c2 = str.charAt(i2++);
            }
        } else {
            return false;
        }
        if (c2 == '.') {
            if (i2 >= len) {
                return false;
            }
            c2 = str.charAt(i2++);
            while (i2 < len && '0' <= c2 && c2 <= '9') {
                c2 = str.charAt(i2++);
            }
        }
        if (c2 == 'E' || c2 == 'e') {
            if (i2 >= len) {
                return false;
            }
            if ((c2 = str.charAt(i2++)) == '+' || c2 == '-') {
                if (i2 >= len) {
                    return false;
                }
                c2 = str.charAt(i2++);
            }
            while (i2 < len && '0' <= c2 && c2 <= '9') {
                c2 = str.charAt(i2++);
            }
        }
        return i2 >= len && '0' <= c2 && c2 <= '9';
    }

    public static boolean isNumber(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return TypeValidator.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        JsonNode refNode = null;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            if (jsonSchema.getParentSchema() != null && jsonSchema.getParentSchema().getSchemaNode() != null) {
                refNode = jsonSchema.getParentSchema().getSchemaNode().get(REF);
            }
        }
        if (typeNode != null && enumNode != null && refNode != null) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

