/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.walk.AbstractWalkListenerRunner;
import com.networknt.schema.walk.JsonSchemaWalkListener;
import com.networknt.schema.walk.WalkEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultKeywordWalkListenerRunner
extends AbstractWalkListenerRunner {
    private Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap;

    public DefaultKeywordWalkListenerRunner(Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap) {
        this.keywordWalkListenersMap = keywordWalkListenersMap;
    }

    protected String getKeywordName(String keyWordPath) {
        return keyWordPath.substring(keyWordPath.lastIndexOf(47) + 1);
    }

    @Override
    public boolean runPreWalkListeners(String keyWordPath, JsonNode node, JsonNode rootNode, String at2, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchemaFactory currentJsonSchemaFactory) {
        String keyword = this.getKeywordName(keyWordPath);
        boolean continueRunningListenersAndWalk = true;
        WalkEvent keywordWalkEvent = this.constructWalkEvent(keyword, node, rootNode, at2, schemaPath, schemaNode, parentSchema, validationContext, currentJsonSchemaFactory);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        continueRunningListenersAndWalk = this.runPreWalkListeners(currentKeywordListeners, keywordWalkEvent);
        if (continueRunningListenersAndWalk) {
            List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("com.networknt.AllKeywordWalkListener");
            this.runPreWalkListeners(allKeywordListeners, keywordWalkEvent);
        }
        return continueRunningListenersAndWalk;
    }

    @Override
    public void runPostWalkListeners(String keyWordPath, JsonNode node, JsonNode rootNode, String at2, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchemaFactory currentJsonSchemaFactory, Set<ValidationMessage> validationMessages) {
        String keyword = this.getKeywordName(keyWordPath);
        WalkEvent keywordWalkEvent = this.constructWalkEvent(keyword, node, rootNode, at2, schemaPath, schemaNode, parentSchema, validationContext, currentJsonSchemaFactory);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        this.runPostWalkListeners(currentKeywordListeners, keywordWalkEvent, validationMessages);
        List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("com.networknt.AllKeywordWalkListener");
        this.runPostWalkListeners(allKeywordListeners, keywordWalkEvent, validationMessages);
    }
}

