/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class Strings {
    public static final String EMPTY = "";
    public static final String LINE_SEPARATOR = PropertiesUtil.getProperties().getStringProperty("line.separator", "\n");

    private Strings() {
    }

    public static String dquote(String str) {
        return '\"' + str + '\"';
    }

    public static boolean isBlank(String s2) {
        return s2 == null || s2.trim().isEmpty();
    }

    public static boolean isEmpty(CharSequence cs2) {
        return cs2 == null || cs2.length() == 0;
    }

    public static boolean isNotBlank(String s2) {
        return !Strings.isBlank(s2);
    }

    public static boolean isNotEmpty(CharSequence cs2) {
        return !Strings.isEmpty(cs2);
    }

    public static String quote(String str) {
        return '\'' + str + '\'';
    }

    public String toRootUpperCase(String str) {
        return str.toUpperCase(Locale.ROOT);
    }

    public static String trimToNull(String str) {
        String ts2 = str == null ? null : str.trim();
        return Strings.isEmpty(ts2) ? null : ts2;
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator2, char separator) {
        if (iterator2 == null) {
            return null;
        }
        if (!iterator2.hasNext()) {
            return EMPTY;
        }
        Object first2 = iterator2.next();
        if (!iterator2.hasNext()) {
            return Objects.toString(first2);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first2 != null) {
            buf.append(first2);
        }
        while (iterator2.hasNext()) {
            buf.append(separator);
            Object obj = iterator2.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }
}

