/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.primitives.Rectangled;
import org.joml.primitives.Rectanglei;

public class Rectanglef
implements Externalizable {
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;

    public Rectanglef() {
    }

    public Rectanglef(Rectanglef source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
    }

    public Rectanglef(Vector2fc min, Vector2fc max) {
        this.minX = min.x();
        this.minY = min.y();
        this.maxX = max.x();
        this.maxY = max.y();
    }

    public Rectanglef(float minX, float minY, float maxX, float maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public Rectanglef set(Rectanglef source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
        return this;
    }

    public Rectanglef setMin(float minX, float minY) {
        this.minX = minX;
        this.minY = minY;
        return this;
    }

    public Rectanglef setMin(Vector2fc min) {
        this.minX = min.x();
        this.minY = min.y();
        return this;
    }

    public Rectanglef setMax(float maxX, float maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
        return this;
    }

    public Rectanglef setMax(Vector2fc max) {
        this.maxX = max.x();
        this.maxY = max.y();
        return this;
    }

    public float lengthX() {
        return this.maxX - this.minX;
    }

    public float lengthY() {
        return this.maxY - this.minY;
    }

    public float area() {
        return this.lengthX() * this.lengthY();
    }

    public Rectanglef union(float x2, float y2) {
        return this.union(x2, y2, this);
    }

    public Rectanglef union(Vector2fc p2) {
        return this.union(p2.x(), p2.y(), this);
    }

    public Rectanglef union(float x2, float y2, Rectanglef dest) {
        dest.minX = this.minX < x2 ? this.minX : x2;
        dest.minY = this.minY < y2 ? this.minY : y2;
        dest.maxX = this.maxX > x2 ? this.maxX : x2;
        dest.maxY = this.maxY > y2 ? this.maxY : y2;
        return dest;
    }

    public Rectanglef union(Vector2ic p2, Rectanglef dest) {
        return this.union(p2.x(), p2.y(), dest);
    }

    public Rectanglef union(Rectanglef other) {
        return this.union(other, this);
    }

    public Rectanglef union(Rectanglef other, Rectanglef dest) {
        dest.minX = this.minX < other.minX ? this.minX : other.minX;
        dest.minY = this.minY < other.minY ? this.minY : other.minY;
        dest.maxX = this.maxX > other.maxX ? this.maxX : other.maxX;
        dest.maxY = this.maxY > other.maxY ? this.maxY : other.maxY;
        return dest;
    }

    public boolean intersectsRectangle(Rectangled other) {
        return (double)this.minX < other.maxX && (double)this.maxX > other.minX && (double)this.maxY > other.minY && (double)this.minY < other.maxY;
    }

    public boolean intersectsRectangle(Rectanglef other) {
        return this.minX < other.maxX && this.maxX > other.minX && this.maxY > other.minY && this.minY < other.maxY;
    }

    public boolean intersectsRectangle(Rectanglei other) {
        return this.minX < (float)other.maxX && this.maxX > (float)other.minX && this.maxY > (float)other.minY && this.minY < (float)other.maxY;
    }

    private Rectanglef validate() {
        if (!this.isValid()) {
            this.minX = Float.NaN;
            this.minY = Float.NaN;
            this.maxX = Float.NaN;
            this.maxY = Float.NaN;
        }
        return this;
    }

    public boolean isValid() {
        return this.minX < this.maxX && this.minY < this.maxY;
    }

    public Rectanglef intersection(Rectanglef other) {
        return this.intersection(other, this);
    }

    public Rectanglef intersection(Rectanglei other) {
        return this.intersection(other, this);
    }

    public Rectanglef intersection(Rectanglef other, Rectanglef dest) {
        dest.minX = Math.max(this.minX, other.minX);
        dest.minY = Math.max(this.minY, other.minY);
        dest.maxX = Math.min(this.maxX, other.maxX);
        dest.maxY = Math.min(this.maxY, other.maxY);
        return dest.validate();
    }

    public Rectanglef intersection(Rectanglei other, Rectanglef dest) {
        dest.minX = Math.max(this.minX, (float)other.minX);
        dest.minY = Math.max(this.minY, (float)other.minY);
        dest.maxX = Math.min(this.maxX, (float)other.maxX);
        dest.maxY = Math.min(this.maxY, (float)other.maxY);
        return dest.validate();
    }

    public Vector2f lengths(Vector2f dest) {
        return dest.set(this.lengthX(), this.lengthY());
    }

    public boolean containsRectangle(Rectangled rectangle) {
        return rectangle.minX >= (double)this.minX && rectangle.maxX <= (double)this.maxX && rectangle.minY >= (double)this.minY && rectangle.maxY <= (double)this.maxY;
    }

    public boolean containsRectangle(Rectanglef rectangle) {
        return rectangle.minX >= this.minX && rectangle.maxX <= this.maxX && rectangle.minY >= this.minY && rectangle.maxY <= this.maxY;
    }

    public boolean containsRectangle(Rectanglei rectangle) {
        return (float)rectangle.minX >= this.minX && (float)rectangle.maxX <= this.maxX && (float)rectangle.minY >= this.minY && (float)rectangle.maxY <= this.maxY;
    }

    public boolean containsPoint(Vector2fc point) {
        return this.containsPoint(point.x(), point.y());
    }

    public boolean containsPoint(float x2, float y2) {
        return x2 > this.minX && y2 > this.minY && x2 < this.maxX && y2 < this.maxY;
    }

    public Rectanglef translate(Vector2fc xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Rectanglef translate(Vector2fc xy2, Rectanglef dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Rectanglef translate(float x2, float y2) {
        return this.translate(x2, y2, this);
    }

    public Rectanglef translate(float x2, float y2, Rectanglef dest) {
        dest.minX = this.minX + x2;
        dest.minY = this.minY + y2;
        dest.maxX = this.maxX + x2;
        dest.maxY = this.maxY + y2;
        return dest;
    }

    public Rectanglef scale(float sf2) {
        return this.scale(sf2, sf2);
    }

    public Rectanglef scale(float sf2, Rectanglef dest) {
        return this.scale(sf2, sf2, dest);
    }

    public Rectanglef scale(float sf2, float ax2, float ay2) {
        return this.scale(sf2, sf2, ax2, ay2);
    }

    public Rectanglef scale(float sf2, float ax2, float ay2, Rectanglef dest) {
        return this.scale(sf2, sf2, ax2, ay2, dest);
    }

    public Rectanglef scale(float sf2, Vector2fc anchor) {
        return this.scale(sf2, anchor.x(), anchor.y());
    }

    public Rectanglef scale(float sf2, Vector2fc anchor, Rectanglef dest) {
        return this.scale(sf2, anchor.x(), anchor.y(), dest);
    }

    public Rectanglef scale(float sx2, float sy2) {
        return this.scale(sx2, sy2, 0.0f, 0.0f);
    }

    public Rectanglef scale(float sx2, float sy2, Rectanglef dest) {
        return this.scale(sx2, sy2, 0.0f, 0.0f, dest);
    }

    public Rectanglef scale(float sx2, float sy2, float ax2, float ay2) {
        this.minX = (this.minX - ax2) * sx2 + ax2;
        this.minY = (this.minY - ay2) * sy2 + ay2;
        this.maxX = (this.maxX - ax2) * sx2 + ax2;
        this.maxY = (this.maxY - ay2) * sy2 + ay2;
        return this;
    }

    public Rectanglef scale(float sx2, float sy2, Vector2fc anchor) {
        return this.scale(sx2, sy2, anchor.x(), anchor.y());
    }

    public Rectanglef scale(float sx2, float sy2, float ax2, float ay2, Rectanglef dest) {
        dest.minX = (this.minX - ax2) * sx2 + ax2;
        dest.minY = (this.minY - ay2) * sy2 + ay2;
        dest.maxX = (this.maxX - ax2) * sx2 + ax2;
        dest.maxY = (this.maxY - ay2) * sy2 + ay2;
        return dest;
    }

    public Rectanglef scale(float sx2, float sy2, Vector2fc anchor, Rectanglef dest) {
        return this.scale(sx2, sy2, anchor.x(), anchor.y(), dest);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Float.floatToIntBits(this.maxX);
        result2 = 31 * result2 + Float.floatToIntBits(this.maxY);
        result2 = 31 * result2 + Float.floatToIntBits(this.minX);
        result2 = 31 * result2 + Float.floatToIntBits(this.minY);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectanglef other = (Rectanglef)obj;
        if (Float.floatToIntBits(this.maxX) != Float.floatToIntBits(other.maxX)) {
            return false;
        }
        if (Float.floatToIntBits(this.maxY) != Float.floatToIntBits(other.maxY)) {
            return false;
        }
        if (Float.floatToIntBits(this.minX) != Float.floatToIntBits(other.minX)) {
            return false;
        }
        return Float.floatToIntBits(this.minY) == Float.floatToIntBits(other.minY);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + Runtime.format(this.minX, formatter) + " " + Runtime.format(this.minY, formatter) + ") < (" + Runtime.format(this.maxX, formatter) + " " + Runtime.format(this.maxY, formatter) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.minX);
        out.writeFloat(this.minY);
        out.writeFloat(this.maxX);
        out.writeFloat(this.maxY);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.minX = in2.readFloat();
        this.minY = in2.readFloat();
        this.maxX = in2.readFloat();
        this.maxY = in2.readFloat();
    }
}

