/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.primitives.Rectangled;
import org.joml.primitives.Rectanglef;

public class Rectanglei
implements Externalizable {
    public int minX;
    public int minY;
    public int maxX;
    public int maxY;

    public Rectanglei() {
    }

    public Rectanglei(Rectanglei source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
    }

    public Rectanglei(Vector2ic min, Vector2ic max) {
        this.minX = min.x();
        this.minY = min.y();
        this.maxX = max.x();
        this.maxY = max.y();
    }

    public Rectanglei(int minX, int minY, int maxX, int maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public Rectanglei set(Rectanglei source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
        return this;
    }

    public Rectanglei setMin(int minX, int minY) {
        this.minX = minX;
        this.minY = minY;
        return this;
    }

    public Rectanglei setMin(Vector2ic min) {
        this.minX = min.x();
        this.minY = min.y();
        return this;
    }

    public Rectanglei setMax(int maxX, int maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
        return this;
    }

    public Rectanglei setMax(Vector2ic max) {
        this.maxX = max.x();
        this.maxY = max.y();
        return this;
    }

    public int lengthX() {
        return this.maxX - this.minX;
    }

    public int lengthY() {
        return this.maxY - this.minY;
    }

    public int area() {
        return this.lengthX() * this.lengthY();
    }

    public Rectanglei union(int x2, int y2) {
        return this.union(x2, y2, this);
    }

    public Rectanglei union(Vector2ic p2) {
        return this.union(p2.x(), p2.y(), this);
    }

    public Rectanglei union(int x2, int y2, Rectanglei dest) {
        dest.minX = this.minX < x2 ? this.minX : x2;
        dest.minY = this.minY < y2 ? this.minY : y2;
        dest.maxX = this.maxX > x2 ? this.maxX : x2;
        dest.maxY = this.maxY > y2 ? this.maxY : y2;
        return dest;
    }

    public Rectanglei union(Vector2ic p2, Rectanglei dest) {
        return this.union(p2.x(), p2.y(), dest);
    }

    public Rectanglei union(Rectanglei other) {
        return this.union(other, this);
    }

    public Rectanglei union(Rectanglei other, Rectanglei dest) {
        dest.minX = this.minX < other.minX ? this.minX : other.minX;
        dest.minY = this.minY < other.minY ? this.minY : other.minY;
        dest.maxX = this.maxX > other.maxX ? this.maxX : other.maxX;
        dest.maxY = this.maxY > other.maxY ? this.maxY : other.maxY;
        return dest;
    }

    public boolean intersectsRectangle(Rectangled other) {
        return (double)this.minX <= other.maxX && (double)this.maxX >= other.minX && (double)this.maxY >= other.minY && (double)this.minY <= other.maxY;
    }

    public boolean intersectsRectangle(Rectanglef other) {
        return (float)this.minX <= other.maxX && (float)this.maxX >= other.minX && (float)this.maxY >= other.minY && (float)this.minY <= other.maxY;
    }

    public boolean intersectsRectangle(Rectanglei other) {
        return this.minX <= other.maxX && this.maxX >= other.minX && this.maxY >= other.minY && this.minY <= other.maxY;
    }

    private Rectanglei validate() {
        if (!this.isValid()) {
            this.minX = Integer.MAX_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.maxY = Integer.MIN_VALUE;
        }
        return this;
    }

    public boolean isValid() {
        return this.minX < this.maxX && this.minY < this.maxY;
    }

    public Rectanglei intersection(Rectanglei other) {
        return this.intersection(other, this);
    }

    public Rectanglei intersection(Rectanglei other, Rectanglei dest) {
        dest.minX = Math.max(this.minX, other.minX);
        dest.minY = Math.max(this.minY, other.minY);
        dest.maxX = Math.min(this.maxX, other.maxX);
        dest.maxY = Math.min(this.maxY, other.maxY);
        return dest.validate();
    }

    public Vector2i lengths(Vector2i dest) {
        return dest.set(this.lengthX(), this.lengthY());
    }

    public boolean containsRectangle(Rectangled rectangle) {
        return rectangle.minX >= (double)this.minX && rectangle.maxX <= (double)this.maxX && rectangle.minY >= (double)this.minY && rectangle.maxY <= (double)this.maxY;
    }

    public boolean containsRectangle(Rectanglef rectangle) {
        return rectangle.minX >= (float)this.minX && rectangle.maxX <= (float)this.maxX && rectangle.minY >= (float)this.minY && rectangle.maxY <= (float)this.maxY;
    }

    public boolean containsRectangle(Rectanglei rectangle) {
        return rectangle.minX >= this.minX && rectangle.maxX <= this.maxX && rectangle.minY >= this.minY && rectangle.maxY <= this.maxY;
    }

    public boolean containsPoint(Vector2ic point) {
        return this.containsPoint(point.x(), point.y());
    }

    public boolean containsPoint(float x2, float y2) {
        return x2 > (float)this.minX && y2 > (float)this.minY && x2 < (float)this.maxX && y2 < (float)this.maxY;
    }

    public boolean containsPoint(Vector2fc point) {
        return this.containsPoint(point.x(), point.y());
    }

    public boolean containsPoint(int x2, int y2) {
        return x2 > this.minX && y2 > this.minY && x2 < this.maxX && y2 < this.maxY;
    }

    public Rectanglei translate(Vector2ic xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Rectanglei translate(Vector2ic xy2, Rectanglei dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Rectanglei translate(int x2, int y2) {
        return this.translate(x2, y2, this);
    }

    public Rectanglei translate(int x2, int y2, Rectanglei dest) {
        dest.minX = this.minX + x2;
        dest.minY = this.minY + y2;
        dest.maxX = this.maxX + x2;
        dest.maxY = this.maxY + y2;
        return dest;
    }

    public Rectanglei scale(int sf2) {
        return this.scale(sf2, sf2);
    }

    public Rectanglei scale(int sf2, Rectanglei dest) {
        return this.scale(sf2, sf2, dest);
    }

    public Rectanglei scale(int sf2, int ax2, int ay2) {
        return this.scale(sf2, sf2, ax2, ay2);
    }

    public Rectanglei scale(int sf2, int ax2, int ay2, Rectanglei dest) {
        return this.scale(sf2, sf2, ax2, ay2, dest);
    }

    public Rectanglei scale(int sf2, Vector2ic anchor) {
        return this.scale(sf2, anchor.x(), anchor.y());
    }

    public Rectanglei scale(int sf2, Vector2ic anchor, Rectanglei dest) {
        return this.scale(sf2, anchor.x(), anchor.y(), dest);
    }

    public Rectanglei scale(int sx2, int sy2) {
        return this.scale(sx2, sy2, 0, 0);
    }

    public Rectanglei scale(int sx2, int sy2, Rectanglei dest) {
        return this.scale(sx2, sy2, 0, 0, dest);
    }

    public Rectanglei scale(int sx2, int sy2, int ax2, int ay2) {
        this.minX = (this.minX - ax2) * sx2 + ax2;
        this.minY = (this.minY - ay2) * sy2 + ay2;
        this.maxX = (this.maxX - ax2) * sx2 + ax2;
        this.maxY = (this.maxY - ay2) * sy2 + ay2;
        return this;
    }

    public Rectanglei scale(int sx2, int sy2, Vector2ic anchor) {
        return this.scale(sx2, sy2, anchor.x(), anchor.y());
    }

    public Rectanglei scale(int sx2, int sy2, int ax2, int ay2, Rectanglei dest) {
        dest.minX = (this.minX - ax2) * sx2 + ax2;
        dest.minY = (this.minY - ay2) * sy2 + ay2;
        dest.maxX = (this.maxX - ax2) * sx2 + ax2;
        dest.maxY = (this.maxY - ay2) * sy2 + ay2;
        return dest;
    }

    public Rectanglei scale(int sx2, int sy2, Vector2ic anchor, Rectanglei dest) {
        return this.scale(sx2, sy2, anchor.x(), anchor.y(), dest);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.maxX;
        result2 = 31 * result2 + this.maxY;
        result2 = 31 * result2 + this.minX;
        result2 = 31 * result2 + this.minY;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectanglei other = (Rectanglei)obj;
        if (this.maxX != other.maxX) {
            return false;
        }
        if (this.maxY != other.maxY) {
            return false;
        }
        if (this.minX != other.minX) {
            return false;
        }
        return this.minY == other.minY;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.minX) + " " + formatter.format(this.minY) + ") < (" + formatter.format(this.maxX) + " " + formatter.format(this.maxY) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.minX);
        out.writeInt(this.minY);
        out.writeInt(this.maxX);
        out.writeInt(this.maxY);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.minX = in2.readInt();
        this.minY = in2.readInt();
        this.maxX = in2.readInt();
        this.maxY = in2.readInt();
    }
}

