/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.util.functions.IntTernaryConsumer;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.core.impl.datastructures.FastMinMaxMap;
import org.valkyrienskies.core.impl.datastructures.IBlockPosSetAABB;
import org.valkyrienskies.core.impl.datastructures.SmallBlockPosSet;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.core.util.datastructures.IBlockPosSet;

@JsonDeserialize(using=SmallBlockPosSetAABBDeserializer.class)
@JsonSerialize(using=SmallBlockPosSetAABBSerializer.class)
public class BlockPosSetAABBGenerator
implements IBlockPosSetAABB {
    private final IBlockPosSet blockPosSet;
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private final FastMinMaxMap xMap;
    private final FastMinMaxMap yMap;
    private final FastMinMaxMap zMap;

    public BlockPosSetAABBGenerator(ChunkClaim chunkClaim, LevelYRange yRange) {
        this(chunkClaim, yRange, new DenseBlockPosSet());
    }

    public BlockPosSetAABBGenerator(ChunkClaim chunkClaim, LevelYRange yRange, IBlockPosSet backingSet) {
        Vector3i vector3i = chunkClaim.getCenterBlockCoordinates(yRange, new Vector3i());
        Vector3i vector3i2 = chunkClaim.getBlockSize(yRange, new Vector3i());
        this.blockPosSet = backingSet;
        this.centerX = vector3i.x();
        this.centerY = vector3i.y();
        this.centerZ = vector3i.z();
        this.xSize = vector3i2.x();
        this.ySize = vector3i2.y();
        this.zSize = vector3i2.z();
        this.xMap = new FastMinMaxMap(this.xSize);
        this.yMap = new FastMinMaxMap(this.ySize);
        this.zMap = new FastMinMaxMap(this.zSize);
    }

    public BlockPosSetAABBGenerator(int centerX, int centerY, int centerZ, int xSize, int ySize, int zSize) {
        this(new DenseBlockPosSet(), centerX, centerY, centerZ, xSize, ySize, zSize);
    }

    private BlockPosSetAABBGenerator(IBlockPosSet blockPosSet, int centerX, int centerY, int centerZ, int xSize, int ySize, int zSize) {
        this.blockPosSet = blockPosSet;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.xMap = new FastMinMaxMap(xSize);
        this.yMap = new FastMinMaxMap(ySize);
        this.zMap = new FastMinMaxMap(zSize);
    }

    @Override
    @Nullable
    public AABBi makeAABB() {
        if (this.blockPosSet.isEmpty()) {
            return null;
        }
        int n2 = this.xMap.getFront() - this.xSize / 2;
        int n3 = this.xMap.getBack() - this.xSize / 2;
        int n4 = this.yMap.getFront() - this.ySize / 2;
        int n5 = this.yMap.getBack() - this.ySize / 2;
        int n6 = this.zMap.getFront() - this.zSize / 2;
        int n7 = this.zMap.getBack() - this.zSize / 2;
        return new AABBi(n2 += this.centerX, n4 += this.centerY, n6 += this.centerZ, n3 += this.centerX, n5 += this.centerY, n7 += this.centerZ);
    }

    @Override
    public boolean add(int x2, int y2, int z2) {
        boolean bl2 = this.blockPosSet.add(x2, y2, z2);
        if (bl2) {
            this.incrementAABBMaker(x2, y2, z2);
        }
        return bl2;
    }

    private void incrementAABBMaker(int x2, int y2, int z2) {
        this.xMap.increment(x2 - this.centerX + this.xSize / 2);
        this.yMap.increment(y2 - this.centerY + this.ySize / 2);
        this.zMap.increment(z2 - this.centerZ + this.zSize / 2);
    }

    @Override
    public boolean remove(int x2, int y2, int z2) {
        boolean bl2 = this.blockPosSet.remove(x2, y2, z2);
        if (bl2) {
            this.decrementAABBMaker(x2, y2, z2);
        }
        return bl2;
    }

    private void decrementAABBMaker(int x2, int y2, int z2) {
        this.xMap.decrement(x2 - this.centerX + this.xSize / 2);
        this.yMap.decrement(y2 - this.centerY + this.ySize / 2);
        this.zMap.decrement(z2 - this.centerZ + this.zSize / 2);
    }

    @Override
    public boolean contains(int x2, int y2, int z2) {
        return this.blockPosSet.contains(x2, y2, z2);
    }

    @Override
    public boolean canStore(int x2, int y2, int z2) {
        return this.blockPosSet.canStore(x2, y2, z2);
    }

    @Override
    public int size() {
        return this.blockPosSet.size();
    }

    @Override
    @Nonnull
    public Iterator<Vector3ic> iterator() {
        return this.blockPosSet.iterator();
    }

    @Override
    public void clear() {
        this.blockPosSet.clear();
        this.xMap.clear();
        this.yMap.clear();
        this.zMap.clear();
    }

    @Override
    public void forEach(@Nonnull IntTernaryConsumer action) {
        this.blockPosSet.forEach(action);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IBlockPosSetAABB) {
            return ((IBlockPosSetAABB)other).size() == this.size() && ((IBlockPosSetAABB)other).containsAll(this);
        }
        return false;
    }

    public static class SmallBlockPosSetAABBDeserializer
    extends StdDeserializer<BlockPosSetAABBGenerator> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        public SmallBlockPosSetAABBDeserializer() {
            super((Class)null);
        }

        @Override
        public BlockPosSetAABBGenerator deserialize(JsonParser p2, DeserializationContext ctxt) {
            JsonNode jsonNode = (JsonNode)p2.getCodec().readTree(p2);
            SmallBlockPosSet smallBlockPosSet = this.objectMapper.treeToValue((TreeNode)jsonNode.get("blockPosSet"), SmallBlockPosSet.class);
            int n2 = jsonNode.get("centerX").asInt();
            int n3 = jsonNode.get("centerY").asInt();
            int n4 = jsonNode.get("centerZ").asInt();
            int n5 = jsonNode.get("xSize").asInt();
            int n6 = jsonNode.get("ySize").asInt();
            int n7 = jsonNode.get("zSize").asInt();
            BlockPosSetAABBGenerator blockPosSetAABBGenerator = new BlockPosSetAABBGenerator(smallBlockPosSet, n2, n3, n4, n5, n6, n7);
            smallBlockPosSet.forEach((x$0, x$1, x$2) -> blockPosSetAABBGenerator.incrementAABBMaker(x$0, x$1, x$2));
            return blockPosSetAABBGenerator;
        }
    }

    public static class SmallBlockPosSetAABBSerializer
    extends StdSerializer<BlockPosSetAABBGenerator> {
        public SmallBlockPosSetAABBSerializer() {
            super((Class)null);
        }

        @Override
        public void serialize(BlockPosSetAABBGenerator value, JsonGenerator gen, SerializerProvider provider) {
            gen.writeStartObject();
            gen.writeObjectField("blockPosSet", value.blockPosSet);
            gen.writeNumberField("centerX", value.centerX);
            gen.writeNumberField("centerY", value.centerY);
            gen.writeNumberField("centerZ", value.centerZ);
            gen.writeNumberField("xSize", value.xSize);
            gen.writeNumberField("ySize", value.ySize);
            gen.writeNumberField("zSize", value.zSize);
            gen.writeEndObject();
        }
    }
}

