/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.joml.Matrix4dc;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.game.ships.ShipPhysicsData;
import org.valkyrienskies.core.impl.shadow.zF;
import org.valkyrienskies.core.impl.util.serialization.DeltaIgnore;
import org.valkyrienskies.core.impl.util.serialization.PacketIgnore;
import org.valkyrienskies.core.util.AABBdUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001Bg\u0012\n\u0010-\u001a\u00060+j\u0002`,\u0012\b\u0010K\u001a\u0004\u0018\u00010#\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\n\u0010%\u001a\u00060#j\u0002`$\u0012\u0006\u00106\u001a\u000205\u0012\u0006\u0010N\u001a\u00020:\u0012\b\b\u0002\u0010[\u001a\u00020:\u0012\b\b\u0002\u0010U\u001a\u00020T\u0012\b\u0010A\u001a\u0004\u0018\u00010@\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\\\u0010]J\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJO\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\u001e8\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R&\u0010%\u001a\u00060#j\u0002`$8\u0017@\u0017X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010-\u001a\u00060+j\u0002`,8\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0014\u00104\u001a\u0002018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u00106\u001a\u0002058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R$\u0010<\u001a\u00020:2\u0006\u0010;\u001a\u00020:8\u0007@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R$\u0010A\u001a\u0004\u0018\u00010@8\u0017@\u0017X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0014\u0010J\u001a\u00020G8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR$\u0010K\u001a\u0004\u0018\u00010#8\u0017@\u0017X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010&\u001a\u0004\bL\u0010(\"\u0004\bM\u0010*R*\u0010N\u001a\u00020:2\u0006\u0010N\u001a\u00020:8\u0017@WX\u0097\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010=\u001a\u0004\bO\u0010?\"\u0004\bP\u0010QR\u0014\u0010S\u001a\u0002018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u00103R$\u0010U\u001a\u00020T2\u0006\u0010;\u001a\u00020T8\u0007@BX\u0087\u000e\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR\u0014\u0010Z\u001a\u00020G8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010I"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "Lorg/valkyrienskies/core/impl/shadow/zF;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "updatePrevTickShipTransform", "()V", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "activeChunksSet", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "getActiveChunksSet", "()Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "getChunkClaim", "()Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "chunkClaimDimension", "Ljava/lang/String;", "getChunkClaimDimension", "()Ljava/lang/String;", "setChunkClaimDimension", "(Ljava/lang/String;)V", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "id", "J", "getId", "()J", "Lorg/joml/Vector3dc;", "getOmega", "()Lorg/joml/Vector3dc;", "omega", "Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "physicsData", "Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "getPhysicsData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "p0", "prevTickTransform", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getPrevTickTransform", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/primitives/AABBic;", "shipAABB", "Lorg/joml/primitives/AABBic;", "getShipAABB", "()Lorg/joml/primitives/AABBic;", "setShipAABB", "(Lorg/joml/primitives/AABBic;)V", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "slug", "getSlug", "setSlug", "transform", "getTransform", "setTransform", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;)V", "getVelocity", "velocity", "Lorg/joml/primitives/AABBdc;", "worldAABB", "Lorg/joml/primitives/AABBdc;", "getWorldAABB", "()Lorg/joml/primitives/AABBdc;", "getWorldToShip", "worldToShip", "prevTickShipTransform", "<init>", "(JLjava/lang/String;Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/String;Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/joml/primitives/AABBdc;Lorg/joml/primitives/AABBic;Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;)V"})
public class ShipDataCommon
implements zF {
    private final long id;
    private String slug;
    private final ChunkClaim chunkClaim;
    private String chunkClaimDimension;
    @DeltaIgnore
    private final ShipPhysicsData physicsData;
    private AABBic shipAABB;
    private final IShipActiveChunksSet activeChunksSet;
    @DeltaIgnore
    private ShipTransform transform;
    @PacketIgnore
    private ShipTransform prevTickTransform;
    @DeltaIgnore
    private AABBdc worldAABB;

    public ShipDataCommon(long id2, String slug, ChunkClaim chunkClaim, String chunkClaimDimension, ShipPhysicsData physicsData, ShipTransform transform2, ShipTransform prevTickShipTransform, AABBdc worldAABB, AABBic shipAABB, IShipActiveChunksSet activeChunksSet) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"");
        Intrinsics.checkNotNullParameter((Object)chunkClaimDimension, (String)"");
        Intrinsics.checkNotNullParameter((Object)physicsData, (String)"");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"");
        Intrinsics.checkNotNullParameter((Object)prevTickShipTransform, (String)"");
        Intrinsics.checkNotNullParameter((Object)worldAABB, (String)"");
        Intrinsics.checkNotNullParameter((Object)activeChunksSet, (String)"");
        this.id = id2;
        this.slug = slug;
        this.chunkClaim = chunkClaim;
        this.chunkClaimDimension = chunkClaimDimension;
        this.physicsData = physicsData;
        this.shipAABB = shipAABB;
        this.activeChunksSet = activeChunksSet;
        this.transform = transform2;
        this.prevTickTransform = prevTickShipTransform;
        this.worldAABB = worldAABB;
    }

    public /* synthetic */ ShipDataCommon(long l2, String string, ChunkClaim chunkClaim, String string2, ShipPhysicsData shipPhysicsData, ShipTransform shipTransform, ShipTransform shipTransform2, AABBdc aABBdc, AABBic aABBic, IShipActiveChunksSet iShipActiveChunksSet, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            shipTransform2 = shipTransform;
        }
        if ((n2 & 0x80) != 0) {
            aABBdc = shipTransform.createEmptyAABB();
        }
        this(l2, string, chunkClaim, string2, shipPhysicsData, shipTransform, shipTransform2, aABBdc, aABBic, iShipActiveChunksSet);
    }

    @Override
    @JvmName(name="getId")
    public long getId() {
        return this.id;
    }

    @Override
    @JvmName(name="getSlug")
    public String getSlug() {
        return this.slug;
    }

    @JvmName(name="setSlug")
    public void setSlug(String string) {
        this.slug = string;
    }

    @Override
    @JvmName(name="getChunkClaim")
    public ChunkClaim getChunkClaim() {
        return this.chunkClaim;
    }

    @Override
    @JvmName(name="getChunkClaimDimension")
    public String getChunkClaimDimension() {
        return this.chunkClaimDimension;
    }

    @Override
    @JvmName(name="setChunkClaimDimension")
    public void setChunkClaimDimension(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.chunkClaimDimension = string;
    }

    @JvmName(name="getPhysicsData")
    public final ShipPhysicsData getPhysicsData() {
        return this.physicsData;
    }

    @Override
    @JvmName(name="getShipAABB")
    public AABBic getShipAABB() {
        return this.shipAABB;
    }

    @JvmName(name="setShipAABB")
    public void setShipAABB(AABBic aABBic) {
        this.shipAABB = aABBic;
    }

    @Override
    @JvmName(name="getActiveChunksSet")
    public IShipActiveChunksSet getActiveChunksSet() {
        return this.activeChunksSet;
    }

    @Override
    @JvmName(name="getVelocity")
    public Vector3dc getVelocity() {
        return this.physicsData.getLinearVelocity();
    }

    @Override
    @JvmName(name="getOmega")
    public Vector3dc getOmega() {
        return this.physicsData.getAngularVelocity();
    }

    @Override
    @JvmName(name="getTransform")
    public ShipTransform getTransform() {
        return this.transform;
    }

    @JvmName(name="setTransform")
    public void setTransform(ShipTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"");
        this.transform = transform2;
        Object object = this.getShipAABB();
        AABBd aABBd = object != null && (object = AABBdUtilKt.toAABBd((AABBic)object, new AABBd())) != null ? ((AABBd)object).transform(transform2.getShipToWorld(), new AABBd()) : null;
        this.worldAABB = aABBd == null ? transform2.createEmptyAABB() : (AABBdc)aABBd;
    }

    @Override
    @JvmName(name="getPrevTickTransform")
    public final ShipTransform getPrevTickTransform() {
        return this.prevTickTransform;
    }

    @Override
    @JvmName(name="getWorldAABB")
    public final AABBdc getWorldAABB() {
        return this.worldAABB;
    }

    public final void updatePrevTickShipTransform() {
        this.prevTickTransform = this.getTransform();
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, BlockType oldBlockType, BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"");
        if (!this.getChunkClaim().contains(posX >> 4, posZ >> 4)) {
            boolean bl2 = false;
            String string = "Block at <" + posX + ", " + posY + ", " + posZ + "> is not in the chunk claim belonging to " + this;
            throw new IllegalArgumentException(string.toString());
        }
        this.getActiveChunksSet().add(posX >> 4, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) - 1, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) + 1, posZ >> 4);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) - 1);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) + 1);
    }

    @Override
    @JvmName(name="getShipToWorld")
    public Matrix4dc getShipToWorld() {
        return this.getTransform().getShipToWorld();
    }

    @Override
    @JvmName(name="getWorldToShip")
    public Matrix4dc getWorldToShip() {
        return this.getTransform().getWorldToShip();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other);
        ShipDataCommon cfr_ignored_0 = (ShipDataCommon)other;
        return this.getId() == ((ShipDataCommon)other).getId();
    }

    public int hashCode() {
        return Long.hashCode(this.getId());
    }
}

