/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B'\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b2\u00103J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0004J8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010!\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010$\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b$\u0010\"R\u001a\u0010\u000b\u001a\u00020\u00028\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010%\u001a\u0004\b&\u0010\u0004R\u001a\u0010\n\u001a\u00020\u00028\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b'\u0010\u0004R\u001a\u0010)\u001a\u00020(8\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010\f\u001a\u00020\u00068\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010-\u001a\u0004\b.\u0010\bR\u001a\u0010\r\u001a\u00020\u00028\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010%\u001a\u0004\b/\u0010\u0004R\u001a\u00100\u001a\u00020(8\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b0\u0010*\u001a\u0004\b1\u0010,"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipTransformImpl;", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/Vector3dc;", "component1", "()Lorg/joml/Vector3dc;", "component2", "Lorg/joml/Quaterniondc;", "component3", "()Lorg/joml/Quaterniondc;", "component4", "positionInWorld", "positionInShip", "shipToWorldRotation", "shipToWorldScaling", "copy", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/core/impl/game/ships/ShipTransformImpl;", "Lorg/joml/primitives/AABBdc;", "createEmptyAABB", "()Lorg/joml/primitives/AABBdc;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "directionInShip", "Lorg/joml/Vector3d;", "dest", "transformDirectionNoScalingFromShipToWorld", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "directionInWorld", "transformDirectionNoScalingFromWorldToShip", "Lorg/joml/Vector3dc;", "getPositionInShip", "getPositionInWorld", "Lorg/joml/Matrix4dc;", "shipToWorld", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "Lorg/joml/Quaterniondc;", "getShipToWorldRotation", "getShipToWorldScaling", "worldToShip", "getWorldToShip", "<init>", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;)V", "Companion"})
public final class ShipTransformImpl
implements ShipTransform {
    public static final Companion Companion = new Companion(null);
    private final Vector3dc positionInWorld;
    private final Vector3dc positionInShip;
    private final Quaterniondc shipToWorldRotation;
    private final Vector3dc shipToWorldScaling;
    private final Matrix4dc shipToWorld;
    private final Matrix4dc worldToShip;
    private static final Quaterniondc ZERO_ROTATION = new Quaterniond();
    private static final Vector3dc UNIT_SCALING = new Vector3d(1.0, 1.0, 1.0);
    private static final Vector3dc ZERO = new Vector3d();

    public ShipTransformImpl(Vector3dc positionInWorld, Vector3dc positionInShip, Quaterniondc shipToWorldRotation, Vector3dc shipToWorldScaling) {
        Intrinsics.checkNotNullParameter((Object)positionInWorld, (String)"");
        Intrinsics.checkNotNullParameter((Object)positionInShip, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipToWorldRotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipToWorldScaling, (String)"");
        this.positionInWorld = positionInWorld;
        this.positionInShip = positionInShip;
        this.shipToWorldRotation = shipToWorldRotation;
        this.shipToWorldScaling = shipToWorldScaling;
        Matrix4d matrix4d = new Matrix4d().translate(this.getPositionInWorld()).rotate(this.getShipToWorldRotation()).scale(this.getShipToWorldScaling()).translate(-this.getPositionInShip().x(), -this.getPositionInShip().y(), -this.getPositionInShip().z());
        Intrinsics.checkNotNullExpressionValue((Object)matrix4d, (String)"");
        this.shipToWorld = matrix4d;
        Matrix4d matrix4d2 = this.getShipToWorld().invert(new Matrix4d());
        Intrinsics.checkNotNullExpressionValue((Object)matrix4d2, (String)"");
        this.worldToShip = matrix4d2;
    }

    @Override
    @JvmName(name="getPositionInWorld")
    public Vector3dc getPositionInWorld() {
        return this.positionInWorld;
    }

    @Override
    @JvmName(name="getPositionInShip")
    public Vector3dc getPositionInShip() {
        return this.positionInShip;
    }

    @Override
    @JvmName(name="getShipToWorldRotation")
    public Quaterniondc getShipToWorldRotation() {
        return this.shipToWorldRotation;
    }

    @Override
    @JvmName(name="getShipToWorldScaling")
    public Vector3dc getShipToWorldScaling() {
        return this.shipToWorldScaling;
    }

    @Override
    @JvmName(name="getShipToWorld")
    public Matrix4dc getShipToWorld() {
        return this.shipToWorld;
    }

    @Override
    @JvmName(name="getWorldToShip")
    public Matrix4dc getWorldToShip() {
        return this.worldToShip;
    }

    @Override
    public Vector3d transformDirectionNoScalingFromShipToWorld(Vector3dc directionInShip, Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)directionInShip, (String)"");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"");
        Vector3d vector3d = this.getShipToWorldRotation().transform(directionInShip, dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"");
        return vector3d;
    }

    @Override
    public Vector3d transformDirectionNoScalingFromWorldToShip(Vector3dc directionInWorld, Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)directionInWorld, (String)"");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"");
        Vector3d vector3d = this.getShipToWorldRotation().transformInverse(directionInWorld, dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"");
        return vector3d;
    }

    @Override
    public AABBdc createEmptyAABB() {
        return new AABBd(this.getPositionInWorld(), this.getPositionInWorld());
    }

    public final Vector3dc component1() {
        return this.positionInWorld;
    }

    public final Vector3dc component2() {
        return this.positionInShip;
    }

    public final Quaterniondc component3() {
        return this.shipToWorldRotation;
    }

    public final Vector3dc component4() {
        return this.shipToWorldScaling;
    }

    public final ShipTransformImpl copy(Vector3dc positionInWorld, Vector3dc positionInShip, Quaterniondc shipToWorldRotation, Vector3dc shipToWorldScaling) {
        Intrinsics.checkNotNullParameter((Object)positionInWorld, (String)"");
        Intrinsics.checkNotNullParameter((Object)positionInShip, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipToWorldRotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipToWorldScaling, (String)"");
        return new ShipTransformImpl(positionInWorld, positionInShip, shipToWorldRotation, shipToWorldScaling);
    }

    public static /* synthetic */ ShipTransformImpl copy$default(ShipTransformImpl shipTransformImpl, Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniondc quaterniondc, Vector3dc vector3dc3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector3dc = shipTransformImpl.positionInWorld;
        }
        if ((n2 & 2) != 0) {
            vector3dc2 = shipTransformImpl.positionInShip;
        }
        if ((n2 & 4) != 0) {
            quaterniondc = shipTransformImpl.shipToWorldRotation;
        }
        if ((n2 & 8) != 0) {
            vector3dc3 = shipTransformImpl.shipToWorldScaling;
        }
        return shipTransformImpl.copy(vector3dc, vector3dc2, quaterniondc, vector3dc3);
    }

    public String toString() {
        return "ShipTransformImpl(positionInWorld=" + this.positionInWorld + ", positionInShip=" + this.positionInShip + ", shipToWorldRotation=" + this.shipToWorldRotation + ", shipToWorldScaling=" + this.shipToWorldScaling + ')';
    }

    public int hashCode() {
        int n2 = this.positionInWorld.hashCode();
        n2 = n2 * 31 + this.positionInShip.hashCode();
        n2 = n2 * 31 + this.shipToWorldRotation.hashCode();
        n2 = n2 * 31 + this.shipToWorldScaling.hashCode();
        return n2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShipTransformImpl)) {
            return false;
        }
        ShipTransformImpl shipTransformImpl = (ShipTransformImpl)other;
        if (!Intrinsics.areEqual((Object)this.positionInWorld, (Object)shipTransformImpl.positionInWorld)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.positionInShip, (Object)shipTransformImpl.positionInShip)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shipToWorldRotation, (Object)shipTransformImpl.shipToWorldRotation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.shipToWorldScaling, (Object)shipTransformImpl.shipToWorldScaling);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ-\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\fJ\r\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\u00028\u0007\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\u00020\u00028\u0007\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u001b\u001a\u00020\b8\u0007\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipTransformImpl$Companion;", "", "Lorg/joml/Vector3dc;", "centerCoordinateInWorld", "centerCoordinateInShip", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "create", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/Quaterniondc;", "shipRotation", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipScaling", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "createEmpty", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "prevTransform", "curTransform", "", "alpha", "createFromSlerp", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;D)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "UNIT_SCALING", "Lorg/joml/Vector3dc;", "getUNIT_SCALING", "()Lorg/joml/Vector3dc;", "ZERO", "getZERO", "ZERO_ROTATION", "Lorg/joml/Quaterniondc;", "getZERO_ROTATION", "()Lorg/joml/Quaterniondc;", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="getZERO_ROTATION")
        public final Quaterniondc getZERO_ROTATION() {
            return ZERO_ROTATION;
        }

        @JvmName(name="getUNIT_SCALING")
        public final Vector3dc getUNIT_SCALING() {
            return UNIT_SCALING;
        }

        @JvmName(name="getZERO")
        public final Vector3dc getZERO() {
            return ZERO;
        }

        public final ShipTransform createEmpty() {
            return this.create(this.getZERO(), this.getZERO());
        }

        public final ShipTransform create(Vector3dc centerCoordinateInWorld, Vector3dc centerCoordinateInShip) {
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInWorld, (String)"");
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInShip, (String)"");
            return this.create(centerCoordinateInWorld, centerCoordinateInShip, this.getZERO_ROTATION());
        }

        public final ShipTransform create(Vector3dc centerCoordinateInWorld, Vector3dc centerCoordinateInShip, Quaterniondc shipRotation) {
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInWorld, (String)"");
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInShip, (String)"");
            Intrinsics.checkNotNullParameter((Object)shipRotation, (String)"");
            return new ShipTransformImpl(centerCoordinateInWorld, centerCoordinateInShip, shipRotation, this.getUNIT_SCALING());
        }

        public final ShipTransform create(Vector3dc centerCoordinateInWorld, Vector3dc centerCoordinateInShip, Quaterniondc shipRotation, Vector3dc shipScaling) {
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInWorld, (String)"");
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInShip, (String)"");
            Intrinsics.checkNotNullParameter((Object)shipRotation, (String)"");
            Intrinsics.checkNotNullParameter((Object)shipScaling, (String)"");
            return new ShipTransformImpl(centerCoordinateInWorld, centerCoordinateInShip, shipRotation, shipScaling);
        }

        public final ShipTransform createFromSlerp(ShipTransform prevTransform, ShipTransform curTransform, double alpha) {
            Intrinsics.checkNotNullParameter((Object)prevTransform, (String)"");
            Intrinsics.checkNotNullParameter((Object)curTransform, (String)"");
            Vector3dc vector3dc = curTransform.getPositionInShip();
            Vector3d vector3d = curTransform.getPositionInShip().sub(prevTransform.getPositionInShip(), new Vector3d());
            Vector3d vector3d2 = prevTransform.getShipToWorld().transformDirection(vector3d, new Vector3d()).add(prevTransform.getPositionInWorld());
            Vector3d vector3d3 = vector3d2.lerp(curTransform.getPositionInWorld(), alpha, new Vector3d());
            Quaterniond quaterniond = prevTransform.getShipToWorldRotation().slerp(curTransform.getShipToWorldRotation(), alpha, new Quaterniond()).normalize();
            Vector3d vector3d4 = prevTransform.getShipToWorldScaling().lerp(curTransform.getShipToWorldScaling(), alpha, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"");
            Vector3dc vector3dc2 = vector3d3;
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"");
            Quaterniondc quaterniondc = quaterniond;
            Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"");
            return this.create(vector3dc2, vector3dc, quaterniondc, vector3d4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

