/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking.delta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.core.impl.networking.delta.DeltaAlgorithm;
import org.valkyrienskies.core.impl.shadow.Q;
import org.valkyrienskies.core.impl.shadow.R;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e"}, d2={"Lorg/valkyrienskies/core/impl/networking/delta/JsonDiffDeltaAlgorithm;", "Lorg/valkyrienskies/core/impl/networking/delta/DeltaAlgorithm;", "Lcom/fasterxml/jackson/databind/JsonNode;", "old", "Lio/netty/buffer/ByteBuf;", "delta", "apply", "(Lcom/fasterxml/jackson/databind/JsonNode;Lio/netty/buffer/ByteBuf;)Lcom/fasterxml/jackson/databind/JsonNode;", "new", "dest", "encode", "(Lcom/fasterxml/jackson/databind/JsonNode;Lcom/fasterxml/jackson/databind/JsonNode;Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V"})
public final class JsonDiffDeltaAlgorithm
implements DeltaAlgorithm<JsonNode> {
    private final ObjectMapper mapper;

    public JsonDiffDeltaAlgorithm(ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"");
        this.mapper = mapper;
    }

    @Override
    public ByteBuf encode(JsonNode old, JsonNode jsonNode, ByteBuf dest) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"");
        JsonNode jsonNode2 = Q.a(old, jsonNode);
        byte[] byArray = this.mapper.writeValueAsBytes(jsonNode2);
        dest.writeInt(byArray.length);
        dest.writeBytes(byArray);
        return dest;
    }

    @Override
    public JsonNode apply(JsonNode old, ByteBuf delta) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"");
        int n2 = delta.readInt();
        JsonNode jsonNode = this.mapper.readTree((InputStream)new ByteBufInputStream(delta, n2));
        JsonNode jsonNode2 = R.a(jsonNode, old);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"");
        return jsonNode2;
    }
}

