/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B'\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b.\u0010/J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0004J\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0004J8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001aJ\u001d\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\"\u0010\u001aJ\u001d\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\u0004\b\"\u0010\u001cJ\u0015\u0010#\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\u0004\b#\u0010\u001aJ\u001d\u0010#\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\u0004\b#\u0010\u001cR\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010'\u001a\u0004\b(\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010'\u001a\u0004\b)\u0010\u0004R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010*\u001a\u0004\b+\u0010\u0007R\u0014\u0010,\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010&R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010'\u001a\u0004\b-\u0010\u0004\u00a8\u00061"}, d2={"Lorg/valkyrienskies/physics_api/PoseVel;", "", "Lorg/joml/Vector3dc;", "component1", "()Lorg/joml/Vector3dc;", "Lorg/joml/Quaterniondc;", "component2", "()Lorg/joml/Quaterniondc;", "component3", "component4", "pos", "rot", "vel", "omega", "copy", "(Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/physics_api/PoseVel;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/joml/Vector3d;", "direction", "invTransformDirection", "(Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "dest", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "position", "invTransformPosition", "", "toString", "()Ljava/lang/String;", "transformDirection", "transformPosition", "Lorg/joml/Matrix4dc;", "invTransformMatrix", "Lorg/joml/Matrix4dc;", "Lorg/joml/Vector3dc;", "getOmega", "getPos", "Lorg/joml/Quaterniondc;", "getRot", "transformMatrix", "getVel", "<init>", "(Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)V", "Companion", "physics_api"})
public final class PoseVel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3dc pos;
    @NotNull
    private final Quaterniondc rot;
    @NotNull
    private final Vector3dc vel;
    @NotNull
    private final Vector3dc omega;
    @NotNull
    private final Matrix4dc transformMatrix;
    @NotNull
    private final Matrix4dc invTransformMatrix;
    @NotNull
    private static final PoseVel NULL_POSE_VEL = new PoseVel(new Vector3d(), new Quaterniond(), new Vector3d(), new Vector3d());

    public PoseVel(@NotNull Vector3dc pos, @NotNull Quaterniondc rot, @NotNull Vector3dc vel, @NotNull Vector3dc omega) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)omega, (String)"omega");
        this.pos = pos;
        this.rot = rot;
        this.vel = vel;
        this.omega = omega;
        Matrix4d matrix4d = new Matrix4d().translate(this.pos).rotate(this.rot);
        Intrinsics.checkNotNullExpressionValue((Object)matrix4d, (String)"Matrix4d().translate(pos).rotate(rot)");
        this.transformMatrix = matrix4d;
        matrix4d = new Matrix4d().rotate(this.rot.conjugate(new Quaterniond())).translate(-this.pos.x(), -this.pos.y(), -this.pos.z());
        Intrinsics.checkNotNullExpressionValue((Object)matrix4d, (String)"Matrix4d().rotate(rot.co\u2026.x(), -pos.y(), -pos.z())");
        this.invTransformMatrix = matrix4d;
    }

    @NotNull
    public final Vector3dc getPos() {
        return this.pos;
    }

    @NotNull
    public final Quaterniondc getRot() {
        return this.rot;
    }

    @NotNull
    public final Vector3dc getVel() {
        return this.vel;
    }

    @NotNull
    public final Vector3dc getOmega() {
        return this.omega;
    }

    @NotNull
    public final Vector3d transformPosition(@NotNull Vector3dc position, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.set(position);
        if (this == NULL_POSE_VEL) {
            return dest;
        }
        Vector3d vector3d = this.transformMatrix.transformPosition(dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformMatrix.transformPosition(dest)");
        return vector3d;
    }

    @NotNull
    public final Vector3d invTransformPosition(@NotNull Vector3dc position, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.set(position);
        if (this == NULL_POSE_VEL) {
            return dest;
        }
        Vector3d vector3d = this.invTransformMatrix.transformPosition(dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"invTransformMatrix.transformPosition(dest)");
        return vector3d;
    }

    @NotNull
    public final Vector3d transformDirection(@NotNull Vector3dc direction, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.set(direction);
        if (this == NULL_POSE_VEL) {
            return dest;
        }
        Vector3d vector3d = this.transformMatrix.transformDirection(dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformMatrix.transformDirection(dest)");
        return vector3d;
    }

    @NotNull
    public final Vector3d invTransformDirection(@NotNull Vector3dc direction, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.set(direction);
        if (this == NULL_POSE_VEL) {
            return dest;
        }
        Vector3d vector3d = this.invTransformMatrix.transformDirection(dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"invTransformMatrix.transformDirection(dest)");
        return vector3d;
    }

    @NotNull
    public final Vector3d transformPosition(@NotNull Vector3d position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.transformPosition(position, position);
    }

    @NotNull
    public final Vector3d invTransformPosition(@NotNull Vector3d position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.invTransformPosition(position, position);
    }

    @NotNull
    public final Vector3d transformDirection(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.transformDirection(direction, direction);
    }

    @NotNull
    public final Vector3d invTransformDirection(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.invTransformDirection(direction, direction);
    }

    @NotNull
    public final Vector3dc component1() {
        return this.pos;
    }

    @NotNull
    public final Quaterniondc component2() {
        return this.rot;
    }

    @NotNull
    public final Vector3dc component3() {
        return this.vel;
    }

    @NotNull
    public final Vector3dc component4() {
        return this.omega;
    }

    @NotNull
    public final PoseVel copy(@NotNull Vector3dc pos, @NotNull Quaterniondc rot, @NotNull Vector3dc vel, @NotNull Vector3dc omega) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)omega, (String)"omega");
        return new PoseVel(pos, rot, vel, omega);
    }

    public static /* synthetic */ PoseVel copy$default(PoseVel poseVel, Vector3dc vector3dc, Quaterniondc quaterniondc, Vector3dc vector3dc2, Vector3dc vector3dc3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector3dc = poseVel.pos;
        }
        if ((n2 & 2) != 0) {
            quaterniondc = poseVel.rot;
        }
        if ((n2 & 4) != 0) {
            vector3dc2 = poseVel.vel;
        }
        if ((n2 & 8) != 0) {
            vector3dc3 = poseVel.omega;
        }
        return poseVel.copy(vector3dc, quaterniondc, vector3dc2, vector3dc3);
    }

    @NotNull
    public String toString() {
        return "PoseVel(pos=" + this.pos + ", rot=" + this.rot + ", vel=" + this.vel + ", omega=" + this.omega + ')';
    }

    public int hashCode() {
        int result2 = this.pos.hashCode();
        result2 = result2 * 31 + this.rot.hashCode();
        result2 = result2 * 31 + this.vel.hashCode();
        result2 = result2 * 31 + this.omega.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PoseVel)) {
            return false;
        }
        PoseVel poseVel = (PoseVel)other;
        if (!Intrinsics.areEqual((Object)this.pos, (Object)poseVel.pos)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rot, (Object)poseVel.rot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vel, (Object)poseVel.vel)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.omega, (Object)poseVel.omega);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/physics_api/PoseVel$Companion;", "", "Lorg/joml/Vector3dc;", "pos", "Lorg/joml/Quaterniondc;", "rot", "Lorg/valkyrienskies/physics_api/PoseVel;", "createPoseVel", "(Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;)Lorg/valkyrienskies/physics_api/PoseVel;", "NULL_POSE_VEL", "Lorg/valkyrienskies/physics_api/PoseVel;", "getNULL_POSE_VEL", "()Lorg/valkyrienskies/physics_api/PoseVel;", "<init>", "()V", "physics_api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PoseVel getNULL_POSE_VEL() {
            return NULL_POSE_VEL;
        }

        @NotNull
        public final PoseVel createPoseVel(@NotNull Vector3dc pos, @NotNull Quaterniondc rot) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
            return new PoseVel(pos, rot, new Vector3d(), new Vector3d());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

