/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.constraints.AttachmentConstraintData;
import org.valkyrienskies.physics_api.constraints.ConstraintAndId;
import org.valkyrienskies.physics_api.constraints.ConstraintData;
import org.valkyrienskies.physics_api.constraints.ConstraintDataType;
import org.valkyrienskies.physics_api.constraints.FixedOrientationConstraintData;
import org.valkyrienskies.physics_api.constraints.HingeConstraintData;
import org.valkyrienskies.physics_api.constraints.HingeOrientationConstraintData;
import org.valkyrienskies.physics_api.constraints.HingeSwingLimitsConstraintData;
import org.valkyrienskies.physics_api.constraints.HingeTargetAngleConstraintData;
import org.valkyrienskies.physics_api.constraints.PosDampingConstraintData;
import org.valkyrienskies.physics_api.constraints.RopeConstraintData;
import org.valkyrienskies.physics_api.constraints.RotDampingAxes;
import org.valkyrienskies.physics_api.constraints.RotDampingConstraintData;
import org.valkyrienskies.physics_api.constraints.SlideConstraintData;
import org.valkyrienskies.physics_api.constraints.SphericalSwingLimitsConstraintData;
import org.valkyrienskies.physics_api.constraints.SphericalTwistLimitsConstraintData;

public class ConstraintEncoder {
    private static final int CONSTRAINT_MAX_SIZE = 152;
    private static final int CONSTRAINT_ID_SIZE = 4;
    private static final int BYTE_ARRAY_LENGTH_SIZE = 4;

    public static void encodeConstraint(@NotNull ConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        switch (constraint.getConstraintType()) {
            case ATTACHMENT: {
                ConstraintEncoder.encodeAttachmentConstraintData((AttachmentConstraintData)constraint, writeBuffer);
                break;
            }
            case FIXED_ORIENTATION: {
                ConstraintEncoder.encodeFixedOrientationConstraintData((FixedOrientationConstraintData)constraint, writeBuffer);
                break;
            }
            case HINGE: {
                ConstraintEncoder.encodeHingeConstraintData((HingeConstraintData)constraint, writeBuffer);
                break;
            }
            case HINGE_ORIENTATION: {
                ConstraintEncoder.encodeHingeOrientationConstraintData((HingeOrientationConstraintData)constraint, writeBuffer);
                break;
            }
            case HINGE_SWING_LIMITS: {
                ConstraintEncoder.encodeHingeSwingLimitsConstraintData((HingeSwingLimitsConstraintData)constraint, writeBuffer);
                break;
            }
            case HINGE_TARGET_ANGLE: {
                ConstraintEncoder.encodeHingeTargetAngleConstraintData((HingeTargetAngleConstraintData)constraint, writeBuffer);
                break;
            }
            case POS_DAMPING: {
                ConstraintEncoder.encodePosDampingConstraintData((PosDampingConstraintData)constraint, writeBuffer);
                break;
            }
            case ROPE: {
                ConstraintEncoder.encodeRopeConstraintData((RopeConstraintData)constraint, writeBuffer);
                break;
            }
            case ROT_DAMPING: {
                ConstraintEncoder.encodeRotDampingConstraintData((RotDampingConstraintData)constraint, writeBuffer);
                break;
            }
            case SLIDE: {
                ConstraintEncoder.encodeSlideConstraintData((SlideConstraintData)constraint, writeBuffer);
                break;
            }
            case SPHERICAL_SWING_LIMITS: {
                ConstraintEncoder.encodeSphericalSwingLimitsConstraintData((SphericalSwingLimitsConstraintData)constraint, writeBuffer);
                break;
            }
            case SPHERICAL_TWIST_LIMITS: {
                ConstraintEncoder.encodeSphericalTwistLimitsConstraintData((SphericalTwistLimitsConstraintData)constraint, writeBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ConstraintDataType " + (Object)((Object)constraint.getConstraintType()));
            }
        }
    }

    @NotNull
    public static ConstraintData decodeConstraint(@NotNull ByteBuffer readBuffer) {
        ConstraintDataType constraintDataType = ConstraintDataType.values()[readBuffer.getInt()];
        switch (constraintDataType) {
            case ATTACHMENT: {
                return ConstraintEncoder.decodeAttachmentConstraintData(readBuffer);
            }
            case FIXED_ORIENTATION: {
                return ConstraintEncoder.decodeFixedOrientationConstraintData(readBuffer);
            }
            case HINGE: {
                return ConstraintEncoder.decodeHingeConstraintData(readBuffer);
            }
            case HINGE_ORIENTATION: {
                return ConstraintEncoder.decodeHingeOrientationConstraintData(readBuffer);
            }
            case HINGE_SWING_LIMITS: {
                return ConstraintEncoder.decodeHingeSwingLimitsConstraintData(readBuffer);
            }
            case HINGE_TARGET_ANGLE: {
                return ConstraintEncoder.decodeHingeTargetAngleConstraintDataConstraint(readBuffer);
            }
            case POS_DAMPING: {
                return ConstraintEncoder.decodePosDampingConstraintData(readBuffer);
            }
            case ROPE: {
                return ConstraintEncoder.decodeRopeConstraintData(readBuffer);
            }
            case ROT_DAMPING: {
                return ConstraintEncoder.decodeRotDampingConstraintData(readBuffer);
            }
            case SLIDE: {
                return ConstraintEncoder.decodeSlideConstraintData(readBuffer);
            }
            case SPHERICAL_SWING_LIMITS: {
                return ConstraintEncoder.decodeSphericalSwingLimitsConstraintData(readBuffer);
            }
            case SPHERICAL_TWIST_LIMITS: {
                return ConstraintEncoder.decodeSphericalTwistLimitsConstraintData(readBuffer);
            }
        }
        throw new IllegalArgumentException("Unknown ConstraintDataType " + (Object)((Object)constraintDataType));
    }

    public static void encodeConstraintAndId(@NotNull ConstraintAndId constraintAndId, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(constraintAndId.getConstraintId());
        ConstraintEncoder.encodeConstraint(constraintAndId.getConstraintData(), writeBuffer);
    }

    @NotNull
    public static ConstraintAndId decodeConstraintAndId(@NotNull ByteBuffer readBuffer) {
        int constraintId = readBuffer.getInt();
        ConstraintData constraint = ConstraintEncoder.decodeConstraint(readBuffer);
        return new ConstraintAndId(constraintId, constraint);
    }

    @NotNull
    public static byte[] encodeConstraintAndId(@NotNull ConstraintAndId constraintAndId) {
        byte[] bytesRaw = new byte[156];
        ConstraintEncoder.encodeConstraintAndId(constraintAndId, ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
        return bytesRaw;
    }

    @NotNull
    public static ConstraintAndId decodeConstraintAndId(@NotNull byte[] bytesRaw) {
        return ConstraintEncoder.decodeConstraintAndId(ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
    }

    private static void encodeAttachmentConstraintData(@NotNull AttachmentConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.ATTACHMENT.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        writeBuffer.putDouble(constraint.getFixedDistance());
        writeBuffer.putInt(constraint.getBreakOnMaxForce() ? 1 : 0);
    }

    @NotNull
    private static AttachmentConstraintData decodeAttachmentConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        double fixedDistance = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new AttachmentConstraintData(rigidBodyId0, rigidBodyId1, compliance, localPos0, localPos1, maxForce, breakOnMaxForce, fixedDistance);
    }

    private static void encodeFixedOrientationConstraintData(@NotNull FixedOrientationConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.FIXED_ORIENTATION.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static FixedOrientationConstraintData decodeFixedOrientationConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new FixedOrientationConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce);
    }

    private static void encodeHingeConstraintData(@NotNull HingeConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.HINGE.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static HingeConstraintData decodeHingeConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new HingeConstraintData(rigidBodyId0, rigidBodyId1, compliance, localPos0, localPos1, maxForce, localRot0, localRot1, maxTorque, breakOnMaxForce);
    }

    private static void encodeHingeOrientationConstraintData(@NotNull HingeOrientationConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.HINGE_ORIENTATION.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static HingeOrientationConstraintData decodeHingeOrientationConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new HingeOrientationConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce);
    }

    private static void encodeHingeSwingLimitsConstraintData(@NotNull HingeSwingLimitsConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.HINGE_SWING_LIMITS.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getMinSwingAngle());
        writeBuffer.putDouble(constraint.getMaxSwingAngle());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static HingeSwingLimitsConstraintData decodeHingeSwingLimitsConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double minSwingAngle = readBuffer.getDouble();
        double maxSwingAngle = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new HingeSwingLimitsConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce, minSwingAngle, maxSwingAngle);
    }

    private static void encodeHingeTargetAngleConstraintData(@NotNull HingeTargetAngleConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.HINGE_TARGET_ANGLE.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getTargetAngle());
        writeBuffer.putDouble(constraint.getNextTickTargetAngle());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static HingeTargetAngleConstraintData decodeHingeTargetAngleConstraintDataConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double targetAngle = readBuffer.getDouble();
        double nextTickTargetAngle = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new HingeTargetAngleConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce, targetAngle, nextTickTargetAngle);
    }

    private static void encodePosDampingConstraintData(@NotNull PosDampingConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.POS_DAMPING.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        writeBuffer.putDouble(constraint.getPosDamping());
        writeBuffer.putInt(constraint.getBreakOnMaxForce() ? 1 : 0);
    }

    @NotNull
    private static PosDampingConstraintData decodePosDampingConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        double posDamping = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new PosDampingConstraintData(rigidBodyId0, rigidBodyId1, compliance, localPos0, localPos1, maxForce, breakOnMaxForce, posDamping);
    }

    private static void encodeRopeConstraintData(@NotNull RopeConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.ROPE.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        writeBuffer.putDouble(constraint.getRopeLength());
        writeBuffer.putInt(constraint.getBreakOnMaxForce() ? 1 : 0);
    }

    @NotNull
    private static RopeConstraintData decodeRopeConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        double ropeLength = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new RopeConstraintData(rigidBodyId0, rigidBodyId1, compliance, localPos0, localPos1, maxForce, breakOnMaxForce, ropeLength);
    }

    private static void encodeRotDampingConstraintData(@NotNull RotDampingConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.ROT_DAMPING.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getRotDamping());
        switch (constraint.getRotDampingAxes()) {
            case PARALLEL: {
                writeBuffer.putInt(0);
                break;
            }
            case PERPENDICULAR: {
                writeBuffer.putInt(1);
                break;
            }
            case ALL_AXES: {
                writeBuffer.putInt(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of constraint.getRotDampingAxes() " + (Object)((Object)constraint.getRotDampingAxes()));
            }
        }
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static RotDampingConstraintData decodeRotDampingConstraintData(@NotNull ByteBuffer readBuffer) {
        RotDampingAxes rotDampingAxes;
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double rotDamping = readBuffer.getDouble();
        int rotDampingAxesRaw = readBuffer.getInt();
        switch (rotDampingAxesRaw) {
            case 0: {
                rotDampingAxes = RotDampingAxes.PARALLEL;
                break;
            }
            case 1: {
                rotDampingAxes = RotDampingAxes.PERPENDICULAR;
                break;
            }
            case 2: {
                rotDampingAxes = RotDampingAxes.ALL_AXES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of rotDampingAxesRaw " + rotDampingAxesRaw);
            }
        }
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new RotDampingConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce, rotDamping, rotDampingAxes);
    }

    private static void encodeSlideConstraintData(@NotNull SlideConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.SLIDE.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        ConstraintEncoder.writeVector3dc(constraint.getLocalSlideAxis0(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxDistBetweenPoints());
        writeBuffer.putInt(constraint.getBreakOnMaxForce() ? 1 : 0);
    }

    @NotNull
    private static SlideConstraintData decodeSlideConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        Vector3dc localSlideAxis0 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxDistBetweenPoints = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new SlideConstraintData(rigidBodyId0, rigidBodyId1, compliance, localPos0, localPos1, maxForce, breakOnMaxForce, localSlideAxis0, maxDistBetweenPoints);
    }

    private static void encodeSphericalSwingLimitsConstraintData(@NotNull SphericalSwingLimitsConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.SPHERICAL_SWING_LIMITS.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getMinSwingAngle());
        writeBuffer.putDouble(constraint.getMaxSwingAngle());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static SphericalSwingLimitsConstraintData decodeSphericalSwingLimitsConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double minSwingAngle = readBuffer.getDouble();
        double maxSwingAngle = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new SphericalSwingLimitsConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce, minSwingAngle, maxSwingAngle);
    }

    private static void encodeSphericalTwistLimitsConstraintData(@NotNull SphericalTwistLimitsConstraintData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintDataType.SPHERICAL_TWIST_LIMITS.ordinal());
        writeBuffer.putInt(constraint.getPhysicsBodyId0());
        writeBuffer.putInt(constraint.getPhysicsBodyId1());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getMinTwistAngle());
        writeBuffer.putDouble(constraint.getMaxTwistAngle());
        writeBuffer.putInt(constraint.getBreakOnMaxTorque() ? 1 : 0);
    }

    @NotNull
    private static SphericalTwistLimitsConstraintData decodeSphericalTwistLimitsConstraintData(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double minTwistAngle = readBuffer.getDouble();
        double maxTwistAngle = readBuffer.getDouble();
        boolean breakOnMaxForce = readBuffer.getInt() != 0;
        return new SphericalTwistLimitsConstraintData(rigidBodyId0, rigidBodyId1, compliance, localRot0, localRot1, maxTorque, breakOnMaxForce, minTwistAngle, maxTwistAngle);
    }

    public static void encodeConstraints(@NotNull List<ConstraintAndId> constraints, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(0);
        for (ConstraintAndId constraintAndId : constraints) {
            ConstraintEncoder.encodeConstraintAndId(constraintAndId, writeBuffer);
        }
        int position = writeBuffer.position();
        writeBuffer.putInt(0, position);
    }

    @NotNull
    public static List<ConstraintAndId> decodeConstraints(@NotNull ByteBuffer readBuffer) {
        ArrayList<ConstraintAndId> constraints = new ArrayList<ConstraintAndId>();
        int bytesSize = readBuffer.getInt();
        while (readBuffer.position() != bytesSize) {
            ConstraintAndId constraintAndId = ConstraintEncoder.decodeConstraintAndId(readBuffer);
            constraints.add(constraintAndId);
        }
        return constraints;
    }

    @NotNull
    public static byte[] encodeConstraints(@NotNull List<ConstraintAndId> constraints) {
        byte[] bytesRaw = new byte[constraints.size() * 156 + 4];
        ConstraintEncoder.encodeConstraints(constraints, ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
        return bytesRaw;
    }

    @NotNull
    public static List<ConstraintAndId> decodeConstraints(@NotNull byte[] bytesRaw) {
        return ConstraintEncoder.decodeConstraints(ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
    }

    private static void writeVector3dc(@NotNull Vector3dc vector3dc, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putDouble(vector3dc.x());
        writeBuffer.putDouble(vector3dc.y());
        writeBuffer.putDouble(vector3dc.z());
    }

    @NotNull
    private static Vector3dc readVector3dc(@NotNull ByteBuffer readBuffer) {
        return new Vector3d(readBuffer.getDouble(), readBuffer.getDouble(), readBuffer.getDouble());
    }

    private static void writeQuaterniondc(@NotNull Quaterniondc quaterniondc, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putDouble(quaterniondc.w());
        writeBuffer.putDouble(quaterniondc.x());
        writeBuffer.putDouble(quaterniondc.y());
        writeBuffer.putDouble(quaterniondc.z());
    }

    @NotNull
    private static Quaterniondc readQuaterniondc(@NotNull ByteBuffer readBuffer) {
        double w2 = readBuffer.getDouble();
        double x2 = readBuffer.getDouble();
        double y2 = readBuffer.getDouble();
        double z2 = readBuffer.getDouble();
        return new Quaterniond(x2, y2, z2, w2);
    }
}

