/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.VSByteBuffer;

public final class KrunchByteBuffer
implements VSByteBuffer {
    private final ByteBuffer byteBuffer;
    private final long bufferAddress;
    private final int bufferSize;

    public KrunchByteBuffer(int size) {
        this.byteBuffer = ByteBuffer.allocateDirect(size);
        this.bufferAddress = KrunchByteBuffer.getDirectBufferAddress(this.byteBuffer);
        this.bufferSize = size;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public long getDirectAddress() {
        return this.bufferAddress;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    private static native long getDirectBufferAddress(@NotNull ByteBuffer var0);
}

