/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.joml.primitives.AABBic;
import org.valkyrienskies.physics_api.CollisionShapeFactory;
import org.valkyrienskies.physics_api.CompoundShapeReference;
import org.valkyrienskies.physics_api.Lod1BlockRegistry;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api_krunch.KrunchNativeBoxShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativeCapsuleShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativeCompoundShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativeSphereShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativeVoxelShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativeWheelShapeReference;
import org.valkyrienskies.physics_api_krunch.voxel.KrunchLod1BlockRegistry;

public class KrunchCollisionShapeFactory
implements CollisionShapeFactory {
    @Override
    @NotNull
    public KrunchNativeVoxelShapeReference makeVoxelShapeReference(@NotNull Vector3ic minDefined, @NotNull Vector3ic maxDefined, @NotNull AABBic totalVoxelRegion, @NotNull Lod1BlockRegistry lod1BlockRegistry) throws UsingDeletedReferenceException {
        long voxelShapeAddress = KrunchCollisionShapeFactory.createVoxelShape(minDefined.x(), minDefined.y(), minDefined.z(), maxDefined.x(), maxDefined.y(), maxDefined.z(), totalVoxelRegion.minX(), totalVoxelRegion.minY(), totalVoxelRegion.minZ(), totalVoxelRegion.maxX(), totalVoxelRegion.maxY(), totalVoxelRegion.maxZ(), ((KrunchLod1BlockRegistry)lod1BlockRegistry).getBlockRegistryAddress());
        KrunchNativeVoxelShapeReference voxelShapeReference = new KrunchNativeVoxelShapeReference(voxelShapeAddress, (KrunchLod1BlockRegistry)lod1BlockRegistry);
        voxelShapeReference.setVoxelTerrainFullyLoaded(false);
        return voxelShapeReference;
    }

    @Override
    @NotNull
    public KrunchNativeBoxShapeReference makeBoxShapeReference(@NotNull Vector3dc vector3dc) throws UsingDeletedReferenceException {
        long boxshapeAddress = KrunchCollisionShapeFactory.createBoxShape(vector3dc.x(), vector3dc.y(), vector3dc.z());
        return new KrunchNativeBoxShapeReference(boxshapeAddress);
    }

    @Override
    @NotNull
    public KrunchNativeCapsuleShapeReference makeCapsuleShapeReference(double radius, double length) throws UsingDeletedReferenceException {
        long shapeAddress = KrunchCollisionShapeFactory.createCapsuleShape(radius, length);
        return new KrunchNativeCapsuleShapeReference(shapeAddress);
    }

    @Override
    @NotNull
    public KrunchNativeSphereShapeReference makeSphereShapeReference(double radius) throws UsingDeletedReferenceException {
        long shapeAddress = KrunchCollisionShapeFactory.createSphereShape(radius);
        return new KrunchNativeSphereShapeReference(shapeAddress);
    }

    @Override
    @NotNull
    public KrunchNativeWheelShapeReference makeWheelShapeReference(double wheelRadius, double halfThickness, int pointShellSize) throws UsingDeletedReferenceException {
        long shapeAddress = KrunchCollisionShapeFactory.createWheelShape(wheelRadius, halfThickness, pointShellSize);
        return new KrunchNativeWheelShapeReference(shapeAddress);
    }

    @Override
    @NotNull
    public CompoundShapeReference makeCompoundShapeReference() throws UsingDeletedReferenceException {
        long shapeAddress = KrunchCollisionShapeFactory.createCompoundShape();
        return new KrunchNativeCompoundShapeReference(shapeAddress);
    }

    private static native long createVoxelShape(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12);

    private static native long createBoxShape(double var0, double var2, double var4);

    private static native long createSphereShape(double var0);

    private static native long createCapsuleShape(double var0, double var2);

    private static native long createWheelShape(double var0, double var2, int var4);

    private static native long createCompoundShape();
}

