/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch.voxel;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.Lod1BlockRegistry;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api.VSByteBuffer;
import org.valkyrienskies.physics_api.voxel.VoxelChunk16;
import org.valkyrienskies.physics_api.voxel.updates.DenseVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel.updates.QueueableVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel.updates.SparseVoxelShapeUpdate;
import org.valkyrienskies.physics_api_krunch.voxel.KrunchLod1BlockRegistry;
import org.valkyrienskies.physics_api_krunch.voxel.KrunchVoxelChunk16UpdateSerializer;

public class KrunchVoxelChunk16
implements VoxelChunk16 {
    private static final long DELETED_CHUNK_ADDRESS = 0L;
    private long chunkAddress;
    private final KrunchLod1BlockRegistry lod1BlockRegistry;
    private final List<QueueableVoxelShapeUpdate> queuedUpdates;

    public KrunchVoxelChunk16(long chunkAddress, @NotNull KrunchLod1BlockRegistry lod1BlockRegistry) {
        this.chunkAddress = chunkAddress;
        this.lod1BlockRegistry = lod1BlockRegistry;
        this.queuedUpdates = new ArrayList<QueueableVoxelShapeUpdate>();
    }

    public KrunchVoxelChunk16(@NotNull KrunchLod1BlockRegistry lod1BlockRegistry) {
        this.chunkAddress = KrunchVoxelChunk16.createEmptyVoxelChunk16Native();
        this.lod1BlockRegistry = lod1BlockRegistry;
        this.queuedUpdates = new ArrayList<QueueableVoxelShapeUpdate>();
    }

    public long getChunkAddress() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long chunkAddressCopy = this.chunkAddress;
        this.chunkAddress = 0L;
        return chunkAddressCopy;
    }

    @Override
    public void bakeChunk(@NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        for (QueueableVoxelShapeUpdate update : this.queuedUpdates) {
            vsByteBuffer.getByteBuffer().position(0);
            if (update instanceof DenseVoxelShapeUpdate) {
                KrunchVoxelChunk16UpdateSerializer.serializeDenseVoxelChunk16Update((DenseVoxelShapeUpdate)update, vsByteBuffer.getByteBuffer());
                KrunchVoxelChunk16.applyDenseVoxelChunkUpdate(this.chunkAddress, this.lod1BlockRegistry.getBlockRegistryAddress(), vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
                continue;
            }
            if (update instanceof SparseVoxelShapeUpdate) {
                KrunchVoxelChunk16UpdateSerializer.serializeSparseVoxelChunk16Update((SparseVoxelShapeUpdate)update, vsByteBuffer.getByteBuffer());
                KrunchVoxelChunk16.applySparseVoxelChunkUpdate(this.chunkAddress, this.lod1BlockRegistry.getBlockRegistryAddress(), vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
                continue;
            }
            throw new IllegalStateException("Unsupported voxel update!");
        }
        this.queuedUpdates.clear();
        KrunchVoxelChunk16.bakeVoxel16Chunk(this.chunkAddress, this.lod1BlockRegistry.getBlockRegistryAddress());
    }

    @Override
    public boolean isBaked() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return this.queuedUpdates.isEmpty();
    }

    @Override
    public void queueUpdate(@NotNull QueueableVoxelShapeUpdate voxelShapeUpdate2) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        this.queuedUpdates.add(voxelShapeUpdate2);
    }

    @Override
    @NotNull
    public Lod1BlockRegistry getLod1BlockRegistry() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return this.lod1BlockRegistry;
    }

    @Override
    public void close() {
        if (!this.isDeleted()) {
            KrunchVoxelChunk16.deleteChunk(this.chunkAddress);
            this.chunkAddress = 0L;
        }
    }

    protected void finalize() {
        if (!this.isDeleted()) {
            this.close();
        }
    }

    @Override
    public boolean isDeleted() {
        return this.chunkAddress == 0L;
    }

    private void ensureNotDeleted() {
        if (this.isDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    public int getLod1SolidBlockStateId(int x2, int y2, int z2) {
        this.ensureNotDeleted();
        return KrunchVoxelChunk16.getLod1SolidBlockStateId(this.chunkAddress, x2, y2, z2);
    }

    public int getLod1LiquidBlockStateId(int x2, int y2, int z2) {
        this.ensureNotDeleted();
        return KrunchVoxelChunk16.getLod1LiquidBlockStateId(this.chunkAddress, x2, y2, z2);
    }

    private static native void applyDenseVoxelChunkUpdate(long var0, long var2, long var4, int var6);

    private static native void applySparseVoxelChunkUpdate(long var0, long var2, long var4, int var6);

    private static native void bakeVoxel16Chunk(long var0, long var2);

    private static native void deleteChunk(long var0);

    private static native long createEmptyVoxelChunk16Native();

    private static native int getLod1SolidBlockStateId(long var0, int var2, int var3, int var4);

    private static native int getLod1LiquidBlockStateId(long var0, int var2, int var3, int var4);
}

