/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mss.utils;

import com.mojang.datafixers.util.Pair;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class AsyncLocator {
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;

    private AsyncLocator() {
    }

    private static void setupExecutorService() {
        AsyncLocator.shutdownExecutorService();
        int threads = 2;
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(threads, new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "mss-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(null, r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    private static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    public static void handleServerAboutToStartEvent() {
        AsyncLocator.setupExecutorService();
    }

    public static void handleServerStoppingEvent() {
        AsyncLocator.shutdownExecutorService();
    }

    public static LocateTask<class_2338> locate(class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures));
        return new LocateTask<class_2338>(level.method_8503(), completableFuture, future);
    }

    public static LocateTask<Pair<class_2338, class_6880<class_3195>>> locate(class_3218 level, class_6885<class_3195> structureSet, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateChunkGenerator(completableFuture, level, structureSet, pos, searchRadius, skipKnownStructures));
        return new LocateTask<Pair<class_2338, class_6880<class_3195>>>(level.method_8503(), completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<class_2338> completableFuture, class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipExistingChunks) {
        class_2338 foundPos = level.method_8487(structureTag, pos, searchRadius, skipExistingChunks);
        completableFuture.complete(foundPos);
    }

    private static void doLocateChunkGenerator(CompletableFuture<Pair<class_2338, class_6880<class_3195>>> completableFuture, class_3218 level, class_6885<class_3195> structureSet, class_2338 pos, int searchRadius, boolean skipExistingChunks) {
        Pair foundPair = level.method_14178().method_12129().method_12103(level, structureSet, pos, searchRadius, skipExistingChunks);
        completableFuture.complete((Pair<class_2338, class_6880<class_3195>>)foundPair);
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.method_20493(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

