/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.client.render.highlight;

import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.client.render.highlight.HighlightHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.OptionalDouble;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class HighlightRender
extends class_1921 {
    public static final HighlightRender INSTANCE = new HighlightRender();
    private final class_4668.class_4677 LINE_3 = new class_4668.class_4677(OptionalDouble.of(3.0));
    private final class_1921 BLOCK_HIGHLIGHT_LINE = HighlightRender.method_24049((String)"glodium_block_highlight_line", (class_293)class_290.field_29337, (class_293.class_5596)class_293.class_5596.field_27377, (int)65536, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23609(this.LINE_3).method_23615(class_4668.class_4685.field_21368).method_34577(field_21378).method_23604(field_21346).method_23603(field_21345).method_23608(field_21384).method_23616(field_21349).method_34578(field_29433).method_23617(false));

    public static void hook() {
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(listener -> {
            class_4587 ps = listener.matrixStack();
            class_4597 buffer = listener.consumers();
            class_4184 camera = listener.camera();
            if (buffer instanceof class_4597.class_4598) {
                class_4597.class_4598 source = (class_4597.class_4598)buffer;
                INSTANCE.tick(ps, source, camera);
            }
        });
    }

    public void tick(class_4587 stack, class_4597.class_4598 multiBuf, class_4184 camera) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        this.invalidate();
        Collection<HighlightHandler.HighlightData> drawList = HighlightHandler.getBlockData();
        if (drawList.isEmpty()) {
            return;
        }
        for (HighlightHandler.HighlightData block : drawList) {
            if (!block.checkDim((class_5321<class_1937>)world.method_27983()) || !block.allowRender()) continue;
            this.drawBlockOutline(block.box(), block.color(), stack, camera, (class_4597)multiBuf);
        }
        multiBuf.method_22993();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private void invalidate() {
        while (HighlightHandler.getFirst() != null) {
            HighlightHandler.HighlightData info = HighlightHandler.getFirst();
            if (System.currentTimeMillis() <= info.time()) break;
            HighlightHandler.expire();
        }
    }

    private void drawBlockOutline(class_238 box, ColorData color, class_4587 stack, class_4184 camera, class_4597 multiBuf) {
        float r = color.getRf();
        float g = color.getGf();
        float b = color.getBf();
        float a = color.getAf();
        if (camera.method_19332()) {
            class_243 vec3 = camera.method_19326().method_22882();
            class_238 aabb = box.method_997(vec3);
            class_243 topRight = new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1324);
            class_243 bottomRight = new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1324);
            class_243 bottomLeft = new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1324);
            class_243 topLeft = new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1324);
            class_243 topRight2 = new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1321);
            class_243 bottomRight2 = new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1321);
            class_243 bottomLeft2 = new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1321);
            class_243 topLeft2 = new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1321);
            class_4588 buf = multiBuf.getBuffer(this.BLOCK_HIGHLIGHT_LINE);
            this.renderBox(buf, stack, topLeft, bottomLeft, topRight, bottomRight, r, g, b, a);
            this.renderBox(buf, stack, topLeft2, bottomLeft2, topRight2, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, topRight, topRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomRight, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomLeft, bottomLeft2, r, g, b, a);
            this.renderLine(buf, stack, topLeft, topLeft2, r, g, b, a);
        }
    }

    private void renderBox(class_4588 buf, class_4587 stack, class_243 topLeft, class_243 bottomLeft, class_243 topRight, class_243 bottomRight, float r, float g, float b, float a) {
        this.renderLine(buf, stack, topLeft, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, topLeft, topRight, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, topRight, r, g, b, a);
    }

    private void renderLine(class_4588 buf, class_4587 pose, class_243 from, class_243 to, float r, float g, float b, float a) {
        Matrix4f mat = pose.method_23760().method_23761();
        class_243 normal = from.method_1020(to);
        buf.method_22918(mat, (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_22915(r, g, b, a).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        buf.method_22918(mat, (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_22915(r, g, b, a).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    private HighlightRender() {
        super("", class_290.field_29337, class_293.class_5596.field_27377, 0, false, false, () -> {}, () -> {});
    }
}

