/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ReflectKit {
    public static Method reflectMethod(Class<?> owner, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return ReflectKit.reflectMethod(owner, new String[]{name}, paramTypes);
    }

    public static Method reflectMethod(Class<?> owner, String[] names, Class<?> ... paramTypes) throws NoSuchMethodException {
        Method m = null;
        for (String name : names) {
            try {
                m = owner.getDeclaredMethod(name, paramTypes);
                if (m == null) continue;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m == null) {
            throw new NoSuchMethodException("Can't find field from " + Arrays.toString(names));
        }
        m.setAccessible(true);
        return m;
    }

    public static Field reflectField(Class<?> owner, String ... names) throws NoSuchFieldException {
        Field f = null;
        for (String name : names) {
            try {
                f = owner.getDeclaredField(name);
                if (f == null) continue;
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (f == null) {
            throw new NoSuchFieldException("Can't find field from " + Arrays.toString(names));
        }
        f.setAccessible(true);
        return f;
    }

    public static <T> T readField(Object owner, Field field) {
        try {
            return (T)field.get(owner);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read field: " + field);
        }
    }

    public static void writeField(Object owner, Field field, Object value) {
        try {
            field.set(owner, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to write field: " + field);
        }
    }

    public static void executeMethod(Object owner, Method method, Object ... args) {
        try {
            method.invoke(owner, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to execute method: " + method);
        }
    }

    public static <T> T executeMethod2(Object owner, Method method, Object ... args) {
        try {
            return (T)method.invoke(owner, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to execute method: " + method);
        }
    }
}

