/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFException;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFDirectoryHandler;
import traben.entity_model_features.utils.EMFUtils;

public class EMFJemData {
    private final transient LinkedHashMap<String, List<LinkedHashMap<String, String>>> allTopLevelAnimationsByVanillaPartName = new LinkedHashMap();
    public String texture = "";
    public int[] textureSize = null;
    public double shadow_size = 1.0;
    public LinkedList<EMFPartData> models = new LinkedList();
    public transient EMFDirectoryHandler directoryContext = null;
    private transient EMFModel_ID mobModelIDInfo = null;
    private transient class_2960 customTexture = null;
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern THIS = Pattern.compile("(?<=\\W|^)this(?=\\W)");
    private static final Pattern PART = Pattern.compile("(?<=\\W|^)part(?=\\W)");

    public LinkedHashMap<String, List<LinkedHashMap<String, String>>> getAllTopLevelAnimationsByVanillaPartName() {
        return this.allTopLevelAnimationsByVanillaPartName;
    }

    public EMFModel_ID getMobModelIDInfo() {
        return this.mobModelIDInfo;
    }

    public class_2960 getCustomTexture() {
        return this.customTexture;
    }

    @Nullable
    public class_2960 validateJemTexture(String textureIn) {
        return this.validateJemTexture(textureIn, false);
    }

    @Nullable
    public class_2960 validateJemTexture(String textureIn, boolean canRemoveRedundancy) {
        if (textureIn == null || textureIn.isBlank()) {
            return null;
        }
        class_2960 res = this.validateResourcePathAndExists(textureIn, "png");
        if (canRemoveRedundancy && res != null) {
            Object textureTest = res.toString();
            if ("minecraft".equals(this.directoryContext.namespace) && (!((String)textureTest).contains(":") || ((String)textureTest).startsWith("minecraft:"))) {
                Object object = textureTest = ((String)textureTest).startsWith("minecraft:") ? textureTest : "minecraft:" + (String)textureTest;
                if (((String)textureTest).equals(EMFModelMappings.DEFAULT_TEXTURE_MAPPINGS.get(this.directoryContext.rawFileName))) {
                    if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                        EMFUtils.log("Removing redundant texture: " + (String)textureTest + " declared in " + this.directoryContext.getFileNameWithType());
                    }
                    return null;
                }
            }
        }
        return res == null ? class_1047.method_4539() : res;
    }

    @Nullable
    public class_2960 validateResourcePathAndExists(String pathIn, @Nullable String fileTypeExtension) {
        if (pathIn == null || pathIn.isBlank()) {
            return null;
        }
        Object pathTest = pathIn.trim();
        if (!((String)pathTest).isBlank()) {
            if (fileTypeExtension != null && !((String)pathTest).endsWith("." + fileTypeExtension)) {
                pathTest = (String)pathTest + "." + fileTypeExtension;
            }
            if (!((String)pathTest).contains(":")) {
                if (!((String)pathTest).contains("/")) {
                    pathTest = this.directoryContext.getRelativeDirectoryLocationNoValidation((String)pathTest);
                } else if (((String)pathTest).startsWith("./")) {
                    pathTest = this.directoryContext.getRelativeDirectoryLocationNoValidation(((String)pathTest).replaceFirst("\\./", ""));
                } else if (((String)pathTest).startsWith("~/")) {
                    pathTest = "optifine/" + ((String)pathTest).replaceFirst("~/", "");
                }
            }
            if (class_2960.method_20207((String)pathTest)) {
                class_2960 possibleResource = EMFUtils.res((String)pathTest);
                if (class_310.method_1551().method_1478().method_14486(possibleResource).isPresent()) {
                    return possibleResource;
                }
            } else {
                EMFUtils.logWarn("Invalid resource identifier: " + (String)pathTest + " for " + this.directoryContext.getFileNameWithType());
            }
        }
        return null;
    }

    public void prepare(EMFDirectoryHandler directoryContext, EMFModel_ID mobModelIDInfo) {
        try {
            this.directoryContext = directoryContext;
            this.mobModelIDInfo = mobModelIDInfo;
            if (this.textureSize == null || this.textureSize.length != 2) {
                this.textureSize = new int[]{64, 32};
                EMFUtils.logWarn("No textureSize provided for: " + directoryContext.getFileNameWithType() + ". Defaulting to 64x32 texture size for model.");
            }
            this.customTexture = this.validateJemTexture(this.texture, true);
            Map<String, String> map = EMFModelMappings.getMapOf(mobModelIDInfo, null);
            for (EMFPartData eMFPartData : this.models) {
                if (eMFPartData.part == null || !map.containsKey(eMFPartData.part)) continue;
                eMFPartData.originalPart = eMFPartData.part;
                eMFPartData.part = map.get(eMFPartData.part);
            }
            for (EMFPartData eMFPartData : this.models) {
                eMFPartData.prepare(this.textureSize, this);
            }
            if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("originalModels #= " + this.models.size());
            }
            LinkedHashMap<String, EMFPartData> orderedParts = new LinkedHashMap<String, EMFPartData>();
            for (EMFPartData partData : this.models) {
                String newId = EMFUtils.getIdUnique(orderedParts.keySet(), partData.id);
                if (!newId.equals(partData.id)) {
                    partData.id = newId;
                }
                orderedParts.put(partData.id, partData);
            }
            if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("orderedParts = " + orderedParts);
            }
            for (EMFPartData part : orderedParts.values()) {
                if (part.animations == null) continue;
                LinkedList animationsList = new LinkedList();
                for (LinkedHashMap linkedHashMap : part.animations) {
                    LinkedHashMap processedAnimations = new LinkedHashMap();
                    linkedHashMap.forEach((key, anim) -> {
                        key = EMFJemData.processAnimAndKeyString(part, key);
                        anim = EMFJemData.processAnimAndKeyString(part, anim);
                        if (!key.isBlank() && !anim.isBlank()) {
                            processedAnimations.put(key, anim);
                        }
                    });
                    if (processedAnimations.isEmpty()) continue;
                    animationsList.add(processedAnimations);
                }
                if (animationsList.isEmpty()) continue;
                this.allTopLevelAnimationsByVanillaPartName.computeIfAbsent(part.part, k -> new LinkedList()).addAll(animationsList);
            }
            if (this.shadow_size != 1.0) {
                this.shadow_size = Math.max(this.shadow_size, 0.0);
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("render.shadow_size", String.valueOf(this.shadow_size));
                this.allTopLevelAnimationsByVanillaPartName.computeIfAbsent("root", k -> new LinkedList()).add(linkedHashMap);
            }
        }
        catch (Exception e) {
            String message = "Error preparing jem data, for model [" + mobModelIDInfo.getDisplayFileName() + "]: " + e.getMessage();
            EMFUtils.logError(message);
            throw EMFException.recordException(new RuntimeException(message));
        }
    }

    @NotNull
    private static String processAnimAndKeyString(EMFPartData part, String anim) {
        String result = WHITESPACE.matcher(anim.trim()).replaceAll("");
        result = THIS.matcher(result).replaceAll(part.id);
        result = PART.matcher(result).replaceAll(Objects.requireNonNullElse(part.originalPart, part.part));
        return result;
    }

    public String toString() {
        return "EMF_JemData{texture='" + this.texture + "', textureSize=" + Arrays.toString(this.textureSize) + ", shadow_size=" + this.shadow_size + ", models=" + this.models.toString() + "}";
    }
}

