/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.utils.EMFUtils;

public class EMFDirectoryHandler {
    public final String namespace;
    public final String rawFileName;
    public final boolean isSubFolder;
    private final int packIndex;
    private final EMFDirectory actualDirectory;
    private final String suffixAndFileType;

    private EMFDirectoryHandler(String namespace, String modelFileName, String suffixAndFileType, boolean printing) {
        this.namespace = namespace;
        this.rawFileName = modelFileName;
        this.suffixAndFileType = suffixAndFileType;
        class_3300 resources = class_310.method_1551().method_1478();
        class_3298 emfDirResource = this.getResourceOrNull(resources, EMFDirectory.EMF, printing);
        class_3298 emfSubDirResource = this.getResourceOrNull(resources, EMFDirectory.EMF_SUB, printing);
        class_3298 optifineDirResource = this.getResourceOrNull(resources, EMFDirectory.OPTIFINE, printing);
        class_3298 optifineSubDirResource = this.getResourceOrNull(resources, EMFDirectory.OPTIFINE_SUB, printing);
        if (emfDirResource == null && emfSubDirResource == null && optifineDirResource == null && optifineSubDirResource == null) {
            this.actualDirectory = null;
            this.packIndex = -1;
            this.isSubFolder = false;
            return;
        }
        String emfPack = this.getPackId(emfDirResource);
        String emfSubPack = this.getPackId(emfSubDirResource);
        String optifinePack = this.getPackId(optifineDirResource);
        String optifineSubPack = this.getPackId(optifineSubDirResource);
        ArrayList<String> packOrder = EMFManager.getInstance().getResourcePackList();
        int emfDirIndex = this.getPackIndex(emfPack, packOrder);
        int emfSubDirIndex = this.getPackIndex(emfSubPack, packOrder);
        int optifineDirIndex = this.getPackIndex(optifinePack, packOrder);
        int optifineSubDirIndex = this.getPackIndex(optifineSubPack, packOrder);
        int emfHighest = Math.max(emfDirIndex, emfSubDirIndex);
        int optifineHighest = Math.max(optifineDirIndex, optifineSubDirIndex);
        if (printing) {
            EMFUtils.log(" >>>> pack order indices: " + emfDirIndex + ", " + emfSubDirIndex + ", " + optifineDirIndex + ", " + optifineSubDirIndex);
        }
        if (emfHighest >= optifineHighest) {
            if (emfDirIndex <= emfSubDirIndex) {
                this.actualDirectory = EMFDirectory.EMF_SUB;
                this.packIndex = emfSubDirIndex;
                this.isSubFolder = true;
            } else {
                this.actualDirectory = EMFDirectory.EMF;
                this.packIndex = emfDirIndex;
                this.isSubFolder = false;
            }
        } else if (optifineDirIndex <= optifineSubDirIndex) {
            this.actualDirectory = EMFDirectory.OPTIFINE_SUB;
            this.packIndex = optifineSubDirIndex;
            this.isSubFolder = true;
        } else {
            this.actualDirectory = EMFDirectory.OPTIFINE;
            this.packIndex = optifineDirIndex;
            this.isSubFolder = false;
        }
        if (printing) {
            EMFUtils.log(" >> Final valid directory after checking: " + this.actualDirectory.getAsDirectory(namespace, modelFileName) + suffixAndFileType);
        }
    }

    @Nullable
    public static EMFDirectoryHandler getDirectoryManagerOrNull(boolean printing, @NotNull String namespace, @NotNull String modelFileName, @NotNull String suffixAndFileType) {
        block4: {
            try {
                EMFDirectoryHandler directoryManager = new EMFDirectoryHandler(namespace, modelFileName, suffixAndFileType, printing);
                if (directoryManager.foundModel()) {
                    return directoryManager;
                }
            }
            catch (Exception e) {
                if (!printing) break block4;
                EMFUtils.log(" >> Exception when searching for: " + EMFDirectory.OPTIFINE.getAsDirectory(namespace, modelFileName) + suffixAndFileType + ". " + e.getMessage());
            }
        }
        if (printing) {
            EMFUtils.log(" >> Failed to find any files for: " + EMFDirectory.OPTIFINE.getAsDirectory(namespace, modelFileName) + suffixAndFileType);
        }
        return null;
    }

    public String getFileNameWithType() {
        return this.rawFileName + this.suffixAndFileType;
    }

    public String getRelativeDirectoryLocationNoValidation(String fileName) {
        return this.actualDirectory.getAsDirectory(this.namespace, this.rawFileName).replaceFirst(this.rawFileName + "$", fileName);
    }

    public int packIndex() {
        return this.packIndex;
    }

    public boolean validForThisBase(EMFDirectoryHandler propertiesOrSecond) {
        if (propertiesOrSecond == null) {
            return false;
        }
        return this.isSubFolder == propertiesOrSecond.isSubFolder && this.packIndex <= propertiesOrSecond.packIndex;
    }

    boolean foundModel() {
        return this.actualDirectory != null && this.packIndex != -1;
    }

    private class_3298 getResourceOrNull(class_3300 resources, EMFDirectory directory, boolean printing) {
        try {
            class_2960 loc = EMFUtils.res(directory.getAsDirectory(this.namespace, this.rawFileName) + this.suffixAndFileType);
            Optional res = resources.method_14486(loc);
            if (printing) {
                EMFUtils.log(" >>> Checking directory: " + loc + ", exists = " + res.isPresent());
            }
            return res.orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getPackId(@Nullable class_3298 resource) {
        return resource == null ? null : resource.method_14480();
    }

    private int getPackIndex(@Nullable String pack, List<String> packOrder) {
        return pack == null ? -1 : packOrder.indexOf(pack);
    }

    public String getFinalFileLocation() {
        return this.actualDirectory.getAsDirectory(this.namespace, this.rawFileName) + this.suffixAndFileType;
    }

    public class_2960 getRelativeFilePossiblyEMFOverridden(String jpmOrVariantFileNameWithSuffixAndFileType) {
        EMFDirectory over = this.actualDirectory.override();
        EMFDirectory fall = this.actualDirectory.fallback();
        EMFDirectory first = over == null ? this.actualDirectory : over;
        EMFDirectory second = fall == null ? this.actualDirectory : fall;
        class_2960 sameDir = EMFUtils.res(first.getAsDirectory(this.namespace, this.rawFileName).replaceFirst(this.rawFileName + "$", jpmOrVariantFileNameWithSuffixAndFileType));
        if (class_310.method_1551().method_1478().method_14486(sameDir).isPresent()) {
            return sameDir;
        }
        return EMFUtils.res(second.getAsDirectory(this.namespace, this.rawFileName).replaceFirst(this.rawFileName + "$", jpmOrVariantFileNameWithSuffixAndFileType));
    }

    public String toString() {
        return "EMF model, ID = " + EMFDirectory.OPTIFINE.getAsDirectory(this.namespace, this.rawFileName) + ", actual = " + this.actualDirectory.getAsDirectory(this.namespace, this.rawFileName);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum EMFDirectory {
        EMF{

            @Override
            public String getAsDirectory(String namespace, String fileName) {
                return namespace + ":emf/cem/" + fileName;
            }
        }
        ,
        EMF_SUB{

            @Override
            public String getAsDirectory(String namespace, String fileName) {
                return namespace + ":emf/cem/" + fileName + "/" + fileName;
            }
        }
        ,
        OPTIFINE{

            @Override
            public String getAsDirectory(String namespace, String fileName) {
                return namespace + ":optifine/cem/" + fileName;
            }
        }
        ,
        OPTIFINE_SUB{

            @Override
            public String getAsDirectory(String namespace, String fileName) {
                return namespace + ":optifine/cem/" + fileName + "/" + fileName;
            }
        };


        public abstract String getAsDirectory(String var1, String var2);

        @Nullable
        public EMFDirectory fallback() {
            return switch (this) {
                case EMF -> OPTIFINE;
                case EMF_SUB -> OPTIFINE_SUB;
                default -> null;
            };
        }

        @Nullable
        public EMFDirectory override() {
            return switch (this) {
                case OPTIFINE -> EMF;
                case OPTIFINE_SUB -> EMF_SUB;
                default -> null;
            };
        }
    }
}

