/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.creeperhost.ftbbackups.repack.org.quartz.impl.jdbcjobstore.DBSemaphore;
import net.creeperhost.ftbbackups.repack.org.quartz.impl.jdbcjobstore.LockException;
import net.creeperhost.ftbbackups.repack.org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE SCHED_NAME = {1} AND LOCK_NAME = ? FOR UPDATE";
    public static final String INSERT_LOCK = "INSERT INTO {0}LOCKS(SCHED_NAME, LOCK_NAME) VALUES ({1}, ?)";

    public StdRowLockSemaphore(String tablePrefix, String schedName, String selectWithLockSQL) {
        super(tablePrefix, schedName, selectWithLockSQL != null ? selectWithLockSQL : SELECT_FOR_LOCK, INSERT_LOCK);
    }

    protected void executeSQL(Connection conn, String lockName, String expandedSQL, String expandedInsertSQL) throws LockException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(expandedSQL);
            ps.setString(1, lockName);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
            }
            if (!(rs = ps.executeQuery()).next()) {
                this.getLog().debug("Inserting new lock row for lock: '" + lockName + "' being obtained by thread: " + Thread.currentThread().getName());
                ps = conn.prepareStatement(expandedInsertSQL);
                ps.setString(1, lockName);
                int res = ps.executeUpdate();
                if (res != 1) {
                    throw new SQLException(Util.rtp("No row exists, and one could not be inserted in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix(), this.getSchedulerNameLiteral()));
                }
            }
        }
        catch (SQLException sqle) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName());
            }
            throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String selectWithLockSQL) {
        this.setSQL(selectWithLockSQL);
    }
}

