/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.data;

import java.util.UUID;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.Vec3;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.loader.LevelType;
import net.creeperhost.levelio.loader.SaveInfo;
import org.jetbrains.annotations.Nullable;

public class Player {
    public final UUID uuid;
    public final ICompoundTag playerData;

    public Player(UUID uuid, ICompoundTag playerData) {
        this.uuid = uuid;
        this.playerData = playerData;
    }

    @Nullable
    public Vec3 getPos() {
        IListTag tag;
        if (this.playerData.contains("Pos") && (tag = this.playerData.getList("Pos", 6)).size() == 3) {
            return new Vec3(tag.getDouble(0), tag.getDouble(1), tag.getDouble(2));
        }
        return null;
    }

    @Nullable
    public BlockPos getSpawnPos() {
        if (!(this.playerData.contains("SpawnX") && this.playerData.contains("SpawnY") && this.playerData.contains("SpawnZ"))) {
            return null;
        }
        return new BlockPos(this.playerData.getInt("SpawnX"), this.playerData.getInt("SpawnY"), this.playerData.getInt("SpawnZ"));
    }

    public String getDimension(SaveInfo saveInfo) {
        byte type = this.playerData.getTagType("Dimension");
        if (type == 3) {
            return LevelType.mapDimId(saveInfo, this.playerData.getInt("Dimension"));
        }
        return this.playerData.getString("Dimension");
    }
}

