/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader;

import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveInfo.class);
    private final ICompoundTag levelDat;
    private int dataVersion = -1;

    public SaveInfo(ICompoundTag levelDat) {
        this.levelDat = levelDat;
        ICompoundTag versionTag = levelDat.getCompound("Version");
        if (versionTag.contains("Id")) {
            this.dataVersion = versionTag.getInt("Id");
            if (versionTag.contains("Name")) {
                LOGGER.info("Detected MC Version {}, Data version {}", (Object)versionTag.getString("Name"), (Object)this.dataVersion);
            }
        } else if (levelDat.contains("DataVersion")) {
            this.dataVersion = levelDat.getInt("DataVersion");
            LOGGER.info("Detected Data Version {}", (Object)this.dataVersion);
        } else {
            LOGGER.warn("Unable to detect data version. This most likely means this is a pre 1.9 save.");
            LOGGER.warn("Proceed with caution. Compatability with pre 1.9 versions is not guaranteed.");
        }
        LOGGER.info("Save Name: {}", (Object)this.getSaveName());
        int levelDatVersion = levelDat.getInt("version");
        if (levelDatVersion < 19133) {
            LOGGER.warn("Looks like this is a very old work, Things may break...");
        } else if (levelDatVersion > 19133) {
            LOGGER.warn("Detected new, unknown world version, Depending on whats changed, Things may or may not break...");
        }
    }

    @Nullable
    public String getSaveName() {
        return this.levelDat.contains("LevelName") ? this.levelDat.getString("LevelName") : null;
    }

    public boolean hasDimNames() {
        return this.dataVersion >= 1519;
    }

    public BlockPos getWorldSpawn() {
        return new BlockPos(this.levelDat.getInt("SpawnX"), this.levelDat.getInt("SpawnY"), this.levelDat.getInt("SpawnZ"));
    }
}

