/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader.translator;

public class PaletteDecoders {
    public static int[] decode116(long[] blocks, int paletteSize) {
        int bitsPerIndex = Math.max(4, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
        int shortsPerLong = Math.floorDiv(64, bitsPerIndex);
        int mask = (1 << bitsPerIndex) - 1;
        int[] result = new int[4096];
        int index = 0;
        for (long l : blocks) {
            for (int s = 0; s < shortsPerLong && index < 4096; ++s) {
                result[index++] = (int)l & mask;
                l >>= bitsPerIndex;
            }
        }
        return result;
    }

    public static int[] decode113(long[] blockStates) {
        int[] result = new int[4096];
        int indexBits = blockStates.length * 64 / 4096;
        for (int index = 0; index < result.length; ++index) {
            result[index] = PaletteDecoders.decode113Index(blockStates, index, indexBits);
        }
        return result;
    }

    private static int decode113Index(long[] blockStates, int index, int bitsPerIndex) {
        int startByteBit = bitsPerIndex * index & 0x3F;
        int startIndex = bitsPerIndex * index >> 6;
        int endIndex = bitsPerIndex * (index + 1) - 1 >> 6;
        long bitMask = -1L >>> 64 - bitsPerIndex;
        if (startIndex == endIndex) {
            return (int)(blockStates[startIndex] >>> startByteBit & bitMask);
        }
        return (int)((blockStates[startIndex] >>> startByteBit | blockStates[endIndex] << 64 - startByteBit) & bitMask);
    }
}

