/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader.translator;

import java.io.IOException;
import java.util.HashMap;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Entity;
import net.creeperhost.levelio.data.Section;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.loader.translator.ChunkTranslator;
import net.creeperhost.levelio.loader.translator.PaletteDecoders;

public class Translator118Plus
extends ChunkTranslator {
    public static final ChunkTranslator INSTANCE = new Translator118Plus();

    @Override
    public void readChunkData(Chunk chunk) throws IOException {
        ICompoundTag eTag;
        IListTag entities;
        IListTag tiles;
        ICompoundTag tag = chunk.getChunkTag();
        chunk.inhabitedTime = tag.getLong("InhabitedTime");
        IListTag sections = tag.getList("sections", 10);
        for (int i = 0; i < sections.size(); ++i) {
            ICompoundTag sectionTag = sections.getCompound(i);
            byte sectionY = sectionTag.getByte("Y");
            Section section = new Section(sectionY, chunk);
            section.setLoader(e -> this.populateSection((Section)e, sectionTag));
            chunk.addSection(section);
        }
        IListTag iListTag = tiles = tag.contains("block_entities", 10) ? tag.getList("block_entities", 10) : null;
        if (tiles != null) {
            for (int i = 0; i < tiles.size(); ++i) {
                ICompoundTag tileTag = tiles.getCompound(i);
                chunk.tileData.put(BlockPos.fromTileTag(tileTag), tileTag);
            }
        }
        IListTag iListTag2 = entities = (eTag = chunk.getEntityTag()).contains("Entities", 10) ? eTag.getList("Entities", 10) : null;
        if (entities != null) {
            for (int i = 0; i < entities.size(); ++i) {
                ICompoundTag entityTag = entities.getCompound(i);
                chunk.entities.add(new Entity(entityTag));
            }
        }
    }

    private void populateSection(Section section, ICompoundTag sectionTag) {
        ICompoundTag statesTag = sectionTag.getCompound("block_states");
        if (!statesTag.contains("palette") || !statesTag.contains("data")) {
            return;
        }
        long[] blockStates = statesTag.getLongArray("data");
        IListTag palette = statesTag.getList("palette", 10);
        HashMap<Integer, ICompoundTag> stateMap = new HashMap<Integer, ICompoundTag>();
        for (int i = 0; i < palette.size(); ++i) {
            stateMap.put(i, palette.getCompound(i));
        }
        int[] blocksParsed = PaletteDecoders.decode116(blockStates, palette.size());
        for (int index = 0; index < 4096; ++index) {
            int paletteIndex = blocksParsed[index];
            if (paletteIndex >= palette.size()) {
                Chunk chunk = section.getChunk();
                LOGGER.warn("Block in chunk {} int world {} was not in block palette! This may indicate chunk corruption.", (Object)chunk.pos, (Object)chunk.region.levelInfo.dimFolder.getFileName());
                continue;
            }
            ICompoundTag data = (ICompoundTag)stateMap.get(paletteIndex);
            section.set(index, new Block(data));
        }
    }

    @Override
    public void writeChunkData(Chunk chunk) throws IOException {
    }
}

