/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.client.Point;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.me.items.EncodingModePanel;
import appeng.client.gui.me.items.PatternEncodingTermScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3975;
import net.minecraft.class_5455;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public final class StonecuttingEncodingPanel
extends EncodingModePanel {
    private static final Blitter BG = Blitter.texture("guis/pattern_modes.png").src(0, 141, 126, 68);
    private static final Blitter BG_SLOT = BG.copy().src(126, 141, 16, 18);
    private static final Blitter BG_SLOT_SELECTED = BG.copy().src(126, 159, 16, 18);
    private static final Blitter BG_SLOT_HOVER = BG.copy().src(126, 177, 16, 18);
    private static final int COLS = 4;
    private static final int ROWS = 3;
    private final Scrollbar scrollbar;

    public StonecuttingEncodingPanel(PatternEncodingTermScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.scrollbar = widgets.addScrollBar("stonecuttingPatternModeScrollbar", Scrollbar.SMALL);
        this.scrollbar.setRange(0, 0, 4);
        this.scrollbar.setCaptureMouseWheel(false);
    }

    @Override
    public void updateBeforeRender() {
        int totalRows = (this.menu.getStonecuttingRecipes().size() + 4 - 1) / 4;
        this.scrollbar.setRange(0, totalRows - 3, 3);
    }

    @Override
    public void drawBackgroundLayer(class_332 guiGraphics, class_768 bounds, Point mouse) {
        BG.dest(bounds.method_3321() + 9, bounds.method_3322() + bounds.method_3320() - 164).blit(guiGraphics);
        this.drawRecipes(guiGraphics, bounds, mouse);
    }

    private class_5455 getRegistryAccess() {
        return Objects.requireNonNull(class_310.method_1551().field_1687).method_30349();
    }

    private void drawRecipes(class_332 guiGraphics, class_768 bounds, Point mouse) {
        List<class_3975> recipes = this.menu.getStonecuttingRecipes();
        int startIndex = this.scrollbar.getCurrentScroll() * 4;
        int endIndex = startIndex + 12;
        class_310 minecraft = class_310.method_1551();
        class_2960 selectedRecipe = this.menu.getStonecuttingRecipeId();
        for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
            class_768 slotBounds = this.getRecipeBounds(i - startIndex);
            class_3975 recipe = recipes.get(i);
            boolean selected = selectedRecipe != null && selectedRecipe.equals((Object)recipe.method_8114());
            Blitter blitter = BG_SLOT;
            if (selected) {
                blitter = BG_SLOT_SELECTED;
            } else if (mouse.isIn(slotBounds)) {
                blitter = BG_SLOT_HOVER;
            }
            int renderX = bounds.method_3321() + slotBounds.method_3321();
            int renderY = bounds.method_3322() + slotBounds.method_3322();
            blitter.dest(renderX, renderY - 1).blit(guiGraphics);
            class_1799 resultItem = recipe.method_8110(this.getRegistryAccess());
            guiGraphics.method_51427(resultItem, renderX, renderY);
            guiGraphics.method_51431(class_310.method_1551().field_1772, resultItem, renderX, renderY);
        }
    }

    @Override
    public boolean onMouseDown(Point mousePos, int button) {
        class_3975 recipe = this.getRecipeAt(mousePos);
        if (recipe != null) {
            this.menu.setStonecuttingRecipeId(recipe.method_8114());
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        class_3975 recipe = this.getRecipeAt(new Point(mouseX, mouseY));
        if (recipe != null) {
            List<class_2561> lines = this.screen.method_51454(recipe.method_8110(this.getRegistryAccess()));
            return new Tooltip(lines);
        }
        return null;
    }

    @Nullable
    private class_3975 getRecipeAt(Point point) {
        List<class_3975> recipes = this.menu.getStonecuttingRecipes();
        if (!recipes.isEmpty()) {
            int startIndex = this.scrollbar.getCurrentScroll() * 4;
            int endIndex = startIndex + 12;
            for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
                class_768 slotBounds = this.getRecipeBounds(i - startIndex);
                if (!point.isIn(slotBounds)) continue;
                return recipes.get(i);
            }
        }
        return null;
    }

    private class_768 getRecipeBounds(int index) {
        int col = index % 4;
        int row = index / 4;
        int slotX = this.x + 44 + col * BG_SLOT.getSrcWidth();
        int slotY = this.y + 8 + row * BG_SLOT.getSrcHeight();
        return new class_768(slotX, slotY, BG_SLOT.getSrcWidth(), BG_SLOT.getSrcHeight());
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        return this.scrollbar.onMouseWheel(mousePos, delta);
    }

    @Override
    public class_1799 getTabIconItem() {
        return new class_1799((class_1935)class_1802.field_16305);
    }

    @Override
    public class_2561 getTabTooltip() {
        return GuiText.StonecuttingPattern.text();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.scrollbar.setVisible(visible);
        this.screen.setSlotsHidden(SlotSemantics.STONECUTTING_INPUT, !visible);
    }
}

