/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.InfoBar;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.definitions.AEParts;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.menu.me.crafting.CraftingStatusMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class CPUSelectionList
implements ICompositeWidget {
    private static final int ROWS = 6;
    private final Blitter background;
    private final Blitter buttonBg;
    private final CraftingStatusMenu menu;
    private final Color textColor;
    private final int selectedColor;
    private final Scrollbar scrollbar;
    private class_768 bounds = new class_768(0, 0, 0, 0);

    public CPUSelectionList(CraftingStatusMenu menu, Scrollbar scrollbar, ScreenStyle style) {
        this.menu = menu;
        this.scrollbar = scrollbar;
        this.background = style.getImage("cpuList");
        this.buttonBg = style.getImage("cpuListButton");
        this.textColor = style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        this.selectedColor = style.getColor(PaletteColor.SELECTION_COLOR).toARGB();
        this.scrollbar.setCaptureMouseWheel(false);
    }

    @Override
    public void setPosition(Point position) {
        this.bounds = new class_768(position.getX(), position.getY(), this.bounds.method_3319(), this.bounds.method_3320());
    }

    @Override
    public void setSize(int width, int height) {
        this.bounds = new class_768(this.bounds.method_3321(), this.bounds.method_3322(), width, height);
    }

    @Override
    public class_768 getBounds() {
        return this.bounds;
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        this.scrollbar.onMouseWheel(mousePos, delta);
        return true;
    }

    @Override
    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        CraftingStatusMenu.CraftingCpuListEntry cpu = this.hitTestCpu(new Point(mouseX, mouseY));
        if (cpu != null) {
            GenericStack currentJob;
            class_5250 modeText;
            ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
            tooltipLines.add(this.getCpuName(cpu));
            tooltipLines.add((class_2561)ButtonToolTips.CpuStatusStorage.text(Tooltips.ofBytes(cpu.storage())).method_27692(class_124.field_1080));
            int coProcessors = cpu.coProcessors();
            if (coProcessors == 1) {
                tooltipLines.add((class_2561)ButtonToolTips.CpuStatusCoProcessor.text(Tooltips.ofNumber(coProcessors)).method_27692(class_124.field_1080));
            } else if (coProcessors > 1) {
                tooltipLines.add((class_2561)ButtonToolTips.CpuStatusCoProcessors.text(Tooltips.ofNumber(coProcessors)).method_27692(class_124.field_1080));
            }
            switch (cpu.mode()) {
                case PLAYER_ONLY: {
                    class_5250 class_52502 = ButtonToolTips.CpuSelectionModePlayersOnly.text();
                    break;
                }
                case MACHINE_ONLY: {
                    class_5250 class_52502 = ButtonToolTips.CpuSelectionModeAutomationOnly.text();
                    break;
                }
                default: {
                    class_5250 class_52502 = modeText = null;
                }
            }
            if (modeText != null) {
                tooltipLines.add((class_2561)modeText);
            }
            if ((currentJob = cpu.currentJob()) != null) {
                tooltipLines.add((class_2561)ButtonToolTips.CpuStatusCrafting.text(Tooltips.ofAmount(currentJob)).method_27693(" ").method_10852(currentJob.what().getDisplayName()));
                tooltipLines.add((class_2561)ButtonToolTips.CpuStatusCraftedIn.text(Tooltips.ofPercent(cpu.progress()), Tooltips.ofDuration(cpu.elapsedTimeNanos(), TimeUnit.NANOSECONDS)));
            }
            return new Tooltip(tooltipLines);
        }
        return null;
    }

    @Override
    public boolean onMouseUp(Point mousePos, int button) {
        CraftingStatusMenu.CraftingCpuListEntry cpu = this.hitTestCpu(mousePos);
        if (cpu != null) {
            this.menu.selectCpu(cpu.serial());
            return true;
        }
        return false;
    }

    @Nullable
    private CraftingStatusMenu.CraftingCpuListEntry hitTestCpu(Point mousePos) {
        int relX = mousePos.getX() - this.bounds.method_3321();
        int relY = mousePos.getY() - this.bounds.method_3322();
        if ((relX -= 9) < 0 || relX >= this.buttonBg.getSrcWidth()) {
            return null;
        }
        int buttonIdx = this.scrollbar.getCurrentScroll() + (relY -= 19) / (this.buttonBg.getSrcHeight() + 1);
        if (relY % (this.buttonBg.getSrcHeight() + 1) == this.buttonBg.getSrcHeight()) {
            return null;
        }
        if (relY < 0 || buttonIdx >= this.menu.cpuList.cpus().size()) {
            return null;
        }
        List<CraftingStatusMenu.CraftingCpuListEntry> cpus = this.menu.cpuList.cpus();
        if (buttonIdx >= 0 && buttonIdx < cpus.size()) {
            return cpus.get(buttonIdx);
        }
        return null;
    }

    @Override
    public void updateBeforeRender() {
        int hiddenRows = Math.max(0, this.menu.cpuList.cpus().size() - 6);
        this.scrollbar.setRange(0, hiddenRows, 2);
    }

    @Override
    public void drawBackgroundLayer(class_332 guiGraphics, class_768 bounds, Point mouse) {
        int x = bounds.method_3321() + this.bounds.method_3321();
        int y = bounds.method_3322() + this.bounds.method_3322();
        this.background.dest(x, y, this.bounds.method_3319(), this.bounds.method_3320()).blit(guiGraphics);
        x += 9;
        y += 19;
        class_4587 pose = guiGraphics.method_51448();
        class_327 font = class_310.method_1551().field_1772;
        List<CraftingStatusMenu.CraftingCpuListEntry> cpus = this.menu.cpuList.cpus().subList(class_3532.method_15340((int)this.scrollbar.getCurrentScroll(), (int)0, (int)this.menu.cpuList.cpus().size()), class_3532.method_15340((int)(this.scrollbar.getCurrentScroll() + 6), (int)0, (int)this.menu.cpuList.cpus().size()));
        for (CraftingStatusMenu.CraftingCpuListEntry cpu : cpus) {
            int color = -1;
            if (cpu.serial() == this.menu.getSelectedCpuSerial()) {
                color = this.selectedColor;
            }
            this.buttonBg.dest(x, y).colorRgb(color).blit(guiGraphics);
            class_2561 name = this.getCpuName(cpu);
            pose.method_22903();
            pose.method_46416((float)(x + 3), (float)(y + 3), 0.0f);
            pose.method_22905(0.8f, 0.8f, 1.0f);
            guiGraphics.method_51439(font, name, 0, 0, this.textColor.toARGB(), false);
            pose.method_22909();
            InfoBar infoBar = new InfoBar();
            GenericStack currentJob = cpu.currentJob();
            if (currentJob != null) {
                infoBar.add(Icon.CRAFT_HAMMER, 0.6f);
                infoBar.addSpace(2);
                String craftAmt = currentJob.what().formatAmount(currentJob.amount(), AmountFormat.SLOT);
                infoBar.add(craftAmt, this.textColor.toARGB(), 0.6f);
                infoBar.addSpace(1);
                infoBar.add(currentJob.what(), 0.6f);
                int progress = (int)(cpu.progress() * (float)(this.buttonBg.getSrcWidth() - 1));
                guiGraphics.method_25294(x + 1, y + this.buttonBg.getSrcHeight() - 2, x + progress, y + this.buttonBg.getSrcHeight() - 1, this.menu.getSelectedCpuSerial() == cpu.serial() ? -1 : -16777216 + this.selectedColor);
            } else {
                infoBar.add(Icon.LEVEL_ITEM, 0.6f);
                infoBar.addSpace(1);
                String storageAmount = this.formatStorage(cpu);
                infoBar.add(storageAmount, this.textColor.toARGB(), 0.6f);
                infoBar.addSpace(1);
                if (cpu.coProcessors() > 0) {
                    infoBar.add(Icon.BLOCKING_MODE_NO, 0.6f);
                    String coProcessorCount = String.valueOf(cpu.coProcessors());
                    infoBar.add(coProcessorCount, this.textColor.toARGB(), 0.6f);
                    infoBar.addSpace(1);
                }
                switch (cpu.mode()) {
                    case PLAYER_ONLY: {
                        infoBar.add(AEParts.TERMINAL, 0.6f);
                        break;
                    }
                    case MACHINE_ONLY: {
                        infoBar.add(AEParts.EXPORT_BUS, 0.6f);
                    }
                }
            }
            infoBar.render(guiGraphics, x + 2, y + this.buttonBg.getSrcHeight() - 12);
            y += this.buttonBg.getSrcHeight() + 1;
        }
    }

    private String formatStorage(CraftingStatusMenu.CraftingCpuListEntry cpu) {
        return cpu.storage() / 1024L + "k";
    }

    private class_2561 getCpuName(CraftingStatusMenu.CraftingCpuListEntry cpu) {
        return cpu.name() != null ? cpu.name() : GuiText.CPUs.text().method_27693(String.format(" #%d", cpu.serial()));
    }
}

