/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.indices;

import appeng.client.guidebook.GuidePageChange;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.PageIndex;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIndex<K, V>
implements PageIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIndex.class);
    private final Map<K, Record<V>> index = new HashMap<K, Record<V>>();
    private final String name;
    private final EntryFunction<K, V> entryFunction;
    private final PageIndex.JsonSerializer<K> keySerializer;
    private final PageIndex.JsonSerializer<V> valueSerializer;
    private boolean hadDuplicates;

    public UniqueIndex(String name, EntryFunction<K, V> entryFunction, PageIndex.JsonSerializer<K> keySerializer, PageIndex.JsonSerializer<V> valueSerializer) {
        this.name = name;
        this.entryFunction = entryFunction;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public V get(K key) {
        Record<V> entry = this.index.get(key);
        if (entry != null) {
            return entry.value();
        }
        return null;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public void rebuild(List<ParsedGuidePage> pages) {
        this.index.clear();
        this.hadDuplicates = false;
        for (ParsedGuidePage page : pages) {
            this.addToIndex(page);
        }
    }

    @Override
    public void update(List<ParsedGuidePage> allPages, List<GuidePageChange> changes) {
        if (this.hadDuplicates) {
            this.rebuild(allPages);
            return;
        }
        Set idsToRemove = changes.stream().map(GuidePageChange::pageId).collect(Collectors.toSet());
        this.index.values().removeIf(p -> idsToRemove.contains(p.pageId));
        for (GuidePageChange change : changes) {
            ParsedGuidePage newPage = change.newPage();
            if (newPage == null) continue;
            this.addToIndex(newPage);
        }
    }

    private void addToIndex(ParsedGuidePage page) {
        for (Pair<K, V> entry : this.entryFunction.getEntry(page)) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Record<Object> previousPage = this.index.put(key, new Record<Object>(page.getId(), value));
            if (previousPage == null) continue;
            LOGGER.warn("Key conflict in index {}: {} is used by pages {} and {}", new Object[]{this.name, key, page, previousPage});
            this.hadDuplicates = true;
        }
    }

    @Override
    public void export(JsonWriter writer) throws IOException {
        writer.beginArray();
        for (Map.Entry<K, Record<V>> entry : this.index.entrySet()) {
            this.keySerializer.write(writer, entry.getKey());
            this.valueSerializer.write(writer, entry.getValue().value());
        }
        writer.endArray();
    }

    @FunctionalInterface
    public static interface EntryFunction<K, V> {
        public Iterable<Pair<K, V>> getEntry(ParsedGuidePage var1);
    }

    private record Record<V>(class_2960 pageId, V value) {
    }
}

