/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.client.guidebook.document.LytSize;
import appeng.core.AppEng;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidePageTexture {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuidePageTexture.class);
    private static final Map<GuidePageTexture, class_1043> usedTextures = new IdentityHashMap<GuidePageTexture, class_1043>();
    private final class_2960 id;
    private final ByteBuffer imageContent;
    private final LytSize size;

    public static GuidePageTexture missing() {
        return new GuidePageTexture(AppEng.makeId("missing"), null);
    }

    private GuidePageTexture(class_2960 id, byte @Nullable [] imageContent) {
        this.id = Objects.requireNonNull(id, "id");
        if (imageContent == null) {
            this.imageContent = null;
            this.size = new LytSize(32, 32);
        } else {
            this.imageContent = ByteBuffer.allocateDirect(imageContent.length);
            this.imageContent.put(imageContent).flip();
            int[] xOut = new int[1];
            int[] yOut = new int[1];
            int[] compOut = new int[1];
            if (!STBImage.stbi_info_from_memory((ByteBuffer)this.imageContent, (int[])xOut, (int[])yOut, (int[])compOut)) {
                throw new IllegalArgumentException("Couldn't determine size of image " + id + ": " + STBImage.stbi_failure_reason());
            }
            this.size = new LytSize(xOut[0], yOut[0]);
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public LytSize getSize() {
        return this.size;
    }

    public static GuidePageTexture load(class_2960 id, byte[] imageContent) {
        try {
            return new GuidePageTexture(id, imageContent);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get image {}: {}", (Object)id, (Object)e.toString());
            return GuidePageTexture.missing();
        }
    }

    public class_1044 use() {
        return (class_1044)usedTextures.computeIfAbsent(this, guidePageTexture -> {
            if (guidePageTexture.imageContent == null) {
                return class_1047.method_4540();
            }
            try {
                class_1011 nativeImage = class_1011.method_4324((ByteBuffer)guidePageTexture.imageContent);
                return new class_1043(nativeImage);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read image {}: {}", (Object)guidePageTexture.id, (Object)e.toString());
                return class_1047.method_4540();
            }
        });
    }

    public static void releaseUsedTextures() {
        for (class_1043 texture : usedTextures.values()) {
            if (texture == class_1047.method_4540()) continue;
            texture.close();
        }
        usedTextures.clear();
    }
}

