/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2405;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;
import net.minecraft.class_7784;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldGenProvider
implements class_2405 {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldGenProvider.class);
    private final class_7784 output;
    private final CompletableFuture<class_7225.class_7874> registries;

    public WorldGenProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registries.thenComposeAsync(provider -> {
            class_6903 dynamicOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)provider);
            CompletableFuture[] futures = (CompletableFuture[])class_7655.field_39968.stream().map(info -> this.writeRegistryEntries(writer, (class_7225.class_7874)provider, (DynamicOps<JsonElement>)dynamicOps, (class_7655.class_7657)info)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures);
        });
    }

    private <T> CompletableFuture<Void> writeRegistryEntries(class_7403 writer, class_7225.class_7874 provider, DynamicOps<JsonElement> ops, class_7655.class_7657<T> registryData) {
        class_5321 registryKey = registryData.comp_985();
        class_7225.class_7226 registry = provider.method_46759(registryKey).orElse(null);
        if (registry == null) {
            return CompletableFuture.completedFuture(null);
        }
        class_7784.class_7489 pathResolver = this.output.method_45973(class_7784.class_7490.field_39367, registryKey.method_29177().method_12832());
        CompletableFuture[] futures = (CompletableFuture[])registry.method_42017().flatMap(regEntry -> {
            class_5321 key = regEntry.method_40237();
            if (!key.method_29177().method_12836().equals("ae2")) {
                return Stream.empty();
            }
            Path path = pathResolver.method_44107(key.method_29177());
            return WorldGenProvider.writeToPath(path, writer, ops, registryData.comp_986(), regEntry.comp_349()).stream();
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private static <E> Optional<CompletableFuture<?>> writeToPath(Path path, class_7403 cache, DynamicOps<JsonElement> json, Encoder<E> encoder, E value) {
        Optional optional = encoder.encodeStart(json, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        return optional.map(data -> class_2405.method_10320((class_7403)cache, (JsonElement)data, (Path)path));
    }

    public String method_10321() {
        return "AE2 Worldgen";
    }
}

